package com.bcxin.tenant.data.etc.tasks.components;

import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

import java.io.Serializable;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class JedisPoolFactory implements Serializable {
    private final Logger logger = LoggerFactory.getLogger(JedisPoolFactory.class);
    private static JedisPool jedisPool;
    private static JedisPool getJedisPoolInstance(RedisConfig redisConfig) {
        if (jedisPool != null) {
            return jedisPool;
        }

        synchronized (JedisPoolFactory.class) {
            if (jedisPool == null) {
                JedisPoolConfig config = new JedisPoolConfig();
                config.setMaxTotal(100);
                config.setMinIdle(2);

                config.setMaxWait(Duration.of(20, ChronoUnit.SECONDS));
                jedisPool = new JedisPool(config, redisConfig.getHost(), redisConfig.getPort(),
                        redisConfig.getTimout(), redisConfig.getPassword()
                );
            }

            return jedisPool;
        }
    }

    public Jedis getDefaultJedis(RedisConfig config) {
        Jedis jedis = getJedisPoolInstance(config).getResource();
        jedis.select(3);

        logger.error("创建RedisJedis实例对象");

        return jedis;
    }

    private static JedisPoolFactory jedisPoolFactory;
    public static JedisPoolFactory getInstance() {
        if (jedisPoolFactory == null) {
            jedisPoolFactory = new JedisPoolFactory();
        }

        synchronized (JedisPoolFactory.class) {
            if (jedisPoolFactory == null) {
                jedisPoolFactory = new JedisPoolFactory();
            }

            return jedisPoolFactory;
        }
    }

    public static String getRedisFormatKey(String businessKey) {
        return String.format("flink:cdc:%s", businessKey);
    }
}
