package com.bcxin.tenant.data.etc.tasks.components;

import lombok.Data;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.tuple.Tuple2;

import java.io.Serializable;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Data
public class JdbcParameterWrapper implements Serializable {
    private List<int[]> parameterIndexes;
    private List<String> parameterNames;
    private String sql;
    private String originalSql ;
    private Map<Integer, Tuple2<Integer,String>> parameterAscIndexNameMap = null;

    public Map<Integer, Tuple2<Integer,String>> getParameterAscIndexNameMap() {
        if (parameterAscIndexNameMap == null || parameterAscIndexNameMap.isEmpty()) {
            parameterAscIndexNameMap = new HashMap<>();
            List<int[]> sortedParIndexes = parameterIndexes.stream().sorted((r1, r2) -> (r1[0] < r2[0] ? -1 : 1)).collect(Collectors.toList());
            int index = 0;
            for (int[] item : sortedParIndexes) {
                String fieldName = this.originalSql.substring(item[0], item[1]).substring(1);
                parameterAscIndexNameMap.put(item[0], Tuple2.of(index, fieldName));
                index++;
            }
        }

        return parameterAscIndexNameMap;
    }

    public static JdbcParameterWrapper create(
            String originalSql,
            String sql,
            List<int[]> parameterIndexes,List<String> parameterNames) {
        JdbcParameterWrapper wrapper = new JdbcParameterWrapper();
        wrapper.setParameterNames(parameterNames);
        wrapper.setParameterIndexes(parameterIndexes);
        wrapper.setSql(sql);
        wrapper.setOriginalSql(originalSql);

        return wrapper;
    }
}
