package com.bcxin.tenant.data.etc.tasks.components;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.JsonProviderImpl;
import com.bcxin.tenant.data.etc.tasks.properties.DataEtcConfigProperty;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.jdbc.JdbcExecutionOptions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.*;

public class CustomRedisJdbcSinkRichOutFormat extends RichOutputFormat<BinlogRawValue> implements Serializable {

    private final Queue<BinlogRawValue> batch = new LinkedBlockingQueue<>();
    private final DataEtcConfigProperty.RedisConnectionConfigProperty configProperty;
    private final DataEtcConfigProperty.JdbcSubscriberContentConfigProperty subscriberContentConfigProperty;
    private final JdbcExecutionOptions executionOptions;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private transient Exception flushException;
    private final JsonProvider jsonProvider;

    public CustomRedisJdbcSinkRichOutFormat(JdbcExecutionOptions executionOptions,
                                            DataEtcConfigProperty.RedisConnectionConfigProperty configProperty,
                                            DataEtcConfigProperty.JdbcSubscriberContentConfigProperty subscriberContentConfigProperty) {
        this.configProperty = configProperty;
        this.executionOptions = executionOptions;
        this.subscriberContentConfigProperty = subscriberContentConfigProperty;
        this.jsonProvider = new JsonProviderImpl();
    }


    @Override
    public void configure(Configuration parameters) {

    }

    @Override
    public void open(int taskNumber, int numTasks) throws IOException {
        this.scheduler =
                Executors.newScheduledThreadPool(
                        1, new ExecutorThreadFactory("jdbc-upsert-output-format"));
        this.scheduledFuture =
                this.scheduler.scheduleWithFixedDelay(
                        () -> {
                            synchronized (CustomRedisJdbcSinkRichOutFormat.this) {
                                try {
                                    flush();
                                } catch (Exception e) {
                                    flushException = e;
                                }
                            }
                        },
                        executionOptions.getBatchIntervalMs(),
                        executionOptions.getBatchIntervalMs(),
                        TimeUnit.MILLISECONDS);
    }

    @Override
    public void writeRecord(BinlogRawValue record) throws IOException {
        this.batch.add(record);

        if (this.batch.size() >= executionOptions.getBatchSize()) {
            this.flush();
            this.batch.clear();
        }
    }

    @Override
    public void close() throws IOException {

    }

    private void flush() {
        Collection<BinlogRawValue> data = new ArrayList<>();
        while (this.batch.size() > 0) {
            data.add(this.batch.poll());
        }


    }
}
