package com.bcxin.tenant.data.etc.tasks.components;

import lombok.Getter;
import org.apache.flink.connector.jdbc.JdbcConnectionOptions;

import java.io.Serializable;
import java.util.List;

@Getter
public class CustomJdbcOutputFormatParameterWrapper implements Serializable {
    private final List<String> parameterNames;
    private final JdbcConnectionOptions jdbcConnectionOptions;
    private final List<int[]> parameterIndexes;
    private final String sql;

    public CustomJdbcOutputFormatParameterWrapper(List<String> parameterNames,
                                                  JdbcConnectionOptions jdbcConnectionOptions,
                                                  List<int[]> parameterIndexes, String sql) {
        this.parameterNames = parameterNames;
        this.jdbcConnectionOptions = jdbcConnectionOptions;
        this.parameterIndexes = parameterIndexes;
        this.sql = sql;
    }

    public static CustomJdbcOutputFormatParameterWrapper create(List<String> parameterNames,
                                                                JdbcConnectionOptions jdbcConnectionOptions,
                                                                List<int[]> parameterIndexes, String sql) {
        return new CustomJdbcOutputFormatParameterWrapper(
                parameterNames, jdbcConnectionOptions, parameterIndexes, sql);
    }
}
