package com.bcxin.tenant.data.etc.tasks.components;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.event.core.FlinkConstants;
import com.bcxin.event.core.JsonProvider;
import com.bcxin.event.core.exceptions.BadEventException;
import com.bcxin.event.core.exceptions.NoFoundEventException;
import com.bcxin.event.core.utils.DebeziumUtil;
import com.bcxin.event.job.core.domain.CacheProvider;
import com.bcxin.event.job.core.domain.DockMapDbExtractor;
import com.bcxin.flink.streaming.cores.utils.DebeziumJsonNodeDtoUtils;
import com.bcxin.tenant.data.etc.tasks.components.builder.DataBuilderDecorator;
import com.googlecode.aviator.AviatorEvaluator;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import java.io.Serializable;
import java.time.Instant;
import java.util.*;
import java.util.stream.Collectors;

@Data
public class BinlogRawValue implements Serializable {
    public static final String FIELD_ID="id";
    public static final String FIELD_FULL_TABLE="fullTable";
    public static final String FIELD_LAST_SYNC_VERSION="lastSyncVersion";
    public static final String FIELD_PARTITION="partition";

    private static final Logger logger = LoggerFactory.getLogger(BinlogRawValue.class);
    /**
     * 这个表的格式是: db.tableName; 不能添加
     */
    private String fullTable;
    private String id;
    private Date lastSyncVersion;

    private byte[] value;
    private int partition;

    public BinlogRawValue() {
    }

    public static BinlogRawValue create(byte[] value, JsonProvider jsonProvider) {
        BinlogRawValue rawValue = new BinlogRawValue();
        rawValue.setValue(value);
        rawValue.setLastSyncVersion(new Date());

        JSONObject contentNode =
                jsonProvider.toObject(JSONObject.class, new String(value));
        rawValue.setLastSyncVersion(DebeziumJsonNodeDtoUtils.getLastSyncTimeValue(contentNode));

        JSONObject dataNode = contentNode.getJSONObject("after");
        if (dataNode == null) {
            dataNode = contentNode.getJSONObject("before");
        }

        if (dataNode == null) {
            throw new BadEventException(String.format("无效节点数据:%s", new String(value)));
        }

        Optional<String> selectedIdOptional = dataNode.keySet().stream()
                .filter(ix -> ix.equalsIgnoreCase("id"))
                .findFirst();
        if (!selectedIdOptional.isPresent()) {
            selectedIdOptional = dataNode.keySet().stream()
                    .filter(ix -> ix.replace("_", "")
                            .equalsIgnoreCase("pkid"))
                    .findFirst();
        }
        if (!selectedIdOptional.isPresent()) {
            throw new BadEventException("找不到主键配置; 请修改源码后重新部署");
        }

        rawValue.setId(String.valueOf(dataNode.get(selectedIdOptional.get())));

        JSONObject sourceDataNode = contentNode.getJSONObject("source");
        String fullTable = String.format("%s.%s",
                sourceDataNode.get("db"),
                sourceDataNode.get("table")).toLowerCase();
        rawValue.setFullTable(fullTable);

        return rawValue;
    }

    public void assignPartition(int partition) {
        this.setPartition(partition);
    }


    public Map<String, Object> getParameters(JsonProvider jsonProvider, CacheProvider cacheProvider, DockMapDbExtractor dbExtractor, boolean hasDependencyTable) {
        if (_parameters == null) {
            _parameters = getOriginalParameters(jsonProvider);
        }

        if (hasDependencyTable) {
            final String hasAddedParameter = "hasAddedParameter";
            if (_parameters != null && !_parameters.containsKey(hasAddedParameter)) {
                String tableName = (String) getOriginalParameters(jsonProvider)
                        .get("source.table");
                if (org.springframework.util.StringUtils.hasLength(tableName)) {
                    if (false) {
                        Map<String, String> additionalParameters = getExtendParameters();
                        if (!CollectionUtils.isEmpty(additionalParameters)) {
                            for (String key : additionalParameters.keySet()) {
                                _parameters.put(key, additionalParameters.get(key));
                            }
                        }
                        return _parameters;
                    } else {
                        try {
                            Map<String, Object> pv = DataBuilderDecorator.getInstance().build(cacheProvider, _parameters, tableName, dbExtractor);
                            if(pv!=null) {
                                pv.put("Decorator.Wrapper", true);
                            }
                            
                            return pv;
                        } catch (NoFoundEventException ex) {
                            String id = "";
                            Optional<String> idOptional =
                                    _parameters.keySet().stream()
                                            .filter(ix -> ix.equalsIgnoreCase("pkId") || ix.equalsIgnoreCase("pk_id"))
                                            .findFirst();
                            if (idOptional.isPresent()) {
                                id = String.valueOf(_parameters.get(idOptional.get()));
                            } else {
                                idOptional =
                                        _parameters.keySet().stream()
                                                .filter(ix -> ix.equalsIgnoreCase("id"))
                                                .findFirst();

                                if (idOptional.isPresent()) {
                                    id = String.valueOf(_parameters.get(idOptional.get()));
                                }
                            }

                            logger.error("无效[table={}]的(id={})异常数据({}):取不到对应的值(原参数={})", tableName, id,
                                    ExceptionUtils.getMessage(ex), new String(this.getValue()));
                        }
                    }
                }

                _parameters.put(hasAddedParameter, Instant.now());
            }
        }

        return _parameters;
    }

    private Map<String, Object> _parameters;

    public Map<String, Object> getOriginalParameters(JsonProvider jsonProvider) {
        if (_parameters == null) {
            String jsonValue = new String(this.getValue());
            JSONObject valueJsonObject = jsonProvider.toObject(JSONObject.class, jsonValue);

            _parameters = new HashMap<>();
            _parameters.put(BinlogRawValue.FIELD_ID, this.getId());
            _parameters.put(BinlogRawValue.FIELD_FULL_TABLE, this.getFullTable());
            _parameters.put(BinlogRawValue.FIELD_PARTITION, this.getPartition());
            _parameters.put(BinlogRawValue.FIELD_LAST_SYNC_VERSION, this.getLastSyncVersion());

            _parameters = buildParameters(_parameters, "before", valueJsonObject.getJSONObject("before"));
            _parameters = buildParameters(_parameters, "after", valueJsonObject.getJSONObject("after"));
            _parameters = buildParameters(_parameters, "source", valueJsonObject.getJSONObject("source"));
        }

        return _parameters;
    }

    private Map<String, Object> buildParameters(
            Map<String, Object> map,
            String prefix, JSONObject node) {
        if (node == null) {
            return map;
        }

        Iterator<String> iterator = node.keySet().iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                String nodeKey = iterator.next();
                String key = nodeKey.toLowerCase();
                if (!StringUtils.isEmpty(prefix)) {
                    key = String.format("%s.%s", prefix, nodeKey);
                }

                Object nodeValue = node.get(nodeKey);
                if (nodeValue == null) {
                    map.put(key, null);
                    continue;
                }
                if (FlinkConstants.isDateTimeField(nodeKey) && (String.valueOf(nodeValue).contains("0000-00-00") || String.valueOf(nodeValue).contains("9999-"))) {
                    nodeValue = null;
                }

                if (nodeValue instanceof Number) {
                    try {
                        if (FlinkConstants.isDateTimeField(nodeKey)) {
                            /**时间戳，数据库中字段是datetime类型。在读取binlog的时候，时间是往前加了8小时，这里再减掉*/
                            Date date = new Date(getTimeValue(nodeKey, nodeValue));
                            map.put(key, DateUtils.addHours(date,-8));
                        } else {
                            map.put(key, nodeValue);
                        }
                    } catch (Exception ex) {
                        map.put(key, nodeValue);
                    }
                    continue;
                }

                /**if((nodeValue instanceof  String) && FlinkConstants.isDateTimeField(key)){
                    try {
                        nodeValue =  new Date(DataBuilderAbstract.getTimeValue(key, nodeValue));
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }*/

                map.put(key, nodeValue);
            }
        }

        return map;
    }

    private static long getTimeValue(String key, Object value) {
        try {
            String xValue = String.valueOf(value);
            if (xValue.length() < 8) {
                return DebeziumUtil.translate2ValueInMils(Long.parseLong(String.valueOf(value)));
            }

            return Long.parseLong(String.valueOf(value));
        } catch (Exception ex) {
            logger.error("key={};value={};转换出错=%s;尝试转为Double", key, value, ex);
            return (long) Double.parseDouble(String.valueOf(value));
        }
    }

    public Object getReadyParameter(String name) {
        if (CollectionUtils.isEmpty(this._parameters)) {
            throw new BadEventException("无效数据");
        }

        Optional<String> keyOptional = this._parameters.keySet().stream().filter(ix -> {
                    String key = ix;
                    String expected = name;

                    return (key.equalsIgnoreCase(expected) ||
                            key.equalsIgnoreCase(String.format("before.%s", expected)) ||
                            key.equalsIgnoreCase(String.format("after.%s", expected)));
                }
        ).findFirst();

        if (!keyOptional.isPresent()) {
            return null;
        }

        return this._parameters.get(keyOptional.get());
    }

    public Object getReadyPkId() {
        Object id = this.getReadyParameter("before.id");
        if (id == null) {
            id = this.getReadyParameter("after.id");
        }
        if (id == null) {
            id = this.getReadyParameter("before.pk_id");
        }
        if (id == null) {
            id = this.getReadyParameter("after.pk_id");
        }
        if (id == null) {
            id = this.getReadyParameter("before.pkId");
        }
        if (id == null) {
            id = this.getReadyParameter("after.pkId");
        }

        return id;
    }

    public Object getReadyTable() {
        Object table = this.getReadyParameter("source.table");

        return table;
    }

    protected Map<String, String> getExtendParameters() {
        return Collections.EMPTY_MAP;
    }

    /**
     * 验证是否满足执行条件, 默认是执行;
     *
     * @param jsonProvider
     * @param batchOrConditionExpress
     * @return
     */
    public boolean isMatchCondition(JsonProvider jsonProvider,
                                    Collection<String> batchOrConditionExpress) {
        Map<String, Object> params = this.getOriginalParameters(jsonProvider);

        if (!CollectionUtils.isEmpty(batchOrConditionExpress)) {
            String conditionExpress = null;
            try {
                conditionExpress =
                        batchOrConditionExpress.stream()
                                .filter(ii -> !StringUtils.isEmpty(ii))
                                .map(ii -> {
                                    Collection<String> variables = Arrays.stream(ii.split("}"))
                                            .map(ix -> {
                                                if (ix.startsWith("#{")) {
                                                    return ix;
                                                } else if (ix.contains("#{")) {
                                                    return ix.substring(ix.indexOf("#"));
                                                } else {
                                                    return null;
                                                }
                                            })
                                            .filter(ix -> ix != null)
                                            .collect(Collectors.toList());
                                    String express = ii;
                                    for (String vKey : variables) {
                                        Optional<String> keyOptional =
                                                params.keySet().stream()
                                                        .filter(ix -> ix.equalsIgnoreCase(vKey.substring(2)))
                                                        .findFirst();
                                        if (keyOptional.isPresent()) {
                                            Object kValue = params.get(keyOptional.get());
                                            express = express.replace(String.format("%s}", vKey), kValue == null ? "\"\"" : String.format("\"%s\"", kValue));
                                        } else {
                                            express = express.replace(String.format("%s}", vKey), "\"\"");
                                        }
                                    }

                                    return express;
                                }).collect(Collectors.joining(" || "));

                Object result =
                        AviatorEvaluator.execute(conditionExpress);

                boolean flag = (result != null && !String.valueOf(result).equalsIgnoreCase("false"));

                this.setConditionExecuteResult(
                        String.format("原来表达式=【%s】;解析后表达式=【%s】; 解析后值=【%s】; 返回结果=【%s】;",
                                batchOrConditionExpress.stream().filter(ix -> !StringUtils.isEmpty(ix))
                                        .collect(Collectors.joining(";")),
                                conditionExpress,
                                result, flag));

                return flag;
            } catch (Exception ex) {
                logger.error("条件匹配执行发生异常:{};conditionExpress={}; 异常={}",
                        batchOrConditionExpress.stream()
                                .collect(Collectors.joining(" ; ")),
                        conditionExpress,
                        ex);
            }
        }

        return true;
    }

    private transient String conditionExecuteResult;
}
