/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.proerpties;

import java.io.Serializable;

public class KafkaConfigProperty
implements Serializable {
    private final String bootstrapServer;
    private final String topicPrefix;
    private final String consumerGroupId;

    public KafkaConfigProperty(String bootstrapServer, String topicPrefix, String consumerGroupId) {
        this.bootstrapServer = bootstrapServer;
        this.topicPrefix = topicPrefix;
        this.consumerGroupId = consumerGroupId;
        if (this.getTopicPrefix() == null || this.getTopicPrefix() == "") {
            throw new IllegalArgumentException("kafka.cdc.topic.prefix \u4e3b\u9898\u524d\u7f6e\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static KafkaConfigProperty create(String bootstrapServer, String topicPrefix, String consumerGroupId) {
        return new KafkaConfigProperty(bootstrapServer, topicPrefix, consumerGroupId);
    }

    public String getActualTopicName(String dbName, String tableName) {
        return this.getTopicPrefix().replace("[dbName]", dbName).replace("[tableName]", tableName);
    }

    public String getBootstrapServer() {
        return this.bootstrapServer;
    }

    public String getTopicPrefix() {
        return this.topicPrefix;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }
}

