/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.flink.cdc.kafka.source.task.cdcs.dynamic;

import com.bcxin.flink.cdc.kafka.source.task.cdcs.dynamic.DynamicDbCollectionMongoSink;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.mongodb.common.config.MongoConnectionOptions;
import org.apache.flink.connector.mongodb.sink.config.MongoWriteOptions;
import org.apache.flink.connector.mongodb.sink.writer.serializer.MongoSerializationSchema;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

public class DynamicDbCollectionMongoSinkBuilder<IN> {
    private final MongoConnectionOptions.MongoConnectionOptionsBuilder connectionOptionsBuilder = MongoConnectionOptions.builder();
    private final MongoWriteOptions.MongoWriteOptionsBuilder writeOptionsBuilder = MongoWriteOptions.builder();
    private MongoSerializationSchema<IN> serializationSchema;

    public DynamicDbCollectionMongoSinkBuilder<IN> setUri(String uri) {
        this.connectionOptionsBuilder.setUri(uri);
        return this;
    }

    public DynamicDbCollectionMongoSinkBuilder<IN> setDatabase(String database) {
        this.connectionOptionsBuilder.setDatabase(database);
        return this;
    }

    public DynamicDbCollectionMongoSinkBuilder<IN> setCollection(String collection) {
        this.connectionOptionsBuilder.setCollection(collection);
        return this;
    }

    public DynamicDbCollectionMongoSinkBuilder<IN> setBatchSize(int batchSize) {
        this.writeOptionsBuilder.setBatchSize(batchSize);
        return this;
    }

    public DynamicDbCollectionMongoSinkBuilder<IN> setBatchIntervalMs(long batchIntervalMs) {
        this.writeOptionsBuilder.setBatchIntervalMs(batchIntervalMs);
        return this;
    }

    public DynamicDbCollectionMongoSinkBuilder<IN> setMaxRetries(int maxRetries) {
        this.writeOptionsBuilder.setMaxRetries(maxRetries);
        return this;
    }

    public DynamicDbCollectionMongoSinkBuilder<IN> setDeliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
        this.writeOptionsBuilder.setDeliveryGuarantee(deliveryGuarantee);
        return this;
    }

    public DynamicDbCollectionMongoSinkBuilder<IN> setSerializationSchema(MongoSerializationSchema<IN> serializationSchema) {
        Preconditions.checkNotNull(serializationSchema);
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable(serializationSchema), (Object)"The mongo serialization schema must be serializable.");
        this.serializationSchema = serializationSchema;
        return this;
    }

    public DynamicDbCollectionMongoSink<IN> build(String[] tables) {
        Preconditions.checkNotNull(this.serializationSchema, (String)"The serialization schema must be supplied");
        MongoConnectionOptions connectionOptions = this.connectionOptionsBuilder.build();
        this.ensurePkIndex(connectionOptions, tables);
        return new DynamicDbCollectionMongoSink<IN>(connectionOptions, this.writeOptionsBuilder.build(), this.serializationSchema);
    }

    private void ensurePkIndex(MongoConnectionOptions connectionOptions, String[] tables) {
    }
}

