package com.bcxin.flink.cdc.kafka.source.task.jobs;

import com.bcxin.flink.cdc.kafka.source.task.JobContext;
import com.bcxin.flink.cdc.kafka.source.task.cdcs.BinlogCdcValue;
import com.bcxin.flink.cdc.kafka.source.task.cdcs.BinlogOffsetValue;
import com.bcxin.flink.cdc.kafka.source.task.compnents.WebHttpSinkWriter;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.Constants;
import com.bcxin.flink.streaming.cores.DataSourceUtil;
import com.bcxin.flink.streaming.cores.JdbcJobExecutorUtil;
import com.bcxin.flink.streaming.cores.dtos.JdbcConnectionDto;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.api.connector.sink2.SinkWriter;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;

import java.io.IOException;
import java.sql.Connection;
import java.util.Properties;

/**
 * 通过CDC直接推送数据到目标系统: 比如: 子站
 */
public class DbStreamCdcHttpSinkJob extends DbStreamCdcJobAbstract {

    @Override
    protected void executeCoreAction(StreamExecutionEnvironment env,
                                     SingleOutputStreamOperator<BinlogCdcValue> dataStreamSource,
                                     BinlogOffsetValue binlogOffsetValue) {
        JobContext jobContext = JobContext.getInstance();
        Properties properties = System.getProperties();

        String driverClassName =
                System.getProperties().getProperty("datasource.driver-class-name");
        String url =
                System.getProperties().getProperty("datasource.url");
        String userName =
                System.getProperties().getProperty("datasource.username");
        String password =
                System.getProperties().getProperty("datasource.password");

        dataStreamSource.addSink(new RichSinkFunction<BinlogCdcValue>() {
            private WebHttpSinkWriter webHttpSinkWriter;
            private Connection connection;

            @Override
            public void open(Configuration parameters) throws Exception {
                super.open(parameters);
                this.connection = JdbcJobExecutorUtil.getConnection(
                        JdbcConnectionDto.create(driverClassName, url, userName, password)
                );
                webHttpSinkWriter = new WebHttpSinkWriter(
                        5000, 10_000,
                        jobContext.getHttpRegionSinkProperties(),
                        properties.getProperty(Constants.KAFKA_CDC_TOPIC_PREFIX),
                        connection);
            }

            @Override
            public void close() throws Exception {
                if(this.connection!=null && !this.connection.isClosed()) {
                    this.connection.close();
                }

                this.webHttpSinkWriter.close();

                super.close();
            }

            @Override
            public void invoke(BinlogCdcValue value, Context context) throws Exception {
                //super.invoke(value, context);
                this.webHttpSinkWriter.write(value.getValue(), null);
            }
        });
    }

    @Override
    protected String getJobPrefixTitle() {
        return "2httpSink";
    }
}
