package com.bcxin.flink.cdc.kafka.source.task;

import com.bcxin.event.job.core.domain.JedisPoolFactory;
import com.bcxin.event.job.core.domain.dtos.RedisConfig;
import com.bcxin.flink.cdc.kafka.source.task.cdcs.BinlogOffsetValue;
import com.bcxin.flink.cdc.kafka.source.task.proerpties.CdcDatabaseSourceProperty;
import com.bcxin.flink.streaming.cores.TableConstant;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import redis.clients.jedis.Jedis;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StartupOptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(StartupOptionUtil.class);
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET="mysql:flink:checkpoints:cdc:redis_ms_binlog_file_name_offset_gt_ids";
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME="redis_ms_binlog_file_name_offset_file_name";
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME_LAST_TABLE="redis_ms_binlog_file_name_offset_file_name_last_table";
    public static final String REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_OFFSET_VALUE="redis_ms_binlog_file_name_offset_offset_value";
    public static final String REDIS_MS_BINLOG_GT_IDS_VALUE="redis_ms_binlog_gt_ids_value";

    /**
     * 实验证明; 明显offset的方式是无效的; 因为binlog文件一直在变
     * @param binlogOffsetValue
     * @return
     */
    public static StartupOptions calculateStartupOption(BinlogOffsetValue binlogOffsetValue) {
        /**
         * 测试环境, 临时设置
         */
        if(true) {
            return StartupOptions.latest();
        }
        if (binlogOffsetValue != null) {
            if (!StringUtils.hasLength(binlogOffsetValue.getGtIds())) {
                return StartupOptions.specificOffset(binlogOffsetValue.getFile(), binlogOffsetValue.getOffset());
            } else {
                return StartupOptions.specificOffset(binlogOffsetValue.getGtIds());
            }
        }

        final String startupOption_EARLIEST = "earliest";
        final String startupOption_LATEST = "latest";
        final String startupOption_INITIAL = "initial";
        final Collection<String> allowedStartOptionValues
                = Stream.of(startupOption_EARLIEST, startupOption_LATEST, startupOption_INITIAL)
                .collect(Collectors.toList());

        String startupOptionValue = System.getProperty(TableConstant.PARAM_BINLOG_STARTUP_OPTION);
        /**
         * 对于非允许的选项; 则设置为1天的offset
         */
        if (!StringUtils.hasLength(startupOptionValue) ||
                !allowedStartOptionValues.contains(startupOptionValue.toLowerCase())
        ) {
            /**
             * 从前一天开始重新offset(默认向前推迟10分钟)
             */
            if (!org.apache.commons.lang3.StringUtils.isNumeric(startupOptionValue)) {
                startupOptionValue = "10";
            }
        }

        if (startupOptionValue.equalsIgnoreCase(startupOption_EARLIEST)) {
            return StartupOptions.earliest();
        }

        if (startupOptionValue.equalsIgnoreCase(startupOption_LATEST)) {
            return StartupOptions.latest();
        }

        if (startupOptionValue.equalsIgnoreCase(startupOption_INITIAL)) {
            return StartupOptions.initial();
        }

        /**
         * 默认从昨天开始重新来抓取offset
         */
        Calendar current = Calendar.getInstance();
        current.setTime(new Date());
        current.add(Calendar.MINUTE, 0 - Integer.parseInt(startupOptionValue));
        return StartupOptions.timestamp(current.getTimeInMillis());
    }

    public static BinlogOffsetValue getBinlogOffsetValue(RedisConfig redisConfig,
                                                         CdcDatabaseSourceProperty databaseSourceProperty) {
        try (Jedis jedis = JedisPoolFactory.getNewJedisResource(redisConfig)) {
            Map<String, String> offsetMap
                    = jedis.hgetAll(StartupOptionUtil.REDIS_MS_BINLOG_FILE_NAME_OFFSET);

            if (offsetMap != null) {
                String offset = offsetMap.get(REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_OFFSET_VALUE);
                if (org.apache.commons.lang3.StringUtils.isNumeric(offset)) {
                    long lastOffsetFromRedis = Long.parseLong(offset);
                    String grIds = offsetMap.get(REDIS_MS_BINLOG_GT_IDS_VALUE);

                    BinlogOffsetValue offsetValue = BinlogOffsetValue.create(
                            offsetMap.get(REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME),
                            lastOffsetFromRedis,
                            grIds
                    );
                    logger.error("初始化-读取到的Binlog信息为:file={};pos={};",
                            offsetMap.get(REDIS_MS_BINLOG_FILE_NAME_OFFSET_BINLOG_FILE_NAME),
                            lastOffsetFromRedis);
                    return offsetValue;
                }
            }
        }

        /**
         * 我们在核验checkpoint是否可用的时候; 我们的binlog file
         *  MySqlConnection.availableBinlogFiles 来验证是否有效
         */
        return null;
    }
}
