package com.bcxin.event.job.domain.entities;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import org.apache.ibatis.type.JdbcType;

import java.sql.Timestamp;
import java.time.Instant;

@Data
@TableName(value = "flink_jdbc_definitions",autoResultMap = true)
public class JdbcDefinitionEntity extends TableEntityAbstract {
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    @TableField(insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String name;
    @TableField(value = "drive_class_name",insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String driveClassName;
    @TableField(insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String url;
    @TableField(value = "user_name",insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String userName;
    @TableField(insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String password;
    @TableField(value = "server_time_zone",insertStrategy = FieldStrategy.NOT_EMPTY, updateStrategy = FieldStrategy.NOT_EMPTY)
    private String connectionTimeZone;

    @TableField(value = "last_updated_time", jdbcType = JdbcType.TIMESTAMP,updateStrategy = FieldStrategy.NOT_NULL)
    private Timestamp lastUpdatedTime;

    @TableField(value = "created_time", jdbcType = JdbcType.TIMESTAMP,updateStrategy = FieldStrategy.NOT_NULL)
    private Timestamp createdTime;

    public void change(String name,String driveClassName,String url,
                       String userName,String password,
                       String connectionTimeZone)
    {
        this.setName(name);
        this.setDriveClassName(driveClassName);
        this.setUrl(url);
        this.setUserName(userName);
        this.setPassword(password);
        this.setConnectionTimeZone(connectionTimeZone);
    }

    public JdbcDefinitionEntity() {
        this.setLastUpdatedTime(Timestamp.from(Instant.now()));
        this.setCreatedTime(Timestamp.from(Instant.now()));
    }

    public static JdbcDefinitionEntity create(String name,String driveClassName,String url,
                                              String userName,String password,
                                              String connectionTimeZone) {
        JdbcDefinitionEntity jdbcDefinition = new JdbcDefinitionEntity();
        jdbcDefinition.change(name, driveClassName, url, userName, password, connectionTimeZone);

        return jdbcDefinition;
    }
}
