/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.enums.PayComponentCatStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.wechat.video.PayComponentCat;
import com.zbkj.common.model.wechat.video.PayComponentShopBrand;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.wxvedio.cat.PayComponentCatPageListRequest;
import com.zbkj.common.utils.RedisUtil;
import com.zbkj.common.vo.wxvedioshop.cat_brand.CatItem;
import com.zbkj.common.vo.wxvedioshop.cat_brand.FirstCatVo;
import com.zbkj.common.vo.wxvedioshop.cat_brand.SecondCatVo;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ShopCatDetailVo;
import com.zbkj.common.vo.wxvedioshop.cat_brand.ThirdCatVo;
import com.zbkj.service.dao.PayComponentCatDao;
import com.zbkj.service.service.PayComponentCatService;
import com.zbkj.service.service.PayComponentShopBrandService;
import com.zbkj.service.service.WechatVideoSpuService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class PayComponentCatServiceImpl
extends ServiceImpl<PayComponentCatDao, PayComponentCat>
implements PayComponentCatService {
    private final Logger logger = LoggerFactory.getLogger(PayComponentCatServiceImpl.class);
    @Resource
    private PayComponentCatDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private WechatVideoSpuService wechatVideoSpuService;
    @Autowired
    private PayComponentShopBrandService payComponentShopBrandService;
    @Autowired
    private RedisUtil redisUtil;
    private final String PAY_COMPONENT_CAT_LIST = "pay_component_cat_list";

    @Override
    public List<CatItem> getTreeList() {
        if (!this.redisUtil.exists("pay_component_cat_list").booleanValue()) {
            this.autoUpdate();
        }
        String catJsonStr = (String)this.redisUtil.get("pay_component_cat_list");
        List firstCatVoList = JSONArray.parseArray((String)catJsonStr, CatItem.class);
        return firstCatVoList;
    }

    @Override
    public List<PayComponentCat> getList(PayComponentCatPageListRequest payComponentCat, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)payComponentCat.getCatName())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.like(PayComponentCat::getFirstCatName, (Object)URLUtil.decode((String)payComponentCat.getCatName()))).or()).like(PayComponentCat::getSecondCatName, (Object)URLUtil.decode((String)payComponentCat.getCatName()))).or()).like(PayComponentCat::getThirdCatName, (Object)URLUtil.decode((String)payComponentCat.getCatName()));
        }
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public PayComponentCat getByThirdCatId(Integer thirdCatId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentCat::getThirdCatId, (Object)thirdCatId);
        return (PayComponentCat)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public PayComponentCat getByAudit(String audit) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(PayComponentCat::getAuditId, (Object)audit);
        return (PayComponentCat)this.dao.selectOne((Wrapper)lqw);
    }

    @Override
    public void getAuditResultOrAuditCallBack(JSONObject jsonObject, String auditId) {
        this.logger.info("\u7c7b\u76ee\u5ba1\u6838\u67e5\u8be2\u6216\u8005\u56de\u8c03 start :{}", (Object)jsonObject.toJSONString());
        if (ObjectUtil.isNull((Object)auditId)) {
            auditId = jsonObject.getString("audit_id");
        }
        Integer status = jsonObject.getInteger("status");
        String rejectReason = jsonObject.getString("reject_reason");
        PayComponentCat byAudit = this.getByAudit(auditId);
        if (ObjectUtil.isNotNull((Object)byAudit)) {
            this.logger.info("\u5f53\u524d\u7684\u5ba1\u6838\u7c7b\u76ee:{}", (Object)JSON.toJSONString((Object)byAudit));
            LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
            if (status == 1) {
                lambdaUpdateWrapper.set(PayComponentCat::getStatus, (Object)PayComponentCatStatusEnum.WECHAT_REVIEW_SUCCESS.getCode());
            } else {
                lambdaUpdateWrapper.set(PayComponentCat::getStatus, (Object)PayComponentCatStatusEnum.WECHAT_REVIEW_FAILED.getCode());
                lambdaUpdateWrapper.set(PayComponentCat::getRejectReason, (Object)rejectReason);
            }
            lambdaUpdateWrapper.eq(PayComponentCat::getAuditId, (Object)auditId);
            this.update((Wrapper)lambdaUpdateWrapper);
        } else {
            LambdaUpdateWrapper lambdaUpdateWrapperShopBrand = Wrappers.lambdaUpdate();
            if (status == 9) {
                lambdaUpdateWrapperShopBrand.set(PayComponentShopBrand::getStatus, (Object)9);
                lambdaUpdateWrapperShopBrand.set(PayComponentShopBrand::getRejectReason, (Object)rejectReason);
            } else {
                lambdaUpdateWrapperShopBrand.set(PayComponentShopBrand::getStatus, (Object)status);
            }
            lambdaUpdateWrapperShopBrand.eq(PayComponentShopBrand::getAuditId, (Object)auditId);
            this.payComponentShopBrandService.update((Wrapper)lambdaUpdateWrapperShopBrand);
        }
        this.logger.info("\u7c7b\u76ee\u548c\u54c1\u724c\u5ba1\u6838\u67e5\u8be2\u6216\u8005\u56de\u8c03 end :auditId:{}", (Object)auditId);
    }

    @Override
    public void autoUpdate() {
        List<ShopCatDetailVo> catDetailVoList = this.wechatVideoSpuService.getShopCat();
        if (CollUtil.isEmpty(catDetailVoList)) {
            this.logger.info("\u5fae\u4fe1\u672a\u8fd4\u56de\u7c7b\u76ee\u4fe1\u606f");
            return;
        }
        LambdaQueryWrapper lqwCanUse = Wrappers.lambdaQuery();
        lqwCanUse.eq(PayComponentCat::getStatus, (Object)PayComponentCatStatusEnum.WECHAT_REVIEW_SUCCESS.getCode());
        List payComponentCats = this.dao.selectList((Wrapper)lqwCanUse);
        this.logger.info("\u540c\u6b65\u6240\u6709\u7c7b\u76ee\uff0c\u6709\u6743\u9650\u548c\u9ed8\u8ba4\u4e0d\u9700\u8981\u6743\u9650\u7684:{}", (Object)JSON.toJSONString((Object)payComponentCats));
        List<PayComponentCat> catList = catDetailVoList.stream().map(e -> {
            PayComponentCat payComponentCat = new PayComponentCat();
            BeanUtils.copyProperties((Object)e, (Object)payComponentCat);
            return payComponentCat;
        }).collect(Collectors.toList());
        Boolean execute = (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.deleteAll();
            this.saveBatch(catList);
            return Boolean.TRUE;
        });
        if (!execute.booleanValue()) {
            throw new CrmebException("\u81ea\u52a8\u66f4\u65b0\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u7c7b\u76ee,\u64cd\u4f5c\u6570\u636e\u5e93\u65f6\u51fa\u9519");
        }
        Boolean updateCatRedis = this.updateCatRedis(catList);
        if (!updateCatRedis.booleanValue()) {
            throw new CrmebException("\u81ea\u52a8\u66f4\u65b0\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u7c7b\u76ee,\u64cd\u4f5cRedis\u65f6\u51fa\u9519");
        }
        this.logger.info(StrUtil.format((CharSequence)"\u81ea\u52a8\u66f4\u65b0\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u7c7b\u76ee\u6210\u529f\uff0c\u65f6\u95f4{}", (Object[])new Object[]{DateUtil.now()}));
    }

    private Boolean updateCatRedis(List<PayComponentCat> catList) {
        List<CatItem> catVoList = this.assembleRedisDataForFront(catList);
        if (this.redisUtil.exists("pay_component_cat_list").booleanValue()) {
            this.redisUtil.delete(new String[]{"pay_component_cat_list"});
        }
        return this.redisUtil.set("pay_component_cat_list", (Object)JSONArray.toJSONString(catVoList));
    }

    private List<FirstCatVo> assembleRedisData(List<PayComponentCat> catList) {
        HashMap firstMap = CollUtil.newHashMap();
        catList.forEach(e -> {
            if (!firstMap.containsKey(e.getFirstCatId())) {
                firstMap.put(e.getFirstCatId(), e.getFirstCatName());
            }
        });
        ArrayList voList = CollUtil.newArrayList((Object[])new FirstCatVo[0]);
        firstMap.forEach((k, v) -> {
            FirstCatVo firstCatVo = new FirstCatVo();
            firstCatVo.setFirstCatId(k);
            firstCatVo.setFirstCatName(v);
            voList.add(firstCatVo);
        });
        voList.forEach(e -> {
            HashMap secondMap = CollUtil.newHashMap();
            catList.stream().filter(a -> a.getFirstCatId().equals(e.getFirstCatId())).forEach(cat -> {
                if (!secondMap.containsKey(cat.getSecondCatId())) {
                    secondMap.put(cat.getSecondCatId(), cat.getSecondCatName());
                }
            });
            ArrayList secondCatVoList = CollUtil.newArrayList((Object[])new SecondCatVo[0]);
            secondMap.forEach((k, v) -> {
                SecondCatVo secondCatVo = new SecondCatVo();
                secondCatVo.setSecondCatId(k);
                secondCatVo.setSecondCatName(v);
                secondCatVoList.add(secondCatVo);
            });
            secondCatVoList.forEach(b -> {
                List thirdCatVoList = catList.stream().filter(i -> i.getSecondCatId().equals(b.getSecondCatId())).map(o -> {
                    ThirdCatVo thirdCatVo = new ThirdCatVo();
                    thirdCatVo.setThirdCatId(o.getThirdCatId());
                    thirdCatVo.setThirdCatName(o.getThirdCatName());
                    thirdCatVo.setQualification(o.getQualification());
                    thirdCatVo.setQualificationType(o.getQualificationType());
                    thirdCatVo.setProductQualification(o.getProductQualification());
                    thirdCatVo.setProductQualificationType(o.getProductQualificationType());
                    return thirdCatVo;
                }).collect(Collectors.toList());
                b.setThirdCatList(thirdCatVoList);
            });
            e.setSecondCatList((List)secondCatVoList);
        });
        return voList;
    }

    private List<CatItem> assembleRedisDataForFront(List<PayComponentCat> catList) {
        HashMap firstMap = CollUtil.newHashMap();
        catList.forEach(e -> {
            if (!firstMap.containsKey(e.getFirstCatId())) {
                firstMap.put(e.getFirstCatId(), e.getFirstCatName());
            }
        });
        ArrayList catItem1s = CollUtil.newArrayList((Object[])new CatItem[0]);
        firstMap.forEach((k, v) -> catItem1s.add(new CatItem(k, v, new ArrayList())));
        catItem1s.forEach(e -> {
            HashMap secondMap = CollUtil.newHashMap();
            catList.stream().filter(a -> a.getFirstCatId().equals(e.getValue())).forEach(cat -> {
                if (!secondMap.containsKey(cat.getSecondCatId())) {
                    secondMap.put(cat.getSecondCatId(), cat.getSecondCatName());
                }
            });
            ArrayList catItem2s = CollUtil.newArrayList((Object[])new CatItem[0]);
            secondMap.forEach((k, v) -> {
                CatItem item = new CatItem();
                item.setLabel(v);
                item.setValue(k);
                catItem2s.add(item);
            });
            catItem2s.forEach(b -> {
                ArrayList catItem3s = CollUtil.newArrayList((Object[])new CatItem[0]);
                List thirdCatVoList = catList.stream().filter(i -> i.getSecondCatId().equals(b.getValue())).map(o -> {
                    ThirdCatVo thirdCatVo = new ThirdCatVo();
                    CatItem item = new CatItem();
                    item.setLabel(o.getThirdCatName());
                    item.setValue(o.getThirdCatId());
                    item.setQualification(o.getQualification());
                    item.setQualificationType(o.getQualificationType());
                    item.setProductQualification(o.getProductQualification());
                    item.setProductQualificationType(o.getProductQualificationType());
                    item.setStatus(o.getStatus());
                    catItem3s.add(item);
                    return thirdCatVo;
                }).collect(Collectors.toList());
                b.setChildren((List)catItem3s);
            });
            e.setChildren((List)catItem2s);
        });
        return catItem1s;
    }
}

