/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.model.bcx.BcxDepartment;
import com.zbkj.common.response.BcxDepartmentMemberResponse;
import com.zbkj.common.response.BcxDepartmentResponse;
import com.zbkj.service.dao.BcxDepartmentDao;
import com.zbkj.service.service.BcxDepartmentService;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BcxDepartmentServiceImpl
extends ServiceImpl<BcxDepartmentDao, BcxDepartment>
implements BcxDepartmentService {
    @Resource
    private BcxDepartmentDao dao;

    @Override
    public List<BcxDepartmentResponse> findAllTree() {
        List allList = this.list();
        List<BcxDepartmentResponse> responseList = allList.stream().map(this::getBcxDepartmentResponse).collect(Collectors.toList());
        List<BcxDepartmentResponse> rootList = this.getBcxDepartmentResponseTree(responseList);
        return rootList;
    }

    @Override
    public List<BcxDepartmentResponse> findAllTreeWithMember(List<BcxDepartmentMemberResponse> memberResponseList) {
        List allList = this.list();
        List<BcxDepartmentResponse> responseList = allList.stream().map(this::getBcxDepartmentResponse).collect(Collectors.toList());
        for (BcxDepartmentResponse response : responseList) {
            for (BcxDepartmentMemberResponse memberResponse : memberResponseList) {
                if (response.getId().longValue() != memberResponse.getDeptId().longValue()) continue;
                response.addMember(memberResponse);
            }
        }
        List<BcxDepartmentResponse> rootList = this.getBcxDepartmentResponseTree(responseList);
        return rootList;
    }

    private List<BcxDepartmentResponse> getBcxDepartmentResponseTree(List<BcxDepartmentResponse> responseList) {
        Map responseMap = responseList.stream().collect(Collectors.toMap(BcxDepartmentResponse::getDeptCode, Function.identity()));
        for (BcxDepartmentResponse response : responseList) {
            BcxDepartmentResponse parent = (BcxDepartmentResponse)responseMap.get(response.getParentCode());
            if (parent == null) continue;
            parent.addChildren(response);
        }
        return responseList.stream().filter(dept -> dept.getParentCode().equals("0")).collect(Collectors.toList());
    }

    private BcxDepartmentResponse getBcxDepartmentResponse(BcxDepartment department) {
        BcxDepartmentResponse response = new BcxDepartmentResponse();
        response.setId(department.getId());
        response.setDeptCode(department.getCode());
        response.setParentCode(department.getParentCode());
        response.setDeptName(department.getName());
        return response;
    }

    @Override
    public BcxDepartment findByBcxId(String bcxId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"bcx_id", (Object)bcxId);
        return (BcxDepartment)this.getOne((Wrapper)queryWrapper);
    }
}

