package com.zbkj.common.response;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.zbkj.common.utils.DateConverter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "CommonOrderPageResponse对象", description = "通用订单分页列表响应对象")
public class CommonOrderPageResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单号")
    @ColumnWidth(50)
    @ExcelProperty(value = "订单号", order = 0)
    private String orderNo;

    @ApiModelProperty(value = "商品名称")
    @ColumnWidth(50)
    @ExcelProperty(value = "商品名称", order = 2)
    private String productName;

    @ApiModelProperty(value = "实际支付金额")
    @ColumnWidth(50)
    @ExcelProperty(value = "实际支付金额", order = 4)
    private BigDecimal payPrice;

    @ApiModelProperty(value = "支付方式:weixin,alipay...")
    @ColumnWidth(50)
    @ExcelProperty("支付方式")
    private String payType;

    @ApiModelProperty(value = "订单状态（0：待支付，1：待发货,2：部分发货， 3：待核销，4：待收货,5：已收货,6：已完成，9：已取消）")
    @ExcelIgnore
    private Integer status;
    @ExcelProperty("订单状态")
    private String statusStr;
    public String getStatusStr() {
        if (status == null) {
            return "";
        }
        switch (status) {
            case 0:
                return "待支付";
            case 1:
                return "待发货";
            case 2:
                return "部分发货";
            case 3:
                return "待核销";
            case 4:
                return "待收货";
            case 5:
                return "已收货";
            case 6:
                return "已完成";
            case 9:
                return "已取消";
            default:
                return "";
        }
    }

    @ApiModelProperty(value = "退款状态：0 未退款 1 申请中 2 部分退款 3 已退款")
    @ExcelIgnore
    private Integer refundStatus;
    @ExcelProperty("退款状态")
    private String refundStatusStr;
    public String getRefundStatusStr() {
        if (refundStatus == null) {
            return "";
        }
        switch (refundStatus) {
            case 0:
                return "未退款";
            case 1:
                return "申请中";
            case 2:
                return "部分退款";
            case 3:
                return "已退款";
            default:
                return "";
        }
    }

    @ApiModelProperty(value = "取消状态：0-未取消，1-系统取消，2-用户取消")
    @ExcelIgnore
    private Integer cancelStatus;
    @ExcelProperty("取消状态")
    private String cancelStatusStr;
    public String getCancelStatusStr() {
        if (cancelStatus == null) {
            return "";
        }
        switch (cancelStatus) {
            case 0:
                return "未取消";
            case 1:
                return "系统取消";
            case 2:
                return "用户取消";
            default:
                return "";
        }
    }

    @ApiModelProperty(value = "用户是否删除")
    @ExcelIgnore
    private Boolean isUserDel;
    @ExcelProperty("用户是否删除")
    private String isUserDelStr;
    public String getIsUserDelStr() {
        if (isUserDel == null) {
            return "";
        }
        return isUserDel ? "是" : "否";
    }

    @ApiModelProperty(value = "订单类型:0-普通订单，1-视频号订单，2-秒杀订单，50-e站风评订单")
    @ExcelIgnore
    private Integer type;
    @ExcelProperty("订单类型")
    private String typeStr;
    public String getTypeStr() {
        if (type == null) {
            return "";
        }
        switch (type) {
            case 0:
                return "普通订单";
            case 1:
                return "视频号订单";
            case 2:
                return "秒杀订单";
            case 50:
                return "e站风评订单";
            default:
                return "";
        }
    }

    @ApiModelProperty(value = "订单等级:0-主订单，1-商户订单，2-商户子订单")
    @ExcelIgnore
    private Integer level;
    @ExcelProperty("订单等级")
    private String levelStr;
    public String getLevelStr() {
        if (level == null) {
            return "";
        }
        switch (level) {
            case 0:
                return "主订单";
            case 1:
                return "商户订单";
            case 2:
                return "商户子订单";
            default:
                return "";
        }
    }

    @ApiModelProperty(value = "用户备注")
    @ColumnWidth(50)
    @ExcelProperty("用户备注")
    private String userRemark;

    @ApiModelProperty(value = "商户备注")
    @ColumnWidth(50)
    @ExcelProperty("商户备注")
    private String merRemark;

    @ApiModelProperty(value = "创建时间")
    @ColumnWidth(50)
    @ExcelProperty(value = "创建时间", converter = DateConverter.class)
    private Date createTime;

    @ApiModelProperty(value = "配送方式 0=无需配送，1=快递 ，2=门店自提")
    @ExcelIgnore
    private Integer shippingType;
    @ExcelProperty("配送方式")
    private String shippingTypeStr;
    public String getShippingTypeStr() {
        if (shippingType == null) {
            return "";
        }
        switch (shippingType) {
            case 0:
                return "无需配送";
            case 1:
                return "快递";
            case 2:
                return "门店自提";
            default:
                return "";
        }
    }

    @ApiModelProperty(value = "用户昵称")
    @ColumnWidth(50)
    @ExcelProperty("用户昵称")
    private String nickName;

    @ApiModelProperty(value = "用户是否注销")
    @ExcelIgnore
    private Boolean isLogoff;
    @ExcelProperty("用户是否注销")
    private String isLogoffStr;
    public String getIsLogoffStr() {
        if (isLogoff == null) {
            return "";
        }
        return isLogoff ? "是" : "否";
    }

    @ApiModelProperty(value = "保费类型 0-保单保费 1-保全保费")
    @ExcelIgnore
    private Integer insuranceType;
    @ExcelProperty("保费类型")
    private String insuranceTypeStr;
    public String getInsuranceTypeStr() {
        if (insuranceType == null) {
            return "";
        }
        switch (insuranceType) {
            case 0:
                return "保单保费";
            case 1:
                return "保全保费";
            default:
                return "";
        }
    }
}
