package com.zbkj.common.response;

import com.zbkj.common.model.product.Product;
import com.zbkj.common.model.product.ProductAttr;
import com.zbkj.common.model.product.ProductDescription;
import com.zbkj.common.model.product.ProductGuarantee;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

/**
 * PC端商品详情响应对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxProductDetailResponse对象", description = "PC端商品详情响应对象")
public class BcxProductDetailResponse implements Serializable {

    private static final long serialVersionUID = 1976534L;

    @ApiModelProperty(value = "商品信息")
    private BcxProductInfoResponse productInfo;

    @ApiModelProperty(value = "可购数量 null-不限购 数值-限购数量")
    private Integer quota;

    @ApiModelProperty(value = "产品属性")
    private List<ProductAttr> productAttr;

    @ApiModelProperty(value = "商品属性详情")
    private HashMap<String, ProductAttrValueResponse> productValue;

//    @ApiModelProperty(value = "商户信息")
//    private ProductMerchantResponse merchantInfo;

    @ApiModelProperty(value = "商品描述")
    private List<ProductDescription> descriptions;

    @ApiModelProperty(value = "客服热线")
    private String consumerHotline;

    @ApiModelProperty(value = "用户协议")
    private String userAgreement;

    @ApiModelProperty(value = "隐私协议")
    private String privacyAgreement;
}
