package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * description: 业绩报表统计 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxPerformanceReportStatisticsResponse对象", description = "业绩报表统计 response对象")
public class BcxPerformanceReportStatisticsResponse implements Serializable {


    @ApiModelProperty(value = "总笔数")
    private Integer totalCount;

    @ApiModelProperty(value = "总成交金额")
    private BigDecimal totalPayPrice;

    @ApiModelProperty(value = "总佣金")
    private BigDecimal totalBrokeragePrice;

}