package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 发票抬头请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxFapiaoTitleRequest对象", description = "发票抬头请求对象")
public class BcxFapiaoTitleRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "发票抬头id")
    private Integer id;

    @ApiModelProperty(value = "0-个人 1-企业", required = true)
    @NotNull(message = "请选择个人或企业抬头类型")
    private Integer titleType;

    @ApiModelProperty(value = "0-增值税普通 1-增值税专用", required = true)
    @NotNull(message = "请选择发票类型")
    private Integer fapiaoType;

    @ApiModelProperty(value = "发票抬头", required = true)
    @NotEmpty(message = "请输入发票抬头")
    private String title;

    @ApiModelProperty(value = "税号")
    @NotEmpty(groups = {CompanyPlainGroup.class, CompanyDedicatedGroup.class}, message = "请输入税号")
    private String taxNo;

    @ApiModelProperty(value = "邮箱")
    @Email(message = "请输入正确的邮箱")
    private String email;

    @ApiModelProperty(value = "开户银行")
    @NotEmpty(groups = CompanyDedicatedGroup.class, message = "请输入开户银行")
    private String bankName;

    @ApiModelProperty(value = "银行账号")
    @NotEmpty(groups = CompanyDedicatedGroup.class, message = "请输入银行账号")
    private String bankAccount;

    @ApiModelProperty(value = "企业地址")
    @NotEmpty(groups = CompanyDedicatedGroup.class, message = "请输入企业地址")
    private String address;

    @ApiModelProperty(value = "企业电话")
    @NotEmpty(groups = CompanyDedicatedGroup.class, message = "请输入企业电话")
    private String phone;

    @ApiModelProperty(value = "0-否 1-默认抬头")
    private Boolean isDefault;

    /**
     * 企业普通 增值税发票类型校验
     */

    public interface CompanyPlainGroup {
    }

    /**
     * 企业专用 增值税发票类型校验
     */
    public interface CompanyDedicatedGroup {
    }
}