package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * bcxToken登录请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="BcxTokenLoginRequest对象", description="使用bcxToken登录获取token")
public class BcxTokenLoginRequest implements Serializable {

    private static final long serialVersionUID=13626524L;

    @ApiModelProperty(value = "bcxToken", required = true)
    @NotBlank(message = "bcxToken不能为空")
    private String bcxToken;

    @ApiModelProperty(value = "推广人id")
    private Integer spreadPid = 0;
}
