package com.zbkj.common.dto;

import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.model.product.Product;
import com.zbkj.common.response.BcxBrokerageConfigResponse;
import lombok.Data;

import java.math.BigDecimal;

/**
 * description：佣金配置快照dto
 * author：linchunpeng
 * date：2023/8/11
 */
@Data
public class BrokerageConfigSnapshotDto {

    //订单
    private Order order;
    //订单明细
    private OrderDetail orderDetail;
    //商品
    private Product product;
    //佣金配置，渠道/部门/部门明细才有
    private BcxBrokerageConfigResponse bcxBrokerageConfig;
    //是否冲突打折
    private Boolean isDiscount;
    //当前最大可分佣金额
    private BigDecimal maxBrokeragePrice;

    public BrokerageConfigSnapshotDto() {
    }

    public BrokerageConfigSnapshotDto(Order order, OrderDetail orderDetail, Product product) {
        this.order = order;
        this.orderDetail = orderDetail;
        this.product = product;
    }
}
