package com.zbkj.common.response;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * description: 佣金配置基础 response对象
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxBrokerageLoadResponse对象", description = "佣金配置基础 response对象")
public class BcxBrokerageLoadResponse implements Serializable {

    @ApiModelProperty(value = "佣金计算方式：0默认配置，1单独设置")
    private Integer isSub;

    @ApiModelProperty(value = "商品最大分佣比例")
    private Integer maxBrokerage;

    @ApiModelProperty(value = "分销一级返佣比例")
    private Integer retailStoreBrokerageFirstRatio;

    @ApiModelProperty(value = "分销二级返佣比例")
    private Integer retailStoreBrokerageSecondRatio;

    @ApiModelProperty(value = "渠道佣金设置列表")
    private List<BcxBrokerageConfigResponse> configChannelList;

    @ApiModelProperty(value = "部门佣金设置列表")
    private List<BcxBrokerageConfigResponse> configDepartmentList;

    @ApiModelProperty(value = "部门成员佣金设置列表")
    private List<BcxBrokerageConfigResponse> configDepartmentMemberList;

}