package com.zbkj.common.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 导入保险订单请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="ImportInsuranceOrderRequest对象", description="导入保险订单请求对象")
public class BatchInsuranceOrderRequest implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单唯一编号", required = true)
    @NotBlank(message = "订单唯一编号不能为空")
    private String sourceId;

    @ApiModelProperty(value = "区域编码")
    private String regionCode;

    @ApiModelProperty(value = "商品编码/对应商城商品规格中的商品条码", required = true)
    @NotBlank(message = "商品编码不能为空")
    private String productCode;

    @ApiModelProperty(value = "购买数量", required = true)
    private Integer payNum;

    @ApiModelProperty(value = "实际支付金额", required = true)
    private BigDecimal payPrice;

    @ApiModelProperty(value = "校验码(sourceId的jwt)", required = true)
    @NotBlank(message = "校验码不能为空")
    private String verify;

    @ApiModelProperty(value = "企业识别号", required = true)
    @NotBlank(message = "企业识别号")
    private String identityCardNo;

    @ApiModelProperty(value = "保费类型 0-保单保费 1-保全保费 搜索用")
    private Integer insuranceType;
}
