package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 平台服务费
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_platform_fee")
@ApiModel(value = "BcxPlatformFee对象", description = "平台服务费")
public class BcxPlatformFee implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "平台服务费id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "平台费单号")
    private String orderNo;

    @ApiModelProperty(value = "平台费类型： 0-订单  1-分期单")
    private Integer orderType;

    @ApiModelProperty(value = "平台费")
    private BigDecimal platFee;

    @ApiModelProperty(value = "分账优先级 0-平台 1-商户")
    private Integer transPriority;

    @ApiModelProperty(value = "原始配置")
    private String config;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
