package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * description: 佣金绩效配置表
 * author : linchunpeng
 * date : 2023/8/3
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_brokerage_config")
@ApiModel(value = "BcxBrokerageConfig对象", description = "佣金绩效配置表")
public class BcxBrokerageConfig implements Serializable {
    
    @ApiModelProperty(value = "主键id")
    @TableId(value = "id")
    private Long id;
    
    @ApiModelProperty(value = "商品id（为空表示默认配置，不为空表示某个商品单独配置）")
    private Integer productId;

    @ApiModelProperty(value = "关联id：渠道表id，部门表id，部门成员表id")
    private Long belongId;
    
    @ApiModelProperty(value = "关联类型：1渠道表，2部门表，3部门成员表")
    private Integer belongType;

    @ApiModelProperty(value = "渠道类型：1业务渠道，2区域渠道")
    private Integer channelType;

    @ApiModelProperty(value = "佣金类型：1比例，2固定，3自留")
    private Integer type;

    @ApiModelProperty(value = "佣金比例")
    private BigDecimal ratio;

    @ApiModelProperty(value = "服务佣金")
    private BigDecimal serviceRatio;

    @ApiModelProperty(value = "计算系数，默认100%")
    private BigDecimal calculateRatio;

    @ApiModelProperty(value = "状态：0无效，1有效")
    private Integer status;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
    

}