package com.zbkj.common.enums;

/**
 * description：佣金类型：1比例，2固定，3自留
 * author：linchunpeng
 * date：2023/10/25
 */
public enum BrokerageConfigTypeEnum {

    RATIO("比例", 1),
    FIXATION("固定", 2),
    RETENTION("自留", 3);

    private final String name;
    private final Integer value;

    BrokerageConfigTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

    public static BrokerageConfigTypeEnum getInstance(int value) {
        switch (value) {
            case 1:
                return RATIO;
            case 2:
                return FIXATION;
            case 3:
                return RETENTION;
        }
        return RATIO;
    }
}
