package com.zbkj.common.enums;

/**
 * description：账单结算状态：1待结算，2部分结算，3已结算
 * author：linchunpeng
 * date：2023/8/4
 */
public enum BcxBillSettleStatusEnum {

    WAIT_SETTLED("待结算", 1),
    PART_SETTLED("部分结算", 2),
    SETTLED("已结算", 3);

    private final String name;
    private final Integer value;

    BcxBillSettleStatusEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

    public static BcxBillSettleStatusEnum getInstance(int value) {
        switch (value) {
            case 1:
                return WAIT_SETTLED;
            case 2:
                return PART_SETTLED;
            case 3:
                return SETTLED;
        }
        return null;
    }
}
