package com.zbkj.admin.task.brokerage;


import cn.hutool.core.collection.CollectionUtil;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.OrderDetailService;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * description：生成业绩报表定时器（补偿）
 * author：linchunpeng
 * date：2023/9/6
 */
@Slf4j
@Component("GenerateReportTask")
public class GenerateReportTask {


    @Autowired
    private OrderDetailService orderDetailService;
    @Autowired
    private BcxPerformanceReportService bcxPerformanceReportService;

    public void generateReport() {
        log.info("---GenerateReportTask task------produce Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
//        bcxPerformanceReportService.generateReportWithCompensation();
        List<OrderDetail> notBrokerageList = orderDetailService.getNotBrokerageList();
        if (CollectionUtil.isNotEmpty(notBrokerageList)) {
            Set<String> orderNoList = notBrokerageList.stream().map(OrderDetail::getOrderNo).collect(Collectors.toSet());
            for (String orderNo : orderNoList) {
                try {
                    bcxPerformanceReportService.generateReport(orderNo);
                } catch (Exception e) {
                    e.printStackTrace();
                    log.info("订单：{}，生成业绩报表报错，{}", orderNo, e.getMessage(), e);
                }

            }
        }
    }
}
