/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.dto.HuifuWalletTransferDto;
import com.zbkj.common.enums.BcxBillSettleStatusEnum;
import com.zbkj.common.enums.BcxPerformanceReportBelongTypeEnum;
import com.zbkj.common.enums.BcxPerformanceReportPayWayEnum;
import com.zbkj.common.enums.BcxReportSettleStatusEnum;
import com.zbkj.common.enums.BcxSettleStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxDepartment;
import com.zbkj.common.model.bcx.BcxDepartmentMember;
import com.zbkj.common.model.bcx.BcxPerformanceReport;
import com.zbkj.common.model.bcx.BcxSettle;
import com.zbkj.common.model.bcx.BcxSettleBill;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxDoSettleRequest;
import com.zbkj.common.request.BcxSettleSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxSettleBillInfoResponse;
import com.zbkj.common.response.BcxSettleDetailResponse;
import com.zbkj.common.response.BcxSettleInfoResponse;
import com.zbkj.common.response.BcxSettleResponse;
import com.zbkj.common.response.BcxSettleStatisticsResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.BcxSettleDao;
import com.zbkj.service.service.BcxDepartmentMemberService;
import com.zbkj.service.service.BcxDepartmentService;
import com.zbkj.service.service.BcxPerformanceReportService;
import com.zbkj.service.service.BcxSettleBillService;
import com.zbkj.service.service.BcxSettleService;
import com.zbkj.service.service.HuifuWalletService;
import com.zbkj.service.service.UserService;
import com.zbkj.service.service.bcx.BcxFapiaoSourceService;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxSettleServiceImpl
extends ServiceImpl<BcxSettleDao, BcxSettle>
implements BcxSettleService {
    private static final Logger log = LoggerFactory.getLogger(BcxSettleServiceImpl.class);
    @Resource
    private BcxSettleDao dao;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    @Lazy
    private BcxSettleBillService bcxSettleBillService;
    @Autowired
    @Lazy
    private BcxPerformanceReportService bcxPerformanceReportService;
    @Autowired
    private BcxDepartmentService bcxDepartmentService;
    @Autowired
    private BcxDepartmentMemberService bcxDepartmentMemberService;
    @Autowired
    private UserService userService;
    @Autowired
    private HuifuWalletService huifuWalletService;
    @Autowired
    private BcxFapiaoSourceService bcxFapiaoSourceService;
    private static final String SETTLE_NO_PREFIX = "FXJS";

    @Override
    public BcxSettleDetailResponse findId(Long id) {
        BcxDepartmentMember departmentMember;
        BcxSettleDetailResponse result = new BcxSettleDetailResponse();
        BcxSettle bcxSettle = (BcxSettle)this.getById(id);
        BeanUtil.copyProperties((Object)bcxSettle, (Object)result);
        int belongType = bcxSettle.getBelongType();
        Long belongId = bcxSettle.getBelongId();
        if (belongType == BcxPerformanceReportBelongTypeEnum.CHANNEL.getValue() || belongType == BcxPerformanceReportBelongTypeEnum.USER_FXS.getValue() || belongType == BcxPerformanceReportBelongTypeEnum.USER_FXY.getValue()) {
            User user = (User)this.userService.getById(belongId);
            if (user != null) {
                result.setSettleName(user.getRealName());
            }
        } else if (belongType == BcxPerformanceReportBelongTypeEnum.DEPARTMENT.getValue()) {
            BcxDepartment department = (BcxDepartment)this.bcxDepartmentService.getById(belongId);
            if (department != null) {
                result.setSettleName(department.getName());
            }
        } else if (belongType == BcxPerformanceReportBelongTypeEnum.DEPARTMENT_MEMBER.getValue() && (departmentMember = (BcxDepartmentMember)this.bcxDepartmentMemberService.getById(belongId)) != null) {
            result.setSettleName(departmentMember.getName());
        }
        return result;
    }

    @Override
    public PageInfo<BcxSettleResponse> getPage(BcxSettleSearchRequest request, PageParamRequest pageParamRequest) throws ParseException {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<Object> list = new ArrayList();
        if (request.getSearchType() != null) {
            HashMap<String, Object> map = this.getSearchParamMap(request);
            if (request.getSearchType() == 1) {
                list = this.dao.selectChannelList(map);
            } else if (request.getSearchType() == 2) {
                list = this.dao.selectDepartmentList(map);
            } else if (request.getSearchType() == 3) {
                list = this.dao.selectDepartmentMemberList(map);
            } else if (request.getSearchType() == 4) {
                list = this.dao.selectFxsList(map);
            } else if (request.getSearchType() == 5) {
                list = this.dao.selectFxyList(map);
            }
        }
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public BcxSettleStatisticsResponse statistics(BcxSettleSearchRequest request) throws ParseException {
        BcxSettleStatisticsResponse response = new BcxSettleStatisticsResponse();
        if (request.getSearchType() != null) {
            HashMap<String, Object> map = this.getSearchParamMap(request);
            if (request.getSearchType() == 1) {
                response = this.dao.selectChannelCount(map);
            } else if (request.getSearchType() == 2) {
                response = this.dao.selectDepartmentCount(map);
            } else if (request.getSearchType() == 3) {
                response = this.dao.selectDepartmentMemberCount(map);
            } else if (request.getSearchType() == 4) {
                response = this.dao.selectFxsCount(map);
            } else if (request.getSearchType() == 5) {
                response = this.dao.selectFxyCount(map);
            }
        }
        return response;
    }

    private HashMap<String, Object> getSearchParamMap(BcxSettleSearchRequest request) throws ParseException {
        HashMap map = CollUtil.newHashMap();
        if (ObjectUtil.isNotNull((Object)request.getBillPeriodStart())) {
            map.put("billPeriodStart", DateUtils.parseDate((String)request.getBillPeriodStart().concat("-01 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
        }
        if (ObjectUtil.isNotNull((Object)request.getBillPeriodEnd())) {
            map.put("billPeriodEnd", DateUtils.parseDate((String)request.getBillPeriodEnd().concat("-01 00:00:00"), (String[])new String[]{"yyyy-MM-dd HH:mm:ss"}));
        }
        if (ObjectUtil.isNotNull((Object)request.getSettleStatus())) {
            map.put("settleStatus", request.getSettleStatus());
        }
        if (ObjectUtil.isNotNull((Object)request.getUploadAttachments())) {
            map.put("uploadAttachments", request.getUploadAttachments());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getName())) {
            map.put("name", request.getName());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimitUtilVo = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            map.put("settleTimeStart", dateLimitUtilVo.getStartTime());
            map.put("settleTimeEnd", dateLimitUtilVo.getEndTime());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getSettleNo())) {
            map.put("settleNo", request.getSettleNo());
        }
        return map;
    }

    @Override
    public void generateSettle(BcxSettleBill settleBill, Long settleId, String settleNo, BcxSettleBillInfoResponse bcxSettleBillInfoResponse, Date now) {
        BcxSettle bcxSettle = new BcxSettle();
        bcxSettle.setId(settleId);
        bcxSettle.setSettleBillId(settleBill.getId());
        bcxSettle.setBelongId(settleBill.getBelongId());
        bcxSettle.setBelongType(settleBill.getBelongType());
        bcxSettle.setBillPeriod(settleBill.getBillPeriod());
        bcxSettle.setSettleNo(settleNo);
        bcxSettle.setReportCount(bcxSettleBillInfoResponse.getSettleReportCount());
        bcxSettle.setTotalPrice(bcxSettleBillInfoResponse.getPayTotalPrice());
        bcxSettle.setBrokerageTotalPrice(bcxSettleBillInfoResponse.getSettleTotalPrice());
        bcxSettle.setBrokerageSettledPrice(bcxSettleBillInfoResponse.getSettledPrice());
        bcxSettle.setBrokerageNotSettledPrice(bcxSettleBillInfoResponse.getNotSettledPrice());
        bcxSettle.setSettleStatus(BcxSettleStatusEnum.WAIT_SETTLED.getValue());
        bcxSettle.setCreateTime(now);
        bcxSettle.setUpdateTime(now);
        this.save(bcxSettle);
        this.bcxFapiaoSourceService.saveSourceFromBrokerage(bcxSettle);
    }

    @Override
    public BcxSettle getLastNoSettle() {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.likeRight((Object)"settle_no", (Object)this.getSettleNoPrefix());
        queryWrapper.orderByDesc((Object)"create_time");
        return (BcxSettle)this.getOne((Wrapper)queryWrapper, false);
    }

    @Override
    public String getSettleNoPrefix() {
        return SETTLE_NO_PREFIX.concat(DateUtils.getDate((String)"yyyyMMdd"));
    }

    @Override
    public BcxSettleInfoResponse getSettleInfo(BcxDoSettleRequest request) {
        List<BcxSettle> settleList = this.getByBcxDoSettleRequest(request);
        BcxSettleInfoResponse response = this.getBcxSettleInfoResponse(settleList);
        return response;
    }

    private List<BcxSettle> getByBcxDoSettleRequest(BcxDoSettleRequest request) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.in((Object)"id", (Collection)request.getSettleIdList());
        return this.list((Wrapper)queryWrapper);
    }

    private BcxSettleInfoResponse getBcxSettleInfoResponse(List<BcxSettle> settleList) {
        BcxSettleInfoResponse response = new BcxSettleInfoResponse();
        if (CollectionUtil.isNotEmpty(settleList)) {
            int settleReportCount = 0;
            HashSet settleOrderIdSet = new HashSet();
            BigDecimal payTotalPrice = BigDecimal.ZERO;
            BigDecimal settleTotalPrice = BigDecimal.ZERO;
            for (BcxSettle bcxSettle : settleList) {
                ++settleReportCount;
                payTotalPrice = payTotalPrice.add(bcxSettle.getTotalPrice());
                settleTotalPrice = settleTotalPrice.add(bcxSettle.getBrokerageTotalPrice());
            }
            response.setSettleCount(Integer.valueOf(settleList.size()));
            response.setSettleReportCount(Integer.valueOf(settleReportCount));
            response.setPayTotalPrice(payTotalPrice);
            response.setSettleTotalPrice(settleTotalPrice);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public Boolean doSettle(BcxDoSettleRequest request) {
        log.info("==================\u7ed3\u7b97==================");
        log.info("\u7ed3\u7b97\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)request));
        if (request.getPayWay() == null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a"));
        }
        Date now = new Date();
        List<BcxSettle> settleList = this.getByBcxDoSettleRequest(request);
        if (CollectionUtil.isNotEmpty(settleList)) {
            log.info("\u8981\u7ed3\u7b97\u7684\u7ed3\u7b97\u5355\u6570\u91cf\uff1a{}", (Object)settleList.size());
            for (BcxSettle bcxSettle : settleList) {
                String lockKey = "BCX_SETTLE_SETTLE_" + bcxSettle.getId().toString();
                log.info("\u7ed3\u7b97\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
                RLock lock = this.redissonClient.getLock(lockKey);
                lock.lock(30L, TimeUnit.SECONDS);
                log.info("\u53d6\u5230\u9501");
                try {
                    log.info("========================");
                    List<BcxPerformanceReport> reportList = this.getSettleReportList(bcxSettle.getId());
                    log.info("\u7ed3\u7b97\u5355\u7684id\uff1a{}\uff0c\u4e1a\u7ee9\u62a5\u8868\u6570\u91cf\uff1a{}", (Object)bcxSettle.getId(), (Object)reportList.size());
                    log.info("\u7ed3\u7b97\u91d1\u989d\uff1a{}", (Object)bcxSettle.getBrokerageTotalPrice().toPlainString());
                    for (BcxPerformanceReport report2 : reportList) {
                        report2.setSettleTime(now);
                        report2.setSettleStatus(BcxReportSettleStatusEnum.SETTLED.getValue());
                        report2.setPayWay(request.getPayWay());
                        report2.setUpdateTime(now);
                        log.info("\u4fee\u6539\u4e1a\u7ee9\u62a5\u8868id\uff1a{}\uff0c\u7ed3\u7b97\u72b6\u6001\uff1a{}", (Object)report2.getId().toString(), (Object)BcxReportSettleStatusEnum.SETTLED.getName());
                    }
                    this.bcxPerformanceReportService.updateBatchById(reportList);
                    BcxSettleBill settleBill = (BcxSettleBill)this.bcxSettleBillService.getById(bcxSettle.getSettleBillId());
                    settleBill.setBrokerageSettleTotalPrice(settleBill.getBrokerageSettleTotalPrice().add(bcxSettle.getBrokerageTotalPrice()));
                    List<BcxPerformanceReport> billReportList = this.getSettleBillReportList(settleBill.getId());
                    if (billReportList.stream().allMatch(report -> report.getSettleStatus().intValue() == BcxReportSettleStatusEnum.SETTLED.getValue().intValue())) {
                        settleBill.setSettleStatus(BcxBillSettleStatusEnum.SETTLED.getValue());
                    } else {
                        settleBill.setSettleStatus(BcxBillSettleStatusEnum.PART_SETTLED.getValue());
                    }
                    settleBill.setUpdateTime(now);
                    this.bcxSettleBillService.updateById(settleBill);
                    bcxSettle.setSettleStatus(BcxSettleStatusEnum.SETTLED.getValue());
                    bcxSettle.setPayWay(request.getPayWay());
                    bcxSettle.setSettleTime(now);
                    bcxSettle.setUpdateTime(now);
                    this.updateById(bcxSettle);
                    if (request.getPayWay().intValue() == BcxPerformanceReportPayWayEnum.PURSE.getValue().intValue()) {
                        try {
                            log.info("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8");
                            this.settlePayWithPurse(bcxSettle);
                        }
                        catch (Exception e) {
                            log.error("\u4f01\u4e1a\u94b1\u5305\u652f\u4ed8\u5931\u8d25\uff1a{}", (Object)e.getMessage(), (Object)e);
                            throw e;
                        }
                    } else if (request.getPayWay().intValue() == BcxPerformanceReportPayWayEnum.THIRD_PARTY.getValue().intValue()) {
                        // empty if block
                    }
                    log.info("========================");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u7ed3\u7b97\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
                }
                finally {
                    if (lock.isLocked()) {
                        lock.unlock();
                    }
                    log.info("\u7ed3\u7b97\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
                }
            }
        } else {
            log.info("\u65e0\u7ed3\u7b97\u7684\u7ed3\u7b97\u5355");
        }
        log.info("==================\u7ed3\u7b97\u5b8c\u6210==================");
        return true;
    }

    private void settlePayWithPurse(BcxSettle bcxSettle) {
        User user = (User)this.userService.getById(bcxSettle.getBelongId());
        if (user != null && !user.getIsLogoff().booleanValue()) {
            String settleDetail = String.format("\u7ed3\u7b97\u5355\uff0cid\uff1a%s\uff0c\u7ed3\u7b97\u91d1\u989d\uff1a%s", bcxSettle.getId().toString(), bcxSettle.getBrokerageTotalPrice().toPlainString());
            HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
            transferDto.setAmount(bcxSettle.getBrokerageNotSettledPrice().toPlainString()).setBusinessCode("99").setBusinessPartnerSeq(bcxSettle.getSettleNo()).setComment(settleDetail).setGoodsName(settleDetail).setGoodsUnit("\u5143").setGoodsNumber("1").setInId(user.getIdentityNo()).setSellFeePriority(Integer.valueOf(1)).setNeedActiveCode("0").setPlatAmount("0").setTradeType("03");
            try {
                this.huifuWalletService.platAccountRetailTransfer(transferDto);
            }
            catch (Exception e) {
                log.error("\u7ed3\u7b97\u652f\u4ed8-\u4f01\u4e1a\u94b1\u5305-\u8c03\u7528\u94b1\u5305\u89e3\u51bb\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @Override
    public boolean settleReportWithPurse(BcxPerformanceReport report) {
        log.info("\u4e1a\u7ee9\u62a5\u8868\u76f4\u63a5\u8f6c\u8d26\uff0c\u4e1a\u7ee9\u62a5\u8868id\uff1a{}\uff0c\u8f6c\u8d26\u91d1\u989d\uff1a{}", (Object)report.getId().toString(), (Object)report.getBrokeragePrice().toPlainString());
        User user = (User)this.userService.getById(report.getBelongId());
        if (user != null && !user.getIsLogoff().booleanValue()) {
            String settleDetail = String.format("\u4e1a\u7ee9\u62a5\u8868\u76f4\u63a5\u8f6c\u8d26\uff0c\u4e1a\u7ee9\u62a5\u8868id\uff1a%s\uff0c\u8f6c\u8d26\u91d1\u989d\uff1a%s", report.getId().toString(), report.getBrokeragePrice().toPlainString());
            HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
            transferDto.setAmount(report.getBrokeragePrice().toPlainString()).setBusinessCode("99").setBusinessPartnerSeq(report.getId().toString()).setComment(settleDetail).setGoodsName(settleDetail).setGoodsUnit("\u5143").setGoodsNumber("1").setInId(user.getIdentityNo()).setSellFeePriority(Integer.valueOf(1)).setNeedActiveCode("0").setPlatAmount("0").setTradeType("04");
            try {
                this.huifuWalletService.platAccountRetailTransfer(transferDto);
                return true;
            }
            catch (Exception e) {
                log.error("\u4e1a\u7ee9\u62a5\u8868\u76f4\u63a5\u8f6c\u8d26-\u8c03\u7528\u94b1\u5305\u89e3\u51bb\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public void unFrozenReportWithPurse(BcxPerformanceReport report) {
        log.info("\u4e1a\u7ee9\u62a5\u8868\u89e3\u51bb\uff0c\u4e1a\u7ee9\u62a5\u8868id\uff1a{}\uff0c\u89e3\u51bb\u91d1\u989d\uff1a{}", (Object)report.getId().toString(), (Object)report.getBrokeragePrice().toPlainString());
        User user = (User)this.userService.getById(report.getBelongId());
        if (user != null && !user.getIsLogoff().booleanValue()) {
            String unFrozenDetail = String.format("\u4e1a\u7ee9\u62a5\u8868\u89e3\u51bb\uff0c\u4e1a\u7ee9\u62a5\u8868id\uff1a%s\uff0c\u89e3\u51bb\u91d1\u989d\uff1a%s", report.getId().toString(), report.getBrokeragePrice().toPlainString());
            HuifuWalletTransferDto transferDto = new HuifuWalletTransferDto();
            transferDto.setAmount(report.getBrokeragePrice().toPlainString()).setBusinessCode("99").setBusinessPartnerSeq(report.getId().toString()).setComment(unFrozenDetail).setGoodsName(unFrozenDetail).setGoodsUnit("\u5143").setGoodsNumber("1").setInId(user.getIdentityNo()).setSellFeePriority(Integer.valueOf(1)).setNeedActiveCode("0").setPlatAmount("0").setTradeType("05");
            try {
                this.huifuWalletService.huifuWalletAccountLock(transferDto);
            }
            catch (Exception e) {
                log.error("\u4e1a\u7ee9\u62a5\u8868\u4f63\u91d1\u89e3\u51bb-\u8c03\u7528\u94b1\u5305\u89e3\u51bb\u51fa\u9519\uff0c{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private List<BcxPerformanceReport> getSettleReportList(Long settleId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"settle_id", (Object)settleId);
        return this.bcxPerformanceReportService.list((Wrapper)queryWrapper);
    }

    private List<BcxPerformanceReport> getSettleBillReportList(Long settleBillId) {
        QueryWrapper queryWrapper = Wrappers.query();
        queryWrapper.eq((Object)"settle_bill_id", (Object)settleBillId);
        return this.bcxPerformanceReportService.list((Wrapper)queryWrapper);
    }

    @Override
    @Transactional
    public Boolean cancel(Long id) {
        log.info("==================\u64a4\u9500\u7ed3\u7b97\u5355==================");
        String lockKey = "BCX_SETTLE_SETTLE_" + id.toString();
        log.info("\u7ed3\u7b97\uff0c lockKey\uff1a{}\uff0c\u53d6\u9501\u4e2d.....", (Object)lockKey);
        RLock lock = this.redissonClient.getLock(lockKey);
        lock.lock(30L, TimeUnit.SECONDS);
        log.info("\u53d6\u5230\u9501");
        try {
            BcxSettle bcxSettle = (BcxSettle)this.getById(id);
            if (bcxSettle.getSettleStatus().intValue() == BcxSettleStatusEnum.SETTLED.getValue().intValue()) {
                throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5df2\u7ed3\u7b97\u7684\u7ed3\u7b97\u5355\u4e0d\u80fd\u64a4\u9500"));
            }
            this.bcxFapiaoSourceService.deleteSourceFromBrokerage(bcxSettle.getSettleNo());
            List<BcxPerformanceReport> reportList = this.getSettleReportList(bcxSettle.getId());
            if (CollectionUtil.isNotEmpty(reportList)) {
                Date now = new Date();
                for (BcxPerformanceReport report : reportList) {
                    report.setSettleStatus(BcxReportSettleStatusEnum.WAIT_SETTLED.getValue());
                    report.setSettleId(null);
                    report.setUpdateTime(now);
                    log.info("\u4fee\u6539\u4e1a\u7ee9\u62a5\u8868id\uff1a{}\uff0c\u7ed3\u7b97\u72b6\u6001\uff1a{}", (Object)report.getId().toString(), (Object)BcxReportSettleStatusEnum.WAIT_SETTLED.getName());
                }
                this.bcxPerformanceReportService.updateBatchById(reportList);
            }
            this.removeById(id);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u64a4\u9500\u7ed3\u7b97\u5355\u5f02\u5e38\uff0c{}", (Object)e.getMessage(), (Object)e);
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u64a4\u9500\u7ed3\u7b97\u5355\u5f02\u5e38:" + e.getMessage()));
        }
        finally {
            if (lock.isLocked()) {
                lock.unlock();
            }
            log.info("\u64a4\u9500\u7ed3\u7b97\u5355\uff0clockKey\uff1a{}\uff0c\u89e3\u9501", (Object)lockKey);
        }
        log.info("==================\u64a4\u9500\u7ed3\u7b97\u5355\u5b8c\u6210==================");
        return true;
    }
}

