/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zbkj.common.constants.ProductConstants;
import com.zbkj.common.enums.PayComponentEditStatusEnum;
import com.zbkj.common.enums.PayComponentPlatformEditStatusEnum;
import com.zbkj.common.enums.PayComponentPlatformStatusEnum;
import com.zbkj.common.enums.PayComponentStatusEnum;
import com.zbkj.common.enums.ShopPaymentEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.product.ProductAttr;
import com.zbkj.common.model.product.ProductAttrValue;
import com.zbkj.common.model.wechat.WechatCallback;
import com.zbkj.common.model.wechat.video.PayComponentCallBackPayResult;
import com.zbkj.common.model.wechat.video.PayComponentDraftProduct;
import com.zbkj.common.model.wechat.video.PayComponentOrder;
import com.zbkj.common.model.wechat.video.PayComponentProduct;
import com.zbkj.common.model.wechat.video.PayComponentProductAuditInfo;
import com.zbkj.common.model.wechat.video.PayComponentProductInfo;
import com.zbkj.common.model.wechat.video.PayComponentProductSku;
import com.zbkj.common.model.wechat.video.PayComponentProductSkuAttr;
import com.zbkj.common.model.wechat.video.PayComponentShopBrand;
import com.zbkj.common.request.ProductAttrValueRequest;
import com.zbkj.common.vo.MyRecord;
import com.zbkj.common.vo.wxvedioshop.ShopSpuAuditVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuCommonVo;
import com.zbkj.common.vo.wxvedioshop.ShopSpuVo;
import com.zbkj.service.dao.WechatCallbackDao;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.PayComponentCatService;
import com.zbkj.service.service.PayComponentDraftProductService;
import com.zbkj.service.service.PayComponentOrderService;
import com.zbkj.service.service.PayComponentProductAuditInfoService;
import com.zbkj.service.service.PayComponentProductInfoService;
import com.zbkj.service.service.PayComponentProductService;
import com.zbkj.service.service.PayComponentProductSkuAttrService;
import com.zbkj.service.service.PayComponentProductSkuService;
import com.zbkj.service.service.PayComponentShopBrandService;
import com.zbkj.service.service.ProductAttrService;
import com.zbkj.service.service.ProductAttrValueService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.WechatCallbackService;
import com.zbkj.service.service.WechatVideoSpuService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class WechatCallbackServiceImpl
extends ServiceImpl<WechatCallbackDao, WechatCallback>
implements WechatCallbackService {
    private static final Logger logger = LoggerFactory.getLogger(WechatCallbackServiceImpl.class);
    @Resource
    private WechatCallbackDao dao;
    @Autowired
    private PayComponentProductService componentProductService;
    @Autowired
    private PayComponentDraftProductService componentDraftProductService;
    @Autowired
    private WechatVideoSpuService wechatVideoSpuService;
    @Autowired
    private PayComponentProductAuditInfoService componentProductAuditInfoService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private PayComponentProductInfoService componentProductInfoService;
    @Autowired
    private PayComponentProductSkuService componentProductSkuService;
    @Autowired
    private PayComponentProductSkuAttrService componentProductSkuAttrService;
    @Autowired
    private ProductAttrService productAttrService;
    @Autowired
    private ProductAttrValueService productAttrValueService;
    @Autowired
    private PayComponentShopBrandService componentShopBrandService;
    @Autowired
    private PayComponentOrderService componentOrderService;
    @Autowired
    private PayComponentCatService payComponentCatService;
    @Autowired
    private OrderService orderService;

    @Override
    public String callback(String request) {
        logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u56de\u8c03\uff1a{}", (Object)request);
        JSONObject jsonObject = JSONObject.parseObject((String)request);
        logger.info("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u56de\u8c03jsonObject{}", (Object)jsonObject);
        WechatCallback wechatCallback = new WechatCallback();
        wechatCallback.setToUserName(jsonObject.getString("ToUserName"));
        wechatCallback.setFromUserName(jsonObject.getString("FromUserName"));
        wechatCallback.setCreateTime(jsonObject.getLong("CreateTime"));
        wechatCallback.setMsgType(jsonObject.getString("MsgType"));
        wechatCallback.setEvent(jsonObject.getString("Event"));
        wechatCallback.setAddTime((Date)DateUtil.date());
        wechatCallback.setContent(request);
        this.save(wechatCallback);
        switch (wechatCallback.getEvent()) {
            case "open_product_account_register": {
                break;
            }
            case "![CDATA[open_product_scene_group_audit]]": {
                break;
            }
            case "open_product_category_audit": {
                this.payComponentCatService.getAuditResultOrAuditCallBack(jsonObject.getJSONObject("QualificationAuditResult"), null);
                break;
            }
            case "open_product_spu_status_update": {
                this.payComponentsSyncRiskPutDownByWeiChat(jsonObject);
                break;
            }
            case "open_product_order_pay": {
                this.payComponentsSyncPaidStatus(jsonObject);
                break;
            }
            case "miniprogram_sharer_bind_status_change": {
                break;
            }
            case "open_product_receive_coupon": {
                break;
            }
            case "open_product_spu_audit": {
                this.spuAuditEvent(jsonObject);
                break;
            }
            case "open_product_brand_audit": {
                this.brandAuditEvent(jsonObject);
                break;
            }
            default: {
                logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u56de\u8c03\u65b9\u5f0f\u672a\u77e5 {}", (Object)JSONObject.parseObject((String)request));
            }
        }
        return "success";
    }

    @Override
    public void payComponentsSyncPaidStatus(JSONObject jsonObject) {
        logger.info("\u652f\u4ed8\u56de\u8c03\u4e2d\u66f4\u65b0\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u652f\u4ed8\u53c2\u6570:\u56de\u8c03\u5185\u5bb9:jsonObject{}:", (Object)JSON.toJSONString((Object)jsonObject));
        String justCallbackContent = jsonObject.getString("order_info");
        if (ObjectUtil.isNull((Object)jsonObject.getString("order_info"))) {
            throw new CrmebException("\u540c\u6b65\u652f\u4ed8\u56de\u8c03\u65f6 \u672a\u627e\u5230\u5bf9\u5e94\u8ba2\u5355 jsonObject:" + JSON.toJSONString((Object)jsonObject));
        }
        logger.info("\u652f\u4ed8\u5b9e\u9645\u8981\u5904\u7406\u7684\u56de\u8c03\u5185\u5bb9:{}", (Object)justCallbackContent);
        PayComponentCallBackPayResult payResult = (PayComponentCallBackPayResult)JSONObject.parseObject((String)justCallbackContent, PayComponentCallBackPayResult.class);
        PayComponentOrder componentOrder = this.componentOrderService.getByOrderNo(payResult.getOut_order_id());
        componentOrder.setTimeEnd(payResult.getPay_time());
        componentOrder.setTransactionId(payResult.getTransaction_id());
        componentOrder.setStatus(ShopPaymentEnum.ORDER_DELIVERY.getCode());
        boolean comOrderUpdated = this.componentOrderService.updateById(componentOrder);
        if (!comOrderUpdated) {
            throw new CrmebException("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6 \u652f\u4ed8\u56de\u8c03 \u66f4\u65b0\u652f\u4ed8\u72b6\u6001\u5931\u8d25:" + JSON.toJSONString((Object)componentOrder));
        }
        this.orderService.updatePaid(componentOrder.getOrderNo());
        logger.info("\u652f\u4ed8\u56de\u8c03\u4e2d\u66f4\u65b0\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u652f\u4ed8\u7ed3\u679c:{}", (Object)comOrderUpdated);
    }

    @Override
    public void payComponentsSyncRiskPutDownByWeiChat(JSONObject jsonObject) {
        logger.info("\u5fae\u4fe1\u4fa7\u901a\u77e5 \u5f3a\u5236\u4e0b\u67b6\u5fae\u4fe1\u5f3a\u5236\u4e0b\u67b6:jsonObject{}:", (Object)JSON.toJSONString((Object)jsonObject));
        String product_id = jsonObject.getString("product_id");
        PayComponentProduct byComponentProductId = this.componentProductService.getByComponentProductId(Integer.valueOf(product_id));
        byComponentProductId.setStatus(PayComponentStatusEnum.STATUS_PUTDOWN_RISK.getCode());
        byComponentProductId.setPlatformEditStatus(PayComponentPlatformEditStatusEnum.INIT.getCode());
        this.componentProductService.updateById(byComponentProductId);
        PayComponentDraftProduct forUpdateDraftProduct = new PayComponentDraftProduct();
        forUpdateDraftProduct.setProductId(byComponentProductId.getId());
        forUpdateDraftProduct.setStatus(PayComponentStatusEnum.STATUS_PUTDOWN_RISK.getCode());
        forUpdateDraftProduct.setPlatformEditStatus(PayComponentPlatformEditStatusEnum.INIT.getCode());
        forUpdateDraftProduct.setReject_reason(jsonObject.getString("reason"));
        this.componentDraftProductService.updateById(forUpdateDraftProduct);
    }

    private void brandAuditEvent(JSONObject jsonObject) {
        String auditId = jsonObject.getString("audit_id");
        PayComponentShopBrand shopBrand = this.componentShopBrandService.getByAuditId(auditId);
        if (ObjectUtil.isNull((Object)shopBrand)) {
            logger.error(StrUtil.format((CharSequence)"\u54c1\u724c\u5ba1\u6838\u56de\u8c03\u672a\u627e\u5230\u54c1\u724cid\uff0c\u5ba1\u6838id:{}", (Object[])new Object[]{auditId}));
            return;
        }
        Integer status = jsonObject.getInteger("status");
        if (status.equals(1)) {
            shopBrand.setBrandId(jsonObject.getInteger("brand_id"));
        }
        if (status.equals(9)) {
            shopBrand.setRejectReason(jsonObject.getString("reject_reason"));
            if (ObjectUtil.isNotNull((Object)jsonObject.getInteger("brand_id"))) {
                shopBrand.setBrandId(jsonObject.getInteger("brand_id"));
            }
        }
        shopBrand.setStatus(status);
        boolean update = this.componentShopBrandService.updateById(shopBrand);
        if (!update) {
            logger.error(StrUtil.format((CharSequence)"\u54c1\u724c\u5ba1\u6838\u56de\u8c03\u4fdd\u5b58\u6570\u636e\u51fa\u9519\uff0c\u5ba1\u6838id:{}", (Object[])new Object[]{auditId}));
        }
    }

    private void spuAuditEvent(JSONObject jsonObject) {
        PayComponentProductAuditInfo finalAuditInfo;
        Boolean execute;
        String outProductId = jsonObject.getString("out_product_id");
        logger.info("\u81ea\u5b9a\u4e49\u4ea4\u6613\u7ec4\u4ef6\u56de\u8c03 --\u300b outProductId = " + outProductId);
        if (jsonObject.getInteger("status").equals(PayComponentEditStatusEnum.REVIEW_FAILED.getCode())) {
            logger.warn(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u5546\u54c1id:{}\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object[])new Object[]{outProductId, jsonObject.getString("reject_reason")}));
            PayComponentDraftProduct draftProduct = this.componentDraftProductService.getByProId(Integer.valueOf(outProductId));
            if (ObjectUtil.isNull((Object)draftProduct) || draftProduct.getIsDel().booleanValue()) {
                logger.error(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u672a\u627e\u5230\u8349\u7a3f\u5546\u54c1\uff0c\u5546\u54c1id:{}\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object[])new Object[]{outProductId, jsonObject.getString("reject_reason")}));
                return;
            }
            ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
            shopSpuCommonVo.setOutProductId(outProductId);
            shopSpuCommonVo.setNeedEditSpu(Integer.valueOf(1));
            ShopSpuVo shopSpuVo = this.wechatVideoSpuService.shopSpuGet(shopSpuCommonVo);
            draftProduct.setEditStatus(shopSpuVo.getEditStatus());
            draftProduct.setStatus(shopSpuVo.getStatus());
            draftProduct.setUpdateTime(shopSpuVo.getUpdateTime());
            if (shopSpuVo.getStatus().equals(PayComponentStatusEnum.STATUS_PUTDOWN_RISK.getCode())) {
                draftProduct.setPlatformStatus(PayComponentPlatformStatusEnum.PLATFORM_PUTDOWN.getCode());
            }
            draftProduct.setPlatformStatusReason(jsonObject.getString("reject_reason"));
            this.componentDraftProductService.updateById(draftProduct);
            ShopSpuAuditVo shopSpuAuditVo = shopSpuVo.getAuditInfo();
            PayComponentProductAuditInfo auditInfo = this.componentProductAuditInfoService.getByProductIdAndAuditId(Integer.valueOf(outProductId), shopSpuAuditVo.getAuditId());
            if (ObjectUtil.isNull((Object)auditInfo)) {
                auditInfo = new PayComponentProductAuditInfo();
                auditInfo.setProductId(Integer.valueOf(outProductId));
                auditInfo.setComponentProductId(draftProduct.getComponentProductId());
                auditInfo.setAuditId(shopSpuAuditVo.getAuditId());
                auditInfo.setRejectReason(Optional.ofNullable(shopSpuAuditVo.getRejectReason()).orElse(""));
                auditInfo.setAuditTime(shopSpuAuditVo.getAuditTime());
                auditInfo.setSubmitTime(shopSpuAuditVo.getSubmitTime());
                this.componentProductAuditInfoService.save(auditInfo);
            }
            logger.info(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u672a\u901a\u8fc7\uff0c\u8bb0\u5f55\u5df2\u4fdd\u5b58\uff0c\u5546\u54c1id:{}\uff0c\u5931\u8d25\u539f\u56e0:{}", (Object[])new Object[]{outProductId, jsonObject.getString("reject_reason")}));
            return;
        }
        PayComponentDraftProduct draftProduct = this.componentDraftProductService.getByProId(Integer.valueOf(outProductId));
        if (ObjectUtil.isNull((Object)draftProduct) || draftProduct.getIsDel().booleanValue()) {
            logger.error(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u56de\u8c03\u672a\u627e\u5230\u8349\u7a3f\u5546\u54c1\uff0c\u5546\u54c1id:{}", (Object[])new Object[]{outProductId}));
            return;
        }
        PayComponentProduct product = (PayComponentProduct)this.componentProductService.getById(Integer.valueOf(outProductId));
        if (ObjectUtil.isNull((Object)product)) {
            logger.error(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u56de\u8c03\u672a\u627e\u5230\u5546\u54c1\uff0c\u5546\u54c1id:{}", (Object[])new Object[]{outProductId}));
            return;
        }
        if (product.getIsDel().booleanValue() && ObjectUtil.isNull((Object)product.getComponentProductId())) {
            PayComponentProductAuditInfo finalAuditInfo2;
            Boolean execute2;
            ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
            shopSpuCommonVo.setOutProductId(outProductId);
            shopSpuCommonVo.setNeedEditSpu(Integer.valueOf(0));
            ShopSpuVo shopSpuVo = this.wechatVideoSpuService.shopSpuGet(shopSpuCommonVo);
            draftProduct.setStatus(shopSpuVo.getStatus());
            draftProduct.setEditStatus(shopSpuVo.getEditStatus());
            draftProduct.setUpdateTime(shopSpuVo.getUpdateTime());
            product.setComponentProductId(draftProduct.getComponentProductId());
            product.setStatus(shopSpuVo.getStatus());
            product.setEditStatus(shopSpuVo.getEditStatus());
            product.setCreateTime(draftProduct.getCreateTime());
            product.setUpdateTime(draftProduct.getUpdateTime());
            product.setStock(draftProduct.getStock());
            product.setIsDel(Boolean.valueOf(false));
            PayComponentProductInfo productInfo = new PayComponentProductInfo();
            if (StrUtil.isNotBlank((CharSequence)draftProduct.getDescInfo())) {
                productInfo.setProductId(product.getId());
                productInfo.setComponentProductId(product.getComponentProductId());
                productInfo.setDesc(draftProduct.getDescInfo());
                productInfo.setIsDel(Boolean.valueOf(false));
            }
            List skuList = JSONArray.parseArray((String)draftProduct.getSku(), PayComponentProductSku.class);
            ArrayList attrsList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
            skuList.forEach(e -> {
                List skuAttrs = e.getAttrList();
                skuAttrs.forEach(attr -> {
                    attr.setSkuId(e.getId());
                    attr.setComponentSkuId(e.getSkuId());
                    attr.setIsDel(Boolean.valueOf(false));
                });
                attrsList.addAll(skuAttrs);
            });
            List attrList = JSONArray.parseArray((String)draftProduct.getAttr(), ProductAttr.class);
            List attrValueList = JSONArray.parseArray((String)draftProduct.getAttrValue(), ProductAttrValueRequest.class);
            MyRecord tableData = this.assembleHistoryTableData(product, attrList, attrValueList);
            List productAttrList = (List)tableData.get("productAttrList");
            List productAttrValueList = (List)tableData.get("productAttrValueList");
            ShopSpuAuditVo shopSpuAuditVo = shopSpuVo.getAuditInfo();
            PayComponentProductAuditInfo auditInfo = this.componentProductAuditInfoService.getByProductIdAndAuditId(Integer.valueOf(outProductId), shopSpuAuditVo.getAuditId());
            if (ObjectUtil.isNull((Object)auditInfo)) {
                auditInfo = new PayComponentProductAuditInfo();
                auditInfo.setProductId(Integer.valueOf(outProductId));
                auditInfo.setComponentProductId(draftProduct.getComponentProductId());
                auditInfo.setAuditId(shopSpuAuditVo.getAuditId());
                auditInfo.setRejectReason(Optional.ofNullable(shopSpuAuditVo.getRejectReason()).orElse(""));
                auditInfo.setAuditTime(shopSpuAuditVo.getAuditTime());
                auditInfo.setSubmitTime(shopSpuAuditVo.getSubmitTime());
            }
            if (!(execute2 = (Boolean)this.transactionTemplate.execute(arg_0 -> this.lambda$spuAuditEvent$3(draftProduct, product, productInfo, productAttrList, productAttrValueList, skuList, attrsList, finalAuditInfo2 = auditInfo, arg_0))).booleanValue()) {
                logger.error(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u56de\u8c03\u65b0\u589e\u5546\u54c1\u4fdd\u5b58\u6570\u636e\u51fa\u9519\uff0c\u5546\u54c1id:{}", (Object[])new Object[]{outProductId}));
            }
            return;
        }
        if (product.getIsDel().booleanValue()) {
            logger.error(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u56de\u8c03\u6b63\u5f0f\u5546\u54c1\u4e0d\u5b58\u5728\uff0c\u5546\u54c1id:{}", (Object[])new Object[]{outProductId}));
            return;
        }
        ShopSpuCommonVo shopSpuCommonVo = new ShopSpuCommonVo();
        shopSpuCommonVo.setOutProductId(outProductId);
        shopSpuCommonVo.setNeedEditSpu(Integer.valueOf(0));
        ShopSpuVo shopSpuVo = this.wechatVideoSpuService.shopSpuGet(shopSpuCommonVo);
        draftProduct.setStatus(shopSpuVo.getStatus());
        draftProduct.setEditStatus(shopSpuVo.getEditStatus());
        draftProduct.setUpdateTime(shopSpuVo.getUpdateTime());
        BeanUtils.copyProperties((Object)draftProduct, (Object)product, (String[])new String[]{"id", "sales", "isDel"});
        product.setHeadImg(this.systemAttachmentService.prefixImage(product.getHeadImg()));
        if (StrUtil.isNotBlank((CharSequence)product.getQualificationPics())) {
            product.setQualificationPics(this.systemAttachmentService.prefixImage(product.getQualificationPics()));
        }
        PayComponentProductInfo productInfo = new PayComponentProductInfo();
        if (StrUtil.isNotBlank((CharSequence)draftProduct.getDescInfo())) {
            productInfo.setProductId(product.getId());
            productInfo.setComponentProductId(product.getComponentProductId());
            productInfo.setDesc(draftProduct.getDescInfo());
            productInfo.setIsDel(Boolean.valueOf(false));
        }
        List skuList = JSONArray.parseArray((String)draftProduct.getSku(), PayComponentProductSku.class);
        ArrayList attrsList = CollUtil.newArrayList((Object[])new PayComponentProductSkuAttr[0]);
        skuList.forEach(e -> {
            List skuAttrs = e.getAttrList();
            skuAttrs.forEach(attr -> {
                attr.setSkuId(e.getId());
                attr.setComponentSkuId(e.getSkuId());
                attr.setIsDel(Boolean.valueOf(false));
            });
            attrsList.addAll(skuAttrs);
        });
        List attrList = JSONArray.parseArray((String)draftProduct.getAttr(), ProductAttr.class);
        List attrValueList = JSONArray.parseArray((String)draftProduct.getAttrValue(), ProductAttrValueRequest.class);
        MyRecord tableData = this.assembleHistoryTableData(product, attrList, attrValueList);
        List productAttrList = (List)tableData.get("productAttrList");
        List productAttrValueList = (List)tableData.get("productAttrValueList");
        ShopSpuAuditVo shopSpuAuditVo = shopSpuVo.getAuditInfo();
        PayComponentProductAuditInfo auditInfo = this.componentProductAuditInfoService.getByProductIdAndAuditId(Integer.valueOf(outProductId), shopSpuAuditVo.getAuditId());
        if (ObjectUtil.isNull((Object)auditInfo)) {
            auditInfo = new PayComponentProductAuditInfo();
            auditInfo.setProductId(Integer.valueOf(outProductId));
            auditInfo.setComponentProductId(draftProduct.getComponentProductId());
            auditInfo.setAuditId(shopSpuAuditVo.getAuditId());
            auditInfo.setRejectReason(Optional.ofNullable(shopSpuAuditVo.getRejectReason()).orElse(""));
            auditInfo.setAuditTime(shopSpuAuditVo.getAuditTime());
            auditInfo.setSubmitTime(shopSpuAuditVo.getSubmitTime());
        }
        if (!(execute = (Boolean)this.transactionTemplate.execute(arg_0 -> this.lambda$spuAuditEvent$7(draftProduct, product, productInfo, productAttrList, productAttrValueList, skuList, attrsList, finalAuditInfo = auditInfo, arg_0))).booleanValue()) {
            logger.error(StrUtil.format((CharSequence)"\u5546\u54c1\u5ba1\u6838\u56de\u8c03\u65b0\u589e\u5546\u54c1\u4fdd\u5b58\u6570\u636e\u51fa\u9519\uff0c\u5546\u54c1id:{}", (Object[])new Object[]{outProductId}));
        }
    }

    private MyRecord assembleHistoryTableData(PayComponentProduct product, List<ProductAttr> attrList, List<ProductAttrValueRequest> attrValueList) {
        ArrayList productAttrList = CollUtil.newArrayList((Object[])new ProductAttr[0]);
        ArrayList productAttrValueList = CollUtil.newArrayList((Object[])new ProductAttrValue[0]);
        if (product.getSpecType().booleanValue()) {
            if (CollUtil.isNotEmpty(attrList)) {
                attrList.forEach(e -> {
                    e.setProductId(product.getId());
                    e.setAttrValues(StringUtils.strip((String)e.getAttrValues().replace("\"", ""), (String)"[]"));
                    e.setType(ProductConstants.PRODUCT_TYPE_COMPONENT);
                });
                productAttrList.addAll(attrList);
            }
            if (CollUtil.isNotEmpty(attrValueList)) {
                for (ProductAttrValueRequest attrValuesRequest : attrValueList) {
                    attrValuesRequest.setProductId(product.getId());
                    ProductAttrValue productAttrValue = new ProductAttrValue();
                    BeanUtils.copyProperties((Object)attrValuesRequest, (Object)productAttrValue);
                    if (!StrUtil.isBlank((CharSequence)attrValuesRequest.getAttrValue())) {
                        productAttrValue.setSku(this.getSku(attrValuesRequest.getAttrValue()));
                        productAttrValue.setImage(this.systemAttachmentService.clearPrefix(productAttrValue.getImage()));
                        productAttrValue.setAttrValue(JSON.toJSONString((Object)attrValuesRequest.getAttrValue()));
                        productAttrValue.setType(ProductConstants.PRODUCT_TYPE_COMPONENT);
                        productAttrValueList.add(productAttrValue);
                        continue;
                    }
                    break;
                }
            }
        } else {
            ProductAttr singleAttr = new ProductAttr();
            singleAttr.setProductId(product.getId()).setAttrName("\u89c4\u683c").setAttrValues("\u9ed8\u8ba4").setType(ProductConstants.PRODUCT_TYPE_COMPONENT);
            productAttrList.add(singleAttr);
            ProductAttrValue singleAttrValue = new ProductAttrValue();
            ProductAttrValueRequest attrValueRequest = attrValueList.get(0);
            BeanUtils.copyProperties((Object)attrValueRequest, (Object)singleAttrValue);
            if (ObjectUtil.isNull((Object)singleAttrValue.getBrokerage())) {
                singleAttrValue.setBrokerage(Integer.valueOf(0));
            }
            if (ObjectUtil.isNull((Object)singleAttrValue.getBrokerageTwo())) {
                singleAttrValue.setBrokerageTwo(Integer.valueOf(0));
            }
            singleAttrValue.setProductId(product.getId());
            singleAttrValue.setSku("\u9ed8\u8ba4");
            singleAttrValue.setType(ProductConstants.PRODUCT_TYPE_COMPONENT);
            singleAttrValue.setImage(this.systemAttachmentService.clearPrefix(singleAttrValue.getImage()));
            productAttrValueList.add(singleAttrValue);
        }
        MyRecord record = new MyRecord();
        record.set("productAttrList", (Object)productAttrList);
        record.set("productAttrValueList", (Object)productAttrValueList);
        return record;
    }

    private String getSku(String attrValue) {
        LinkedHashMap linkedHashMap = (LinkedHashMap)JSONObject.parseObject((String)attrValue, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
        Iterator iterator = linkedHashMap.entrySet().iterator();
        ArrayList strings = CollUtil.newArrayList((Object[])new String[0]);
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            strings.add(next.getValue());
        }
        return String.join((CharSequence)",", strings);
    }

    private /* synthetic */ Boolean lambda$spuAuditEvent$7(PayComponentDraftProduct draftProduct, PayComponentProduct product, PayComponentProductInfo productInfo, List productAttrList, List productAttrValueList, List skuList, List attrsList, PayComponentProductAuditInfo finalAuditInfo, TransactionStatus e) {
        this.componentDraftProductService.updateById(draftProduct);
        this.componentProductService.updateById(product);
        this.componentProductInfoService.deleteByProId(product.getId());
        if (StrUtil.isNotBlank((CharSequence)draftProduct.getDescInfo())) {
            this.componentProductInfoService.save(productInfo);
        }
        this.productAttrService.removeByProductId(product.getId(), ProductConstants.PRODUCT_TYPE_COMPONENT);
        this.productAttrService.saveBatch(productAttrList);
        this.productAttrValueService.removeByProductId(product.getId(), ProductConstants.PRODUCT_TYPE_COMPONENT);
        this.productAttrValueService.saveBatch(productAttrValueList);
        this.componentProductSkuService.deleteByProId(product.getId());
        skuList.forEach(s -> {
            for (ProductAttrValue value : productAttrValueList) {
                if (!value.getSku().equals(s.getSku())) continue;
                s.setAttrValueId(value.getId());
                break;
            }
        });
        this.componentProductSkuService.updateBatchById(skuList);
        this.componentProductSkuAttrService.saveBatch(attrsList);
        if (ObjectUtil.isNull((Object)finalAuditInfo.getId())) {
            this.componentProductAuditInfoService.save(finalAuditInfo);
        }
        return Boolean.TRUE;
    }

    private /* synthetic */ Boolean lambda$spuAuditEvent$3(PayComponentDraftProduct draftProduct, PayComponentProduct product, PayComponentProductInfo productInfo, List productAttrList, List productAttrValueList, List skuList, List attrsList, PayComponentProductAuditInfo finalAuditInfo, TransactionStatus e) {
        this.componentDraftProductService.updateById(draftProduct);
        this.componentProductService.updateById(product);
        if (StrUtil.isNotBlank((CharSequence)draftProduct.getDescInfo())) {
            this.componentProductInfoService.save(productInfo);
        }
        this.productAttrService.saveBatch(productAttrList);
        this.productAttrValueService.saveBatch(productAttrValueList);
        skuList.forEach(s -> {
            for (ProductAttrValue value : productAttrValueList) {
                if (!value.getSku().equals(s.getSku())) continue;
                s.setAttrValueId(value.getId());
                break;
            }
            s.setIsDel(Boolean.valueOf(false));
        });
        this.componentProductSkuService.updateBatchById(skuList);
        this.componentProductSkuAttrService.saveBatch(attrsList);
        if (ObjectUtil.isNull((Object)finalAuditInfo.getId())) {
            this.componentProductAuditInfoService.save(finalAuditInfo);
        }
        return Boolean.TRUE;
    }
}

