/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.enums.RoleEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.admin.SystemMenu;
import com.zbkj.common.model.admin.SystemRole;
import com.zbkj.common.model.admin.SystemRoleMenu;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemRoleRequest;
import com.zbkj.common.request.SystemRoleSearchRequest;
import com.zbkj.common.request.SystemRoleStatusRequest;
import com.zbkj.common.response.RoleInfoResponse;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.MenuCheckTree;
import com.zbkj.common.vo.MenuCheckVo;
import com.zbkj.service.dao.SystemRoleDao;
import com.zbkj.service.service.SystemAdminService;
import com.zbkj.service.service.SystemMenuService;
import com.zbkj.service.service.SystemRoleMenuService;
import com.zbkj.service.service.SystemRoleService;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class SystemRoleServiceImpl
extends ServiceImpl<SystemRoleDao, SystemRole>
implements SystemRoleService {
    @Resource
    private SystemRoleDao dao;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemRoleMenuService systemRoleMenuService;
    @Autowired
    private SystemMenuService systemMenuService;
    @Autowired
    private SystemAdminService systemAdminService;

    @Override
    public List<SystemRole> getList(SystemRoleSearchRequest request, PageParamRequest pageParamRequest) {
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.select(new SFunction[]{SystemRole::getId, SystemRole::getRoleName, SystemRole::getStatus, SystemRole::getCreateTime, SystemRole::getUpdateTime});
        if (ObjectUtil.isNotNull((Object)request.getStatus())) {
            lqw.eq(SystemRole::getStatus, (Object)request.getStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getRoleName())) {
            String decode = URLUtil.decode((String)request.getRoleName());
            lqw.like(SystemRole::getRoleName, (Object)decode);
        }
        lqw.eq(SystemRole::getMerId, (Object)systemAdmin.getMerId());
        lqw.eq(SystemRole::getType, (Object)this.getRoleTypeByCurrentAdmin(systemAdmin.getType()));
        lqw.orderByAsc(SystemRole::getId);
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public Boolean updateStatus(SystemRoleStatusRequest request) {
        SystemRole role = (SystemRole)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)role)) {
            throw new CrmebException("\u8eab\u4efd\u4e0d\u5b58\u5728");
        }
        if (role.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || role.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            throw new CrmebException("\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (role.getStatus().equals(request.getStatus())) {
            return true;
        }
        role.setStatus(request.getStatus());
        return this.updateById(role);
    }

    @Override
    public Boolean add(SystemRoleRequest systemRoleRequest) {
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (this.existName(systemRoleRequest.getRoleName(), null).booleanValue()) {
            throw new CrmebException("\u89d2\u8272\u540d\u79f0\u91cd\u590d");
        }
        SystemRole systemRole = new SystemRole();
        BeanUtils.copyProperties((Object)systemRoleRequest, (Object)systemRole);
        List ruleList = Stream.of(systemRoleRequest.getRules().split(",")).map(Integer::valueOf).distinct().collect(Collectors.toList());
        systemRole.setId(null);
        systemRole.setRules("");
        systemRole.setMerId(currentAdmin.getMerId());
        systemRole.setType(this.getRoleTypeByCurrentAdmin(currentAdmin.getType()));
        return (Boolean)this.transactionTemplate.execute(e -> {
            boolean save = this.save(systemRole);
            if (!save) {
                return Boolean.FALSE;
            }
            List roleMenuList = ruleList.stream().map(rule -> {
                SystemRoleMenu roleMenu = new SystemRoleMenu();
                roleMenu.setRid(systemRole.getId());
                roleMenu.setMenuId(rule);
                return roleMenu;
            }).collect(Collectors.toList());
            this.systemRoleMenuService.saveBatch(roleMenuList, 100);
            return Boolean.TRUE;
        });
    }

    private Boolean existName(String roleName, Integer id) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(SystemRole::getRoleName, (Object)roleName);
        if (ObjectUtil.isNotNull((Object)id)) {
            lqw.ne(SystemRole::getId, (Object)id);
        }
        lqw.last(" limit 1");
        Integer count = this.dao.selectCount((Wrapper)lqw);
        return count > 0;
    }

    @Override
    public Boolean edit(SystemRoleRequest request) {
        if (ObjectUtil.isNull((Object)request.getId())) {
            throw new CrmebException("\u89d2\u8272ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SystemRole role = (SystemRole)this.getById(request.getId());
        if (ObjectUtil.isNull((Object)role)) {
            throw new CrmebException("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (!currentAdmin.getMerId().equals(role.getMerId())) {
            throw new CrmebException("\u975e\u81ea\u5df1\u7ba1\u7406\u7684\u89d2\u8272\u4e0d\u80fd\u4fee\u6539");
        }
        if (role.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || role.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            throw new CrmebException("\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91");
        }
        if (!role.getRoleName().equals(request.getRoleName()) && this.existName(request.getRoleName(), request.getId()).booleanValue()) {
            throw new CrmebException("\u89d2\u8272\u540d\u79f0\u91cd\u590d");
        }
        List ruleList = Stream.of(request.getRules().split(",")).map(Integer::valueOf).distinct().collect(Collectors.toList());
        List roleMenuList = ruleList.stream().map(rule -> {
            SystemRoleMenu roleMenu = new SystemRoleMenu();
            roleMenu.setRid(request.getId());
            roleMenu.setMenuId(rule);
            return roleMenu;
        }).collect(Collectors.toList());
        SystemRole systemRole = new SystemRole();
        BeanUtils.copyProperties((Object)request, (Object)systemRole);
        systemRole.setRules("");
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.updateById(systemRole);
            this.systemRoleMenuService.deleteByRid(systemRole.getId());
            this.systemRoleMenuService.saveBatch(roleMenuList, 100);
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean delete(Integer id) {
        SystemRole systemRole = (SystemRole)this.getById(id);
        if (ObjectUtil.isNull((Object)systemRole)) {
            throw new CrmebException("\u89d2\u8272\u5df2\u5220\u9664");
        }
        if (systemRole.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || systemRole.getType().equals(RoleEnum.SUPER_MERCHANT.getValue())) {
            throw new CrmebException("\u7cfb\u7edf\u5185\u7f6e\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        SystemAdmin systemAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (!systemAdmin.getMerId().equals(systemRole.getMerId())) {
            throw new CrmebException("\u975e\u81ea\u5df1\u5e73\u53f0\u7ba1\u7406\u7684\u89d2\u8272\u4e0d\u80fd\u5220\u9664");
        }
        if (this.systemAdminService.isExistRole(id).booleanValue()) {
            throw new CrmebException("\u6709\u7ba1\u7406\u5458\u4f7f\u7528\u89d2\u8272\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            this.dao.deleteById(id);
            this.systemRoleMenuService.deleteByRid(id);
            return Boolean.TRUE;
        });
    }

    @Override
    public RoleInfoResponse getInfo(Integer id) {
        SystemRole systemRole = (SystemRole)this.getById(id);
        if (ObjectUtil.isNull((Object)systemRole)) {
            throw new CrmebException("\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        List<Integer> menuIdList = this.systemRoleMenuService.getMenuListByRid(id);
        List<SystemMenu> menuList = systemRole.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || systemRole.getType().equals(RoleEnum.PLATFORM_ADMIN.getValue()) ? this.systemMenuService.getMenuCacheList(RoleEnum.PLATFORM_ADMIN.getValue()) : this.systemMenuService.getMenuCacheList(RoleEnum.MERCHANT_ADMIN.getValue());
        List menuCheckVoList = menuList.stream().map(menu -> {
            MenuCheckVo menuCheckVo = new MenuCheckVo();
            BeanUtils.copyProperties((Object)menu, (Object)menuCheckVo);
            menuCheckVo.setChecked(Boolean.valueOf(menuIdList.contains(menu.getId())));
            return menuCheckVo;
        }).collect(Collectors.toList());
        RoleInfoResponse response = new RoleInfoResponse();
        BeanUtils.copyProperties((Object)systemRole, (Object)response);
        response.setMenuList(new MenuCheckTree(menuCheckVoList).buildTree());
        return response;
    }

    @Override
    public Integer getRoleTypeByCurrentAdmin() {
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (currentAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || currentAdmin.getType().equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            return RoleEnum.MERCHANT_ADMIN.getValue();
        }
        if (currentAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || currentAdmin.getType().equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
            return RoleEnum.PLATFORM_ADMIN.getValue();
        }
        return null;
    }

    private Integer getRoleTypeByCurrentAdmin(Integer type) {
        if (type.equals(RoleEnum.SUPER_MERCHANT.getValue()) || type.equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            return RoleEnum.MERCHANT_ADMIN.getValue();
        }
        if (type.equals(RoleEnum.SUPER_ADMIN.getValue()) || type.equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
            return RoleEnum.PLATFORM_ADMIN.getValue();
        }
        return null;
    }

    @Override
    public Integer getOwnerByCurrentAdmin() {
        SystemAdmin currentAdmin = SecurityUtil.getLoginUserVo().getUser();
        if (currentAdmin.getType().equals(RoleEnum.SUPER_MERCHANT.getValue()) || currentAdmin.getType().equals(RoleEnum.MERCHANT_ADMIN.getValue())) {
            return currentAdmin.getMerId();
        }
        if (currentAdmin.getType().equals(RoleEnum.SUPER_ADMIN.getValue()) || currentAdmin.getType().equals(RoleEnum.PLATFORM_ADMIN.getValue())) {
            return -1;
        }
        return -1;
    }

    @Override
    public List<SystemRole> getListByMerId(Integer merId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId.equals(0)) {
            lqw.eq(SystemRole::getMerId, (Object)merId);
            lqw.ne(SystemRole::getType, (Object)RoleEnum.SUPER_ADMIN.getValue());
        } else {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lqw.eq(SystemRole::getMerId, (Object)merId)).or()).eq(SystemRole::getType, (Object)RoleEnum.SUPER_MERCHANT.getValue());
        }
        lqw.orderByAsc(SystemRole::getId);
        return this.dao.selectList((Wrapper)lqw);
    }
}

