package com.zbkj.admin.controller.platform.bcx;

import com.github.pagehelper.PageInfo;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.ProductSearchRequest;
import com.zbkj.common.request.bcx.BcxPlatformFeeConfigRequest;
import com.zbkj.common.response.PlatformProductListResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.bcx.BcxPlatformFeeConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 平台 服务费-分账设置 控制层
 */
@Slf4j
@Api(tags = "平台服务费-商品服务费-分账设置 控制器")
@RestController
@RequestMapping("/api/admin/platform/fee/config")
public class BcxPlatformFeeConfigController {

    @Resource
    private BcxPlatformFeeConfigService bcxPlatformFeeConfigService;
    @Resource
    private ProductService productService;

    @ApiOperation(value = "查询商品服务费分页列表")
    //@PreAuthorize("hasAuthority('platform:fee:config:delete')")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<PlatformProductListResponse>> queryPagedList(@Validated ProductSearchRequest request,
                                                                                @Validated PageParamRequest pageParamRequest) {
        PageInfo<PlatformProductListResponse> productList = productService.getPlatformPageList(request, pageParamRequest);
        if (productList.getList() != null && productList.getList().size() > 0) {
            productList.getList().forEach(p -> {
                p.setFeeConfig(bcxPlatformFeeConfigService.queryByAnyId(p.getMerId(), p.getId(), 0));
            });
        }
        return CommonResult.success(CommonPage.restPage(productList));
    }

    @ApiOperation("新增商品服务费-配置")
    //@PreAuthorize("hasAuthority('platform:fee:config:delete')")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public CommonResult<BcxPlatformFeeConfig> create(@RequestBody @Validated BcxPlatformFeeConfigRequest bcxPlatformFeeConfig) {
        if (bcxPlatformFeeConfigService.create(bcxPlatformFeeConfig)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("修改商品服务费-配置")
    //@PreAuthorize("hasAuthority('platform:fee:config:delete')")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public CommonResult<BcxPlatformFeeConfig> update(@RequestBody @Validated BcxPlatformFeeConfigRequest bcxPlatformFeeConfig) {
        if (bcxPlatformFeeConfigService.update(bcxPlatformFeeConfig)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("删除商品服务费-配置")
    //@PreAuthorize("hasAuthority('platform:fee:config:delete')")
    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST)
    public CommonResult<String> delete(@PathVariable Integer id) {
        if (bcxPlatformFeeConfigService.delete(id)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }
}
