package com.zbkj.admin.controller.merchant;

import com.zbkj.common.model.bcx.BcxProductQuota;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.BcxProductQuotaRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.BcxProductQuotaResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxProductQuotaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 商品限购表 控制层
 */
@Slf4j
@Api(tags = "商户端商品限购表控制层")
@RestController
@RequestMapping("/api/admin/merchant/quota")
public class BcxProductQuotaController {

    @Autowired
    private BcxProductQuotaService bcxProductQuotaService;

    @ApiOperation("查询单条限购")
    @RequestMapping(value = "/info/{id}", method = RequestMethod.GET)
    public CommonResult<BcxProductQuotaResponse> queryById(@PathVariable Integer id){
        return CommonResult.success(bcxProductQuotaService.queryById(id));
    }

    @ApiOperation("分页查询限购")
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    public CommonResult<CommonPage<BcxProductQuotaResponse>> getPagedList(@ModelAttribute BcxProductQuotaRequest request,
                                                                  @Validated PageParamRequest pageParamRequest){
        return CommonResult.success(CommonPage.restPage(bcxProductQuotaService.getPagedList(request, pageParamRequest)));
    }

    @ApiOperation("新增限购")
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public CommonResult<String> create(@RequestBody @Validated BcxProductQuotaRequest bcxProductQuota){
        if(bcxProductQuotaService.create(bcxProductQuota)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("修改限购")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public CommonResult<String> update(@RequestBody @Validated BcxProductQuotaRequest bcxProductQuota){
        if (bcxProductQuotaService.update(bcxProductQuota)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }

    @ApiOperation("删除限购")
    @RequestMapping(value = "/delete/{id}", method = RequestMethod.POST)
    public CommonResult<String> delete(@PathVariable Integer id) {
        if (bcxProductQuotaService.delete(id)) {
            return CommonResult.success();
        }
        return CommonResult.failed();
    }
}
