/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxProductBenefits;
import com.zbkj.common.model.user.User;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.UserProductBenefitsRequest;
import com.zbkj.common.request.UserProductBenefitsSaveRequest;
import com.zbkj.common.response.UserProductBenefitsResponse;
import com.zbkj.common.result.CommonResultCode;
import com.zbkj.common.result.IResultEnum;
import com.zbkj.service.dao.BcxProductBenefitsDao;
import com.zbkj.service.service.BcxProductBenefitsService;
import com.zbkj.service.service.ProductService;
import com.zbkj.service.service.UserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxProductBenefitsServiceImpl
extends ServiceImpl<BcxProductBenefitsDao, BcxProductBenefits>
implements BcxProductBenefitsService {
    @Resource
    private BcxProductBenefitsDao dao;
    @Resource
    private ProductService productService;
    @Autowired
    private UserService userService;

    @Override
    public List<BcxProductBenefits> findListByProductId(Integer productId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxProductBenefits::getProductId, (Object)productId);
        Date nowTime = new Date();
        lqw.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.le(BcxProductBenefits::getAuthStartTime, (Object)nowTime)).or()).isNull(BcxProductBenefits::getAuthStartTime);
        });
        lqw.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ge(BcxProductBenefits::getAuthEndTime, (Object)nowTime)).or()).isNull(BcxProductBenefits::getAuthEndTime);
        });
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public List<BcxProductBenefits> findListByCompanyId(String companyId) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(BcxProductBenefits::getCompanyId, (Object)companyId);
        Date nowTime = new Date();
        lqw.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.le(BcxProductBenefits::getAuthStartTime, (Object)nowTime)).or()).isNull(BcxProductBenefits::getAuthStartTime);
        });
        lqw.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.ge(BcxProductBenefits::getAuthEndTime, (Object)nowTime)).or()).isNull(BcxProductBenefits::getAuthEndTime);
        });
        return this.dao.selectList((Wrapper)lqw);
    }

    @Override
    public PageInfo<UserProductBenefitsResponse> getPage(UserProductBenefitsRequest request, PageParamRequest pageRequest) {
        User user = this.userService.getInfo();
        List<Object> result = new ArrayList();
        Page page = PageHelper.startPage((int)pageRequest.getPage(), (int)pageRequest.getLimit());
        if (user.getUserType() == 1 && user.getIsPromoter().booleanValue() && user.getSpreadUid() == 0) {
            HashMap map = CollUtil.newHashMap();
            if (StrUtil.isNotBlank((CharSequence)request.getProductName())) {
                map.put("productName", request.getProductName());
            }
            if (CollectionUtil.isNotEmpty(result = this.dao.selectByFxs(map))) {
                for (UserProductBenefitsResponse userProductBenefitsResponse : result) {
                    userProductBenefitsResponse.setBrokerageTotal(this.productService.getBrokerageTotal(userProductBenefitsResponse.getProductId()));
                }
            }
        }
        return CommonPage.copyPageInfo((Page)page, result);
    }

    @Override
    @Transactional
    public Boolean saveConfig(UserProductBenefitsSaveRequest request) {
        if (StringUtils.isBlank((CharSequence)request.getId())) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u914d\u7f6eid \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (request.getIsEnableConfig() == null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u662f\u5426\u542f\u7528\u5355\u72ec\u914d\u7f6e \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        if (request.getBrokerage() == null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5206\u9500\u5458\u6bd4\u4f8b \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        User user = this.userService.getInfo();
        BcxProductBenefits bcxProductBenefits = (BcxProductBenefits)this.getById((Serializable)((Object)request.getId()));
        if (bcxProductBenefits == null) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5206\u9500\u5546\u54c1 \u4e0d\u5b58\u5728"));
        }
        if (!bcxProductBenefits.getCompanyId().equals(user.getAccount())) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u65e0\u6743\u9650\u4fee\u6539\u6b64\u5206\u4eab\u5546\u54c1"));
        }
        Integer brokerageTotal = this.productService.getBrokerageTotal(bcxProductBenefits.getProductId());
        if (request.getBrokerage() > brokerageTotal) {
            throw new CrmebException((IResultEnum)CommonResultCode.ERROR.setMessage("\u5206\u9500\u5458\u6bd4\u4f8b \u4e0d\u80fd\u5927\u4e8e\u603b\u6bd4\u4f8b"));
        }
        bcxProductBenefits.setIsEnableConfig(request.getIsEnableConfig());
        bcxProductBenefits.setBrokerage(request.getBrokerage());
        this.updateById(bcxProductBenefits);
        return true;
    }
}

