/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.model.system.SystemAttachment;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.SystemAttachmentMoveRequest;
import com.zbkj.common.utils.CrmebUtil;
import com.zbkj.service.dao.SystemAttachmentDao;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import com.zbkj.service.service.SystemRoleService;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemAttachmentServiceImpl
extends ServiceImpl<SystemAttachmentDao, SystemAttachment>
implements SystemAttachmentService {
    @Resource
    private SystemAttachmentDao dao;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private SystemRoleService systemRoleService;

    @Override
    public List<SystemAttachment> getList(Integer pid, String attType, PageParamRequest pageParamRequest) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(SystemAttachment::getOwner, (Object)this.systemRoleService.getOwnerByCurrentAdmin());
        if (StrUtil.isNotBlank((CharSequence)attType)) {
            lambdaQueryWrapper.in(SystemAttachment::getAttType, (Collection)StrUtil.split((CharSequence)attType, (char)','));
        }
        if (ObjectUtil.isNotNull((Object)pid) && pid > 0) {
            lambdaQueryWrapper.eq(SystemAttachment::getPid, (Object)pid);
        }
        lambdaQueryWrapper.orderByDesc(SystemAttachment::getAttId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public String prefixImage(String path) {
        return path.replace("crmebimage/", this.getCdnUrl() + "/" + "crmebimage" + "/");
    }

    @Override
    public String prefixUploadf(String path) {
        return path.replace("crmebimage/uploadf/", this.getCdnUrl() + "/crmebimage/" + "uploadf" + "/");
    }

    @Override
    public String prefixFile(String path) {
        if (path.contains("/mp-weixin-target.zip")) {
            String cdnUrl = this.systemConfigService.getValueByKey("localUploadUrl");
            return path.replace("crmebimage/", cdnUrl + "/crmebimage/");
        }
        if (path.contains("file/excel")) {
            String cdnUrl = this.systemConfigService.getValueByKey("localUploadUrl");
            return path.replace("crmebimage/file/", cdnUrl + "/crmebimage/file/");
        }
        if (path.contains("downloadf/excel")) {
            String cdnUrl = this.systemConfigService.getValueByKey("localUploadUrl");
            return path.replace("crmebimage/downloadf/", cdnUrl + "/crmebimage/downloadf/");
        }
        return path.replace("crmebimage/file/", this.getCdnUrl() + "/crmebimage/file/");
    }

    @Override
    public String clearPrefix(String path) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return path;
        }
        if (path.contains(this.getCdnUrl() + "/")) {
            if (path.contains("callback/alipay")) {
                return path;
            }
            return path.replace(this.getCdnUrl() + "/", "");
        }
        return path;
    }

    @Override
    public String clearPrefix(String path, String cdnUrl) {
        if (StrUtil.isBlank((CharSequence)path)) {
            return path;
        }
        if (path.contains(cdnUrl + "/")) {
            return path.replace(cdnUrl + "/", "");
        }
        return path;
    }

    @Override
    public Boolean updateAttrId(SystemAttachmentMoveRequest move) {
        LambdaUpdateWrapper lup = new LambdaUpdateWrapper();
        lup.in(SystemAttachment::getAttId, (Collection)CrmebUtil.stringToArray((String)move.getAttrId()));
        lup.set(SystemAttachment::getPid, (Object)move.getPid());
        lup.set(SystemAttachment::getOwner, (Object)this.systemRoleService.getOwnerByCurrentAdmin());
        return this.update((Wrapper)lup);
    }

    @Override
    public String getCdnUrl() {
        String uploadType = this.systemConfigService.getValueByKeyException("uploadType");
        int type = Integer.parseInt(uploadType);
        String uploadUrl = "localUploadUrl";
        switch (type) {
            case 2: {
                uploadUrl = "qnUploadUrl";
                break;
            }
            case 3: {
                uploadUrl = "alUploadUrl";
                break;
            }
            case 4: {
                uploadUrl = "txUploadUrl";
                break;
            }
            case 5: {
                uploadUrl = "jdUploadUrl";
                break;
            }
        }
        return this.systemConfigService.getValueByKey(uploadUrl);
    }
}

