<%@ page language="java" contentType="text/html; charset=utf-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <script src="/static/weChat/js/flexible.js"></script>
    <title>密码修改</title>
</head>
<body id="container">
<div class="ert-head">
    <div class="ert-left">
        <a href="/weixin/usercenter/index">
            <img src="/static/weChat/images/head-left.png" />
        </a>
    </div>
    <p>密码修改</p>
</div>
<div class="users-data">
    <form id="commonLoginForm" action="/weixin/usercenter/savePwd" method="post">
    <ul class="data">
        <li>
            <p>原密码</p>
            <div class="dfg">
                <input type="password" value="" name="old_password" placeholder="必填" minlength="6" maxlength="20" id="pwd_s1"/>
                <b></b>
            </div>
        </li>
    </ul>
    <ul class="data">
        <li>
            <p>新密码</p>
            <div class="dfg">
                <input type="password" value=""  name="new_password" placeholder="请输入6-20位密码" minlength="6" maxlength="20" id="pwd_s2"/>
                <b></b>
            </div>
        </li>
        <li>
            <p>确认新密码</p>
            <div class="dfg">
                <input type="password" value=""  name="again_password" placeholder="请再次输入新密码" minlength="6" maxlength="20" id="pwd_s3"/>
                <b></b>
            </div>
        </li>
    </ul>
    <div class="que-submit">
        <div class="submit">
            <a href="javascript:;" id="amend">确认修改</a>
        </div>
    </div>
    </form>
</div>

<!--修改成功弹窗-->
<div class="change-pwd">
    <div class="change-cont">
        <h2>恭喜您，密码修改成功!<br/>请重新登录!</h2>
        <a href="/weixin/login/init">立即前往</a>
        <div class="bi">
            <span>
                <img src="/static/weChat/images/bi-gray.png" />
            </span>
        </div>
        <div class="change-title">
            <img src="/static/weChat/images/update-pwd.png" />
        </div>
    </div>
</div>

<!--黑色蒙版-->
<div class="black-mask"></div>

</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>
<script src="/static/weChat/js/basic.js"></script>
<script src="/static/weChat/common/layer_mobile/layer.js"></script>
<link rel="stylesheet" href="/static/weChat/common/layer_mobile/need/right.css">
<script>
    $(function () {

        s_height = parseInt($('.change-pwd').height()/2);
        $('.change-pwd').css({"margin-top":-s_height+'px'});

        $('.change-pwd .bi').click(function () {
            $('.change-pwd').hide();
            $('.black-mask').hide();
        });

//        密码验证
        pwd_reg = /^(?![A-Z]+$)(?![a-z]+$)(?!\d+$)(?![\W_]+$)\S{6,20}$/;

        function checkPwdOne() {
            if ($('#pwd_s1').val() == "") {
                $('#pwd_s1').siblings('b').text('原密码不能为空').css({"display": "block"});
                return pwd_s1_ok = false;
            } else if(!$('#pwd_s1').val().match(pwd_reg)){
                $('#pwd_s1').siblings('b').text('原密码格式错误').css({"display": "block"});
                return pwd_s1_ok = false;
            }else{
                $('#pwd_s1').siblings('b').css({"display": "none"});
                return pwd_s1_ok = true;
            }
        }

        function checkPwdTwo() {
            if ($('#pwd_s2').val() == "") {
                $('#pwd_s2').siblings('b').text('新密码不能为空').css({"display": "block"});
                return pwd_s2_ok = false;
            } else if(!$('#pwd_s2').val().match(pwd_reg)){
                $('#pwd_s2').siblings('b').text('新密码格式错误').css({"display": "block"});
                return pwd_s2_ok = false;
            }else{
                $('#pwd_s2').siblings('b').css({"display": "none"});
                return pwd_s2_ok = true;
            }
        }

        function checkPwdThree() {
            if ($('#pwd_s3').val() == "") {
                $('#pwd_s3').siblings('b').text('确认新密码不能为空').css({"display": "block"});
                return pwd_s3_ok = false;
            } else if($('#pwd_s3').val() != $('#pwd_s2').val()){
                $('#pwd_s3').siblings('b').text('新密码与确认新密码不一样').css({"display": "block"});
                return pwd_s3_ok = false;
            }else{
                $('#pwd_s3').siblings('b').css({"display": "none"});
                return pwd_s3_ok = true;
            }
        }

        $('#amend').click(function () {
            pwd_s1_ok = checkPwdOne();
            pwd_s2_ok = checkPwdTwo();
            pwd_s3_ok = checkPwdThree();

            if(pwd_s1_ok && pwd_s2_ok && pwd_s3_ok){
                $.ajax({
                    type: 'POST',
                    url: "/weixin/usercenter/savePwd",
                    data: $("#commonLoginForm").serialize(),
                    dataType:"json",
                    async: false,
                    success: function(data){
                        if(data.status =="200"){
                            $('.change-pwd').show();
                            $('.black-mask').show();
                        }else{
                            layer.open({
                                content: data.msg
                                ,btn: '我知道了'
                            });
                        }
                    }
                });

            }
        });

    })
</script>
</html>