<%@ page language="java" contentType="text/html; charset=utf-8"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="renderer" content="webkit">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <link rel="stylesheet" href="/static/weChat/css/public.css">
    <link rel="stylesheet" href="/static/weChat/css/bai_basic.css">
    <link rel="stylesheet" href="/static/weChat/css/SG_area_select.css">
    <script src="/static/weChat/js/flexible.js"></script>
    <title>我的资料</title>
</head>
<body id="container">
<div class="ert-head">
    <div class="ert-left">
        <a href="/weixin/usercenter/index">
            <img src="/static/weChat/images/head-left.png" />
        </a>
    </div>
    <p>我的资料</p>
    <div class="ert-right">
<%--
        <a href="javascript:;" id="save">保存</a>
--%>
    </div>
</div>
<div class="users-data">
    <h2>联系人信息</h2>
    <ul class="data">
        <li>
            <p>姓名</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.real_name}" id="name" placeholder="请填写姓名"/>
                <b></b>
            </div>
        </li>
        <li>
            <p>手机号</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.telephone}" id="phone" placeholder="请填写手机号码"/>
                <b></b>
            </div>
        </li>
        <li>
            <p>邮箱</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.email}" class="gray" id="email" placeholder="请填写邮箱"/>
                <b></b>
            </div>
        </li>
    </ul>
    <h2>企业信息</h2>
    <ul class="data">
        <li>
            <p>企业名称</p>
            <div class="dfg">
                <input type="text" value="${weixinVo.company_name}" id="company_name" placeholder="请填写企业名称"/>
                <b></b>
            </div>
        </li>
        <li>
            <p>企业类型</p>
            <div class="dfg">
                <span id="business">国营</span>
                <input type="text" id="data_s1" style="display: none" value="国营">
                <b></b>
            </div>
        </li>
        <li>
            <p>证件类型</p>
            <div class="dfg">
                <span id="certificate">组织机构代码证</span>
                <input type="text" id="data_s2" style="display: none" value="组织机构代码证">
                <b></b>
            </div>
        </li>
        <li>
            <p>证件号码</p>
            <div class="dfg">
                <input type="text" value="123456987456321" id="card_number" placeholder="请填写证件号码"/>
                <b></b>
            </div>
        </li>
        <li>
            <p>所在城市</p>
            <div class="dfg">
                <span id="selectBtn">福建省-厦门市-集美区</span>
                <input type="text" id="data_s4" style="display: none" value="福建省-厦门市-集美区">
                <b></b>
            </div>
        </li>
        <li>
            <p>具体地址</p>
            <div class="dfg">
                <i id="ert"></i>
                <input type="text" id="data_s3" style="display: none" value="福建省厦门市集美区软件三期福建省厦门市集美区软件三期">
                <b></b>
            </div>
        </li>
    </ul>
</div>

<!--企业类型选择弹窗-->
<div class="business-select" id="busnes">
    <h2>请选择企业类型</h2>
    <ul>
        <li>
            <p class="on">国营</p>
        </li>
        <li>
            <p>私营</p>
        </li>
    </ul>
</div>

<!--证件类型选择弹窗-->
<div class="business-select" id="card">
    <h2>请选择证件类型</h2>
    <ul>
        <li>
            <p class="on">组织机构代码证</p>
        </li>
        <li>
            <p>营业执照</p>
        </li>
        <li>
            <p>税务登记证</p>
        </li>
    </ul>
</div>

<!--具体地址弹窗-->
<div class="business-select" id="address-cont">
    <h2>请填写具体地址</h2>
    <textarea></textarea>
    <div class="sure">
        <p class="ding">确定</p>
        <p class="xiao">取消</p>
    </div>
</div>

<!--黑色蒙版-->
<div class="black-mask"></div>

</body>
<script src="/static/weChat/js/jquery-1.8.3.min.js"></script>

<script src="/static/weChat/js/basic.js"></script>
<script src="/static/weChat/js/iscroll.js"></script>
<script src="/static/weChat/js/SG_area_select-two.js"></script>
<script>
    $(function () {
        var s_height = parseInt($('#busnes').height()/2);
        $('#busnes').css({"margin-top":-s_height+'px'});
        $('#business').click(function () {
            $('#busnes').show();
            $('.black-mask').show();
        });
        $('#busnes ul li p').click(function () {
            $('#busnes ul li p').removeClass('on');
            $(this).addClass('on');
            var sd = $(this).text();
            $('#business').text(sd);
            $('#busnes').hide();
            $('.black-mask').hide();
            $('#data_s1').val(sd);
        });


        var sr_height = parseInt($('#card').height()/2);
        $('#card').css({"margin-top":-sr_height+'px'});
        $('#certificate').click(function () {
            $('#card').show();
            $('.black-mask').show();
        });
        $('#card ul li p').click(function () {
            $('#card ul li p').removeClass('on');
            $(this).addClass('on');
            var sd = $(this).text();
            $('#certificate').text(sd);
            $('#card').hide();
            $('.black-mask').hide();
            $('#data_s2').val(sd);
        });

        var se_height = parseInt($('#address-cont').height()/2);
        $('#address-cont').css({"margin-top":-se_height+'px'});

        $('#ert').click(function () {
            var df = $('#ert').text();
            $('#address-cont').show();
            $('#address-cont textarea').val(df);
            $('.black-mask').show();
        });
        $('#address-cont .sure p.xiao').click(function () {
            $('#address-cont').hide();
            $('.black-mask').hide();

        });
        $('#address-cont .sure p.ding').click(function () {
            $('#address-cont').hide();
            var ert = $('#address-cont textarea').val();
            $('#ert').text(ert);
            $('.black-mask').hide();

        });

        //定位input、textarea
        function po_Last(obj) {
            obj.focus();//解决ff不获取焦点无法定位问题
            if (window.getSelection) {//ie11 10 9 ff safari
                var max_Len=obj.value.length;//text字符数
                obj.setSelectionRange(max_Len, max_Len);
            }
            else if (document.selection) {//ie10 9 8 7 6 5
                var range = obj.createTextRange();//创建range
                range.collapse(false);//光标移至最后
                range.select();//避免产生空格
            }
        }

        $('#selectBtn').on('click', function () {
            $.areaSelect();
            $('.title-min .query').on('click',function(){
                $('#selectBtn').text();
                $(".popups-box").show().animate({bottom:'-500px'},function(){
                    $('.sg-mask').css('display','none');
                    $('.sg-mask').remove();
                });
            })

            /*移动端确定操作响应*/
            $('.title-min .submit').on('click',function(){
                $('#selectBtn').text($('#hasCheck').val());
                $('#data_s4').val($('#hasCheck').val());
                $(".popups-box").show().animate({bottom:'-500px'},function(){
                    $('.sg-mask').css('display','none');
                    $('.sg-mask').remove();
                })
            })
        });

    })
</script>
<script>
    var phone_reg = /^1[2|3|4|5|6|7|8|9]\d{9}$/;
    var email_reg = /^[A-Za-z0-9\u4e00-\u9fa5]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$/;
    var identifica_reg = /(^\d{15}$)|(^\d{18}$)|(^\d{17}(\d|X|x)$)/;

    //    是否为空
    function checkEmpty(obj) {
        obj_ok = obj + '_ok';
        if ($('#'+obj).val() == "") {
            var sd = $('#'+obj).parents('.dfg').siblings('p').text();
            $('#'+obj).siblings('b').text(sd + '不能为空').css({"display": "block"});
            return obj_ok = false;
        }else{
            $('#'+obj).siblings('b').css({"display": "none"});
            return obj_ok = true;
        }
    }

    //   验证身份证号
    function checkIdentifica() {
        if ($('#identifica').val() == "") {
            $('#identifica').siblings('b').text('身份证号不能为空').css({"display": "block"});
            return identifica_ok = false;
        } else if(!$('#identifica').val().match(identifica_reg)){
            $('#identifica').siblings('b').text('身份证号格式错误').css({"display": "block"});
            return identifica_ok = false;
        }else{
            $('#identifica').siblings('b').css({"display": "none"});
            return identifica_ok = true;
        }
    }

    //    验证手机号码
    function checkPhone() {
        if ($('#phone').val() == "") {
            $('#phone').siblings('b').text('手机号码不能为空').css({"display": "block"});
            return phone_ok = false;
        } else if(!$('#phone').val().match(phone_reg)){
            $('#phone').siblings('b').text('手机号码格式错误').css({"display": "block"});
            return phone_ok = false;
        }else{
            $('#phone').siblings('b').css({"display": "none"});
            return phone_ok = true;
        }
    }
    //    验证邮箱
    function checkEmail() {
        if ($('#email').val() == "") {
            $('#email').siblings('b').text('邮箱不能为空').css({"display": "block"});
            return email_ok = false;
        }else if(!$('#email').val().match(email_reg)){
            $('#email').siblings('b').text('邮箱格式错误').css({"display": "block"});
            return email_ok = false;
        }else{
            $('#email').siblings('b').css({"display": "none"});
            return email_ok = true;
        }
    }

    //验证营业执照
    function checkBusLicen(id){
        var one_reg = /^\d{15}$/;
        if(!$("#"+id).val().match(one_reg)){
            $("#"+id).siblings('b').text('营业执照格式错误').css({"display": "block"});
            return card_number_ok = false;
        }else{
            $('#'+id).siblings('b').css({"display": "none"});
            return card_number_ok = true;
        }

    }
    //验证组织机构代码
    function checkFrameWork(id){
        var one_reg = /[A-Z0-9]{8}-[A-Z0-9]/;
        if(!$("#"+id).val().match(one_reg)){
            $("#"+id).siblings('b').text('组织机构代码格式错误').css({"display": "block"});
            return card_number_ok = false;
        }else{
            $('#'+id).siblings('b').css({"display": "none"});
            return card_number_ok = true;
        }
    }
    //验证税务登记证
    function checkRegistration(id){
        var one_reg = /^[0-9]{15}$/;
        var two_reg = /^[0-9]{20}$/;
        var three_reg = /^[0-9]{19}X$/;
        if(!$("#"+id).val().match(one_reg) && !$("#"+id).val().match(two_reg) && !$("#"+id).val().match(three_reg)){
            $("#"+id).siblings('b').text('税务登记证格式错误').css({"display": "block"});
            return card_number_ok = false;
        }else{
            $('#'+id).siblings('b').css({"display": "none"});
            return card_number_ok = true;
        }
    }
    //验证统一社会信用代码
    function checkCreditCode(id){
        var one_reg = /[A-Z0-9]{18}/g;
        if(!$("#"+id).val().match(one_reg)){
            $("#"+id).siblings('b').text('统一社会信用代码格式错误').css({"display": "block"});
            return card_number_ok = false;
        }else{
            $('#'+id).siblings('b').css({"display": "none"});
            return card_number_ok = true;
        }
    }

    function checkCode(obj) {
        s_name = $('#certificate').text();
        if ($('#'+obj).val() == "") {
            var sd = $('#'+obj).parents('.dfg').siblings('p').text();
            $('#'+obj).siblings('b').text(sd + '不能为空').css({"display": "block"});
            return obj_ok = false;
        }else if(s_name == "组织机构代码证"){
            return card_number_ok = checkFrameWork(obj);
        }else if(s_name == "营业执照"){
            return card_number_ok = checkBusLicen(obj);
        }else if(s_name == "税务登记证"){
            return card_number_ok = checkRegistration(obj);
        }
    }

    $('#save').click(function () {
        name_ok = checkEmpty('name');
        phone_ok = checkPhone();
        email_ok = checkEmail();
        company_name_ok = checkEmpty('company_name');
        data_s1_ok = checkEmpty('data_s1');
        data_s2_ok = checkEmpty('data_s2');
        card_number_ok = checkCode('card_number');
        city_ok = checkEmpty('data_s4');
        data_s3_ok = checkEmpty('data_s3');

        if (name_ok && phone_ok && email_ok && company_name_ok && data_s1_ok && data_s2_ok && card_number_ok && city_ok && data_s3_ok) {
            window.location = "http://www.baidu.com";
        }
    });

</script>
</html>