<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,initial-scale=1.0,user-scalable=0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Document</title>
    <style type="text/css">
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        html {
            margin: 0 auto;
            font-family: "Microsoft YaHei";
            font-weight: 400;
            font-style: normal;
            font-size: 28px;
            color: #666;
            background-color: #F4F5F6;
        }
        body {
            width: 550px;
        }

        p {
            line-height: 20px;
        }

        .header {
            padding: 30px 0;
            font-family: "Microsoft YaHei";
            font-size: 36px;
            line-height: 30px;
            color: #FFFFFF;
            letter-spacing: 0;
            text-align: center;
            background-color: #FF7F00;
            margin-bottom: 15px;
        }

        .active-info {
            background-color: #fff;
            margin-bottom: 15px;
            font-family: "Microsoft YaHei";
        }

        .active-info .active-header {
            height: 59px;
            text-align: center;
            font-size: 28px;
            letter-spacing: 0;
            text-align: center;
            padding-top: 12px;
            color: #333;
        }

        .active-info .active-header .bg {
            text-align: center;
            font-size: 0px;
            margin: 5px 0 10px 0
        }

        .active-info .active-header .bg img {
            width: 48px;
            height: 7px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        .active-content table td {
            padding: 14px;
            min-height: 50px;
            border-top: 1px solid #E7E7E7;
            font-family: "Microsoft YaHei";
        }

        .active-content table .key {
            min-width: 112px;
        }

        .product-solution {
            background-color: #fff;
            margin-bottom: 15px;
            font-family: "Microsoft YaHei";
        }

        .product-solution .product-header {
            height: 59px;
            text-align: center;
            font-size: 28px;
            letter-spacing: 0;
            text-align: center;
            padding-top: 12px;
            color: #333;
        }

        .product-solution .product-header .bg {
            text-align: center;
            font-size: 0px;
            margin: 5px 0 10px 0
        }

        .product-solution .product-header .bg img {
            width: 48px;
            height: 7px;
        }

        .product-solution .product-content {
            padding: 15px;
            border-top: 1px solid #E7E7E7;
        }

        .product-solution .product-content .title {
            font-size: 24px;
            letter-spacing: 0;
            line-height: 16px;
            margin-bottom: 8px;
            color: #333;
        }

        .product-solution .product-content .module-title {
            margin: 30px -15px 20px;
            text-align: center;
        }
        .product-solution .product-content .module-title img {
            width: 100%;
        }

        .product-solution .module table {
            text-align: center;
            margin-top: 15px;
            font-family: "Microsoft YaHei";
        }

        .product-solution .module table th {
            height: 40px;
            color: #ffffff;
            background-color: #FF7F00;
            min-width: 140px;
        }

        .product-solution .module table .key {
            width: 140px;
        }

        .product-solution .module table td {
            background-color: #F4F4F4;
            height: 60px;
            text-align: center;
            min-width: 140px;
            font-family: "Microsoft YaHei";
        }

        .product-solution .module table .light-yellow {
            background-color: #FFF2E5;
        }

        .product-solution .module .tip {
            margin: 10px auto 20px 5px;
        }

        .product-solution .module .extra {
            padding: 15px 20px;
            background-color: #FFF2E5;
            line-height: 24px;
        }

        .product-solution .module .extra .title {
            font-size: 20px;
            color: #333;
            letter-spacing: 0;
            line-height: 14px;
        }

        .makesure {
            background-color: #fff;
            font-family: "Microsoft YaHei";
        }

        .makesure .makesure-header {
            height: 59px;
            text-align: center;
            font-size: 28px;
            letter-spacing: 0;
            text-align: center;
            padding-top: 12px;
            color: #333;
        }

        .makesure .makesure-header .bg {
            text-align: center;
            font-size: 0px;
            margin: 5px 0 10px 0
        }

        .makesure .makesure-header .bg img {
            width: 48px;
            height: 7px;
        }

        .makesure .makesure-content {
            padding: 15px;
            border-top: 1px solid #E7E7E7;
        }

        .makesure .makesure-content .title {
            margin: 15px 0;
            font-size: 24px;
            letter-spacing: 0;
            line-height: 16px;
            color: #333;
        }

        .makesure .makesure-content table td {
            height: 40px;
            font-size: 24px;
            color: #333;
            letter-spacing: 0;
            text-align: center;
            background: url('${proPath}/resources/images/progress.png') no-repeat center;
            background-size: 100% 36px;
        }

        .makesure .makesure-content .progress {
            text-align: center;
        }

        .makesure .makesure-content .progress img {
            width: 100%;
        }

        .makesure .makesure-content .extra {
            margin-top: 28px;
            padding: 12px;
            background-color: #FFF2E5;
            color: #333;
        }
        .makesure .makesure-content .extra .descript {
            line-height: 24px;
        }
        .makesure .makesure-content .footer-img {
            text-align: center;
        }
        .makesure .makesure-content .footer-img img {
            width: 115px;
            height: 36px;
            margin: 27px 0 12px 0;
        }
    </style>
</head>

<body style="background-color: #F4F5F6; font-size: 22px">
<div class="header">
    <div class="title">大型活动公众责任险</div>
    <div class="title">报价方案书</div>
</div>
<div class="active-info" style="background-color: #ffffff">
    <div class="active-header">
        <div class="title">活动信息</div>
        <div class="bg">
            <img src="${proPath}/resources/images/title-border.png" alt="">
        </div>
    </div>
    <div class="active-content">
        <table>
            <tr>
                <td class="key">活动名称</td>
                <td class="value">${name}</td>
            </tr>
            <tr>
                <td class="key">活动时间</td>
                <td class="value">${hd_star}~${hd_end}</td>
            </tr>
            <tr>
                <td class="key">活动类型</td>
                <td class="value"><#if etype == '1'>展览展销
                <#elseif etype=="2">文艺演出
                <#elseif etype=="3">体育赛事
                <#else>其它</#if></td>
            </tr>
            <tr>
                <td class="key">活动场所</td>
                <td class="value"><#if eplace == '1'>室内场馆
                <#elseif eplace=="2">露天场馆
                <#else>户外地点</#if></td>
            </tr>
            <tr>
                <td class="key">消防验收</td>
                <td class="value"><#if ischeck == '1'>有消防验收
                <#else>无消防验收但配备灭火器</#if></td>
            </tr>
            <tr>
                <td class="key">有无危险环节</td>
                <td class="value"><#if isdanger == '1'>有
                <#else>无</#if></td>
            </tr>
            <tr>
                <td class="key">参与总人数</td>
                <td class="value"><#if pnum == '1'>0~5000
                <#elseif pnum=="2">5001~10000
                <#elseif pnum=="3">10001~50000
                <#else>50001及以上</#if></td>
            </tr>
            <tr>
                <td class="key">保障期间</td>
                <td class="value">${bz_star}~${bz_end}</td>
            </tr>
            <#if placearea??  && placearea != '' >
            <tr>
                <td class="key">展览场所面积</td>
                <td class="value"><#if placearea == '1'>小于10000平米
                <#elseif placearea=="2">10000~20000平米
                <#else>20000平米及以上</#if></td>
            </tr>
            </#if>
        </table>

        <p style="height: 58px; border-top: 1px solid #E7E7E7; line-height: 58px; color: #fe6b09; padding-left: 15px;padding-top: 10px;padding-bottom: 10px">温馨提示：为了您的利益保障，建议购买保险的总额${be_z}</p>
    </div>
</div>
<div class="product-solution" style="background-color: #ffffff">
    <div class="product-header">
        <div class="title">产品方案</div>
        <div class="bg">
            <img src="${proPath}/resources/images/title-border.png" alt="">
        </div>
    </div>
    <div class="product-content">
        <div class="intro">
            <div class="title">保障责任</div>
            <p class="descript">承保大型活动承办单位在举办活动过程中，因意外事故造成第三者（非承办单位直接或间接雇用单位或人员）财产损失或人身伤害时依法应承担的经济赔偿责任，由保险公司负责赔偿。</p>
        </div>
        <div class="module">
            <div class="module-title"><img src="${proPath}/resources/images/devide1.png" alt=""></div>
            <div class="title">产品优势</div>
            <p class="descript">专为<#if etype == '1'>展览展销
                <#elseif etype=="2">文艺演出
                <#elseif etype=="3">体育赛事
                <#else>其它</#if>类大型群众性活动保障量身定制500-3500万中高档，一站式线上投保、方案灵活选、保障全面、超高性价比，设施搭建、活动、设施拆除全覆盖，充分转移活动承办方赔偿责任风险。</p>
            <table>
            <#assign yarr = zhtype?string ? split(',')><#--z-3-1-2,z-5-1-2,h-7-1-2-->
            <#assign hCount = 1><#--当前第几行-->
            <#assign dohide = ''><#--要隐藏的位置-->
            <#list htfa as yao>
                <#if hCount == 1>
                    <thead>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list zhtype?string ? split(",") as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <th ${dosp} <#if lCount == 1> class="key" </#if>>${ya}</th>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </thead>
                <tbody>
                <#else>
                <tr>
                    <#assign lCount = 1><#--当前第几列-->
                    <#list yao?string ? split(",") as ya>
                        <#assign dosp = ''><#--合并列或行-->
                        <#list zhtype?string ? split(",") as yt>
                            <#assign ytarr = yt?string ? split("-")>
                            <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                <#list 1 .. ytarr[3]?number as i>
                                    <#if (ytarr[3] != i?string)>
                                        <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                    </#if>
                                </#list>
                            </#if>
                            <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                <#list 1 .. ytarr[3]?number as i>
                                    <#if (ytarr[3] != i?string)>
                                        <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                    </#if>
                                </#list>
                            </#if>
                        </#list>
                        <#assign ste = ''>
                        <#list dohide?string ? split(",") as dh>
                            <#if (dh != '')>
                                <#assign dharr = dh?string ? split("-")>
                                <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                    <#assign ste = 'display:none;'>
                                </#if>
                            </#if>
                        </#list>
                        <#if (ste == '')>
                            <td ${dosp} <#if lCount < 3> style="background-color: #FFF2E5;" </#if> class="key">${ya}</td>
                        </#if>
                        <#assign lCount = lCount + 1>
                    </#list>
                </tr>
                </#if>
                <#assign hCount = hCount + 1>
            </#list>
            </tbody>
            </table>
            <div class="tip">免赔额：财产损失500元，人身伤害无免赔额</div>
        </div>
        <div class="module">
            <div class="module-title"><img src="${proPath}/resources/images/devide2.png" alt=""></div>
            <div class="title">产品优势</div>
            <p class="descript">专为<#if etype == '1'>展览展销
            <#elseif etype=="2">文艺演出
            <#elseif etype=="3">体育赛事
            <#else>其它</#if>类大型群众性活动保障量身定制，在线投保、100万、200万、500万三大基础经济型方案可选，布展、活动、撤展期间风险全覆盖，科学转移展会承办方赔偿责任风险。</p>
            <table>
            <#assign yarr = zhtype?string ? split(',')><#--z-3-1-2,z-5-1-2,h-7-1-2-->
            <#assign hCount = 1><#--当前第几行-->
            <#assign dohide = ''><#--要隐藏的位置-->
            <#list pacfa as yao>
                <#if hCount == 1>
                    <thead>
                    <tr>
                        <#assign lCount = 1><#--当前第几列-->
                        <#list yao?string ? split(",") as ya>
                            <#assign dosp = ''><#--合并列或行-->
                            <#list zhtype?string ? split(",") as yt>
                                <#assign ytarr = yt?string ? split("-")>
                                <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                        </#if>
                                    </#list>
                                </#if>
                                <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                    <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                    <#list 1 .. ytarr[3]?number as i>
                                        <#if (ytarr[3] != i?string)>
                                            <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                        </#if>
                                    </#list>
                                </#if>
                            </#list>
                            <#assign ste = ''>
                            <#list dohide?string ? split(",") as dh>
                                <#if (dh != '')>
                                    <#assign dharr = dh?string ? split("-")>
                                    <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                        <#assign ste = 'display:none;'>
                                    </#if>
                                </#if>
                            </#list>
                            <#if (ste == '')>
                                <th ${dosp} <#if lCount == 1> class="key" </#if>>${ya}</th>
                            </#if>
                            <#assign lCount = lCount + 1>
                        </#list>
                    </tr>
                    </thead>
                <tbody>
                <#else>
                <tr>
                    <#assign lCount = 1><#--当前第几列-->
                    <#list yao?string ? split(",") as ya>
                        <#assign dosp = ''><#--合并列或行-->
                        <#list zhtype?string ? split(",") as yt>
                            <#assign ytarr = yt?string ? split("-")>
                            <#if (ytarr[0] == 'z' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                <#assign dosp = 'rowspan="'+ytarr[3]+'"'>
                                <#list 1 .. ytarr[3]?number as i>
                                    <#if (ytarr[3] != i?string)>
                                        <#assign dohide = dohide + (hCount + i) + '-' + ytarr[2] +','>
                                    </#if>
                                </#list>
                            </#if>
                            <#if (ytarr[0] == 'h' && ytarr[1] == hCount?string && ytarr[2] == lCount?string)>
                                <#assign dosp = 'colspan="'+ytarr[3]+'"'>
                                <#list 1 .. ytarr[3]?number as i>
                                    <#if (ytarr[3] != i?string)>
                                        <#assign dohide = dohide + hCount + '-' + (lCount + i) +','>
                                    </#if>
                                </#list>
                            </#if>
                        </#list>
                        <#assign ste = ''>
                        <#list dohide?string ? split(",") as dh>
                            <#if (dh != '')>
                                <#assign dharr = dh?string ? split("-")>
                                <#if (dharr[0] == hCount?string && dharr[1] == lCount?string)>
                                    <#assign ste = 'display:none;'>
                                </#if>
                            </#if>
                        </#list>
                        <#if (ste == '')>
                            <td ${dosp} <#if lCount < 3> style="background-color: #FFF2E5;" </#if> class="key">${ya}</td>
                        </#if>
                        <#assign lCount = lCount + 1>
                    </#list>
                </tr>
                </#if>
                <#assign hCount = hCount + 1>
            </#list>
            </tbody>
            </table>
            <div class="tip">免赔额：财产损失500元，人身伤害无免赔额</div>
            <div class="extra">
                <p class="title">以上产品均包含附加险：</p>
                <p class="descript">1.交叉责任条款</p>
                <p class="descript">2.罢工、暴乱、民众骚动及恶意破坏条款</p>
                <p class="descript">3.火灾和爆炸责任条款</p>
                <p class="descript">4.急救费用条款</p>
                <p class="descript">5.广告及装饰装置责任条款</p>
            </div>
        </div>
    </div>
</div>
<div class="makesure" style="background-color: #ffffff">
    <div class="makesure-header">
        <div class="title">投保说明</div>
        <div class="bg">
            <img src="${proPath}/resources/images/title-border.png" alt="">
        </div>
    </div>
    <div class="makesure-content">
        <p class="descript">一站式在线投保，方案全、价格优、一对一客服全流程协助理赔，全面保障参与活动公众的人身及财产安全，科学转移展会承办方赔偿责任风险！</p>
        <div class="title">投保流程</div>
        <div class="progress">
            <img src="${proPath}/resources/images/progress-text.png" alt="">
        </div>
        <div class="extra">
            <p class="descript">平台网址：www.bailianbao.cn</p>
            <p class="descript">客服邮箱：blbservice@baichuanxin.com</p>
            <p class="descript">客服热线：400-662-9696  周一至周五9:00-18:00</p>
        </div>
        <div class="footer-img" style="padding-top: 20px">
            <img src="${proPath}/resources/images/footer-logo.png" alt="">
        </div>
    </div>
</div>
</body>

</html>
