<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>用户注册</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
</head>
<body id="login-regis">
<div class="head-more">
    <div class="more-content clearfix">
        <div class="logo fl">
            <a href="<c:url value='/'/>">
                <img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="百联保logo">
                <span>用户注册</span>
            </a>
        </div>
    </div>
</div>
<div class="s-login">

    <div class="login-content" >
        <h2>用户注册</h2>
        <div class="login-select">
            <ul class="clearfix">
                <li class="active fl">
                    <span>个人用户</span>
                    <p class="li-bottom"></p>
                </li>
                <li class="fl">
                    <span>企业用户</span>
                    <p class="li-bottom"></p>
                </li>
            </ul>
        </div>
        <div class="select-content">
            <form id="phoneForm" method="post">
                <div class="content-describe">
                    <div class="dec-inp">
                        <input type="text" placeholder="请输入手机号码" name="email"   class="s5" id="phone">
                        <p class="error phone-error"></p>
                        <input type="password"  name="password" placeholder="请输入6-20位密码(含字母和数字)"  class="s2" id="password">
                        <p class="error password-error"></p>
                        <input type="password" placeholder="请再次输入密码" class="s6"  id="confirm_pwd">
                        <p class="error confirm_pwd-error"></p>
                    </div>
                    <div class="dec-pic clearfix">
                        <p class="fl"><input type="text" style="width: 200px" placeholder="请输入右侧验证码" value="" class="s3" id="right-code"></p>
                        <div class="fr" id="v_container" style="margin-top: 3px"><img style="width: 140px;height: 46px" id="imageF" src="" onclick="changeImg()"/></div>
                        <p class="error error-code"></p>
                    </div>
                    <div class="sdf clearfix">
                        <p class="fl">
                            <input type="hidden" id="check_code">
                            <input type="text" placeholder="请输入手机验证码" class="s7" id="code">
                        </p>
                        <a href="javascript:;" class="fr phone-code" style="background:rgba(236,236,236,1);color:rgb(153,153,153);cursor:default;pointer-events:none">获取短信验证码</a>
                        <p class="error code-error"></p>
                    </div>
                    <div class="login-foot">
                        <div class="login-rules">
                            <p>
                                <input type="checkbox" name="checkbox" id="agreen">
                                <label class="fl-l"></label>
                                <b class="fl-l">我已阅读并同意</b>
                                <a href="<c:url value='/resources/files/百联保会员协议（注册协议）.pdf' />" target="_blank">《百联保用户服务协议》</a>
                            </p>
                        </div>
                        <div class="login">
                            <a href="#" class="wer" id="register">立即注册</a>
                        </div>
                        <div class="sign-up">
                            <p>已经有账号？<a href="<c:url value='/user/login' />">立即登录>></a></p>
                        </div>
                    </div>
                </div>
            </form>
            <form  id="emailForm" method="post">
                <div class="content-describe s-none">
                    <div class="dec-inp">
                        <input type="email" placeholder="请输入邮箱地址"  name="email" class="s5" id="email">
                        <p class="error email-error"></p>
                        <input type="password" name="password"  placeholder="请输入6-20位密码(含字母和数字)" class="s2" id="password-s">
                        <p class="error password-s-error"></p>
                        <input type="password" placeholder="请再次输入密码"  class="s6" id="confirm-pwd-s">
                        <p class="error confirm-s-error"></p>
                    </div>
                    <div class="sdf clearfix">
                        <p class="fl">
                            <input type="text" placeholder="请输入邮箱验证码" class="s8" id="email-code">
                        </p>
                        <a href="javascript:;" class="fr email-code">获取邮箱验证码</a>
                        <p class="error email-code-error"></p>
                    </div>
                    <div class="login-foot">
                        <div class="login-rules">
                            <p>
                                <input type="checkbox" name="checkbox"  id="agreen-more" >
                                <label class="fl-l"></label>
                                <b class="fl-l">我已阅读并同意</b>
                                <a href="<c:url value='/resources/files/百联保会员协议（注册协议）.pdf' />" target="_blank">《百联保用户服务协议》</a>
                            </p>
                        </div>
                        <div class="login">
                            <a href="#" class="wer" id="register-more">立即注册</a>
                        </div>
                        <div class="sign-up">
                            <p>已经有账号？<a href="<c:url value='/user/login' />">立即登录>></a></p>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

</div>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script src="<c:url value='/resources/version_new/js/gVerify.js' />"></script>
<%--
<script src="<c:url value='/resources/version_new/js/login.js' />"></script>
--%>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script src="<c:url value='/resources/version_new/js/placeholder.js' />"></script>
<script type='text/javascript' src='https://webchat.7moor.com/javascripts/7moorInit.js?accessId=d7359b20-9dec-11ec-a564-cd73c4e7850a&autoShow=true&language=ZHCN' async='async'>
</script>
<script>
    $("input").placeholder();
    $('#agreen').click(function () {
        var sd = $(this).prop('checked');

        if(sd){
            $('#phoneForm .login a ').removeClass('wer').addClass('ert');
        }else{
            $('#phoneForm .login a ').addClass('wer').removeClass('ert');
        }
    });
    changeImg();
    function changeImg() {
        $('#imageF').hide().attr('src','/user/image.htm'+ '?'+ Math.floor(Math.random() * 100)).fadeIn();
    }
    function checkTelCodes() {
        var right_code = $('#right-code').val();
        if (right_code == "") {
            $('.error-code').html("验证码不能为空").addClass('wed');
            $('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
        } else {
            $('#check_code').val('');
            $.ajax({
                type: 'POST',
                url: baseUrl + "/synopsis/checkYzm.json",
                data:{'captcha': right_code},
                dataType:"json",
                success: function(json){
                    if(json.statusCode == "200") {
                        $("#right-code").attr("disabled","disabled").css("cursor", "not-allowed");
                        $("#imageF").attr("onclick", "");
                        $('#check_code').val(right_code);
                        $("#right-code").attr('TY-VAL','');
                        changeBtn(1);
                        $('.error-code').html("").removeClass('wed');
                        $('#right-code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
                    }else{
                        $('.error-code').html("验证码错误").addClass('wed');
                        $('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
                        changeImg();
                    }
                }
            });
        }
    }

    $('#right-code').blur(function () {
        checkTelCodes();
    })
    $('#agreen-more').click(function () {
        var sd = $(this).prop('checked');
        if(sd){
            $('#emailForm .login a ').removeClass('wer').addClass('ert');
        }else{
            $('#emailForm .login a ').addClass('wer').removeClass('ert');
        }
    })

    var baseUrl = '${pageContext.request.contextPath }';

    $('.email-code').click(function () {
        var reg = /^[A-Za-z0-9]+([-_.][A-Za-z0-9]+)*@([A-Za-z0-9]+[-.])+[A-Za-z0-9]{2,5}$/ ;
        var email  =$("#email").val();
        var pwd = $('#password-s').val();
        var pwdReg = /^(?![A-Z]+$)(?![a-z]+$)(?!\d+$)(?![\W_]+$)\S{6,20}$/;
        var conPwd = $('#confirm-pwd-s').val();
//        if(email&&reg.test(email)){
//            sendTrueEmail();
//            sendemail();
//        }else{
//            layer.msg("请输入正确的邮箱号码！");
//        }

        if(email != ""&&reg.test(email)){
            if(pwd != "" && pwdReg.test(pwd)){
                if(conPwd !="" && pwd == conPwd){
                    if(checkUserExist(email)){
                        layer.msg("该邮箱账号已经存在！！");
                        return ;
                    }else{
                        sendTrueEmail();
                        sendemail();
                    }

                }else{
                    layer.msg("再次输入的密码不正确或不能为空！");
                }
            }else{
                layer.msg("请输入正确的密码（密码为6-20位字母和数字的组合）");
            }
        }else{
            layer.msg("请输入正确的邮箱号码！");
        }
    });
    var countdown=60;
    function sendemail() {
        if (countdown == 0) {
            $('.email-code').text("获取邮箱验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
            countdown = 60;
            return;
        } else {
            $('.email-code').text("再次发送(" + countdown + ")").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
            countdown--;
        }
        setTimeout(function() {
                    sendemail()
                }
                ,1000)
    };

    $('.phone-code').click(function () {
        var  phone=$("#phone").val();
        var phoneReg = /^(13|14|15|16|17|18|19)[0-9]{8}[0-9]$/;
        var pwd = $('#password').val();
        var pwdReg = /^(?![A-Z]+$)(?![a-z]+$)(?!\d+$)(?![\W_]+$)\S{6,20}$/;
        var conPwd = $('#confirm_pwd').val();
        if(phone!=""&&phoneReg.test(phone)){
            if(pwd != "" && pwdReg.test(pwd)){
                if(conPwd !="" && pwd == conPwd){
                    if(checkUserExist(phone)){
                        layer.msg("该手机账号已经存在！！");
                        return ;
                    }else{
                        if($("#right-code").attr('TY-VAL') == '1'){
                            changeImg();
                            $("#right-code").removeAttr("disabled").css("cursor", "text");
                            $("#imageF").attr("onclick", "changeImg()");
                            layer.msg("图形验证码已刷新，请重新填写！");
                            changeBtn(2);
                            return;
                        }
                        sendTruePhone();
                    }
                }else{
                    layer.msg("再次输入的密码不正确或不能为空！");
                }
            }else{
                layer.msg("请输入正确的密码（密码为6-20位字母和数字的组合）");
            }
        }else{
            layer.msg("请输入11位正确的手机号码！");
        }
    });
    var count=60;
    function sendphone() {


        if (count == 0) {
            $('.phone-code').text("获取短信验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
            count = 60;
            return;
        } else {
            $('.phone-code').text("再次发送(" + count + ")").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
            count--;
        }
        setTimeout(function() {
                    sendphone()
                }
                ,1000)
    };
    function changeBtn(sign) {
        if(sign == 1){
            $('.phone-code').text("获取短信验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
        }else{
            $('.phone-code').text("获取短信验证码").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
        }
    };

    function   sendTrueEmail(){

        var index = layer.load(0, {shade: [0.3,'#808080']});
        var email =$("#email").val();
        $.ajax({
            type : 'POST',
            url : baseUrl + "/user/sendEmailCode",
            async: false,
            data : {
                'email' : email
            },
            dataType : "json",
            cache : false,
            success : function(json) {
                layer.close(index);
                if (json.statusCode == '200') {
                    layer.msg("验证码获取成功,请查收邮件并进行验证！！");
                    layer.close(index);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.msg("验证码获取失败！！");

            }
        });
    }
    function sendTruePhone(){
        var email =$("#phone").val();
        var check_code =$("#check_code").val();
        if(check_code == ''){
            layer.msg("请先输入正确的图形验证码！！");
            return;
        }
        sendphone();
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $("#right-code").attr('TY-VAL','1');
        $.ajax({
            type : 'POST',
            url : baseUrl + "/user/register/sendAuthCode",
            async: false,
            data : {
                'tel' : email,
                'check_code' : check_code
            },
            dataType : "json",
            cache : false,
            success : function(json) {
                layer.close(index);
                if (json.statusCode == '200') {
                    layer.msg("验证码获取成功,请查收手机并进行验证！！");
                }else{
                    layer.msg(json.message);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.msg("验证码获取失败！！");
            }
        });
    }



    $('.login-select ul li').click(function () {
        var s_index = $(this).index();
        $('.login-select ul li').removeClass('active');
        $(this).addClass('active');
        $('.select-content .content-describe').hide();
        $('.select-content .content-describe').eq(s_index).show();
    });
    $('.s-login .login-content input').focus(function(){
        $(this).css({"border-color":"#ff6600","box-shadow":" 0 0 5px #fdb381"});
    }).blur(function () {
        $(this).css({"border-color":"#e6e6e6","box-shadow":" none"});
    });
    $('.tooltip-more').mouseenter(function () {
        // $('.tooltip').show();\
        $(this).children('.tooltip').show();
    }).mouseleave(function () {
        $(this).children('.tooltip').hide();
    })

    // 表单验证
    var phone_reg = /^1[2|3|4|5|6|7|8|9]\d{9}$/;
    var email_reg = /^[A-Za-z0-9]+([-_.][A-Za-z0-9]+)*@([A-Za-z0-9]+[-.])+[A-Za-z0-9]{2,5}$/ ;
    var pwd_reg = /^(?![A-Z]+$)(?![a-z]+$)(?!\d+$)(?![\W_]+$)\S{6,20}$/;
    function checkPhone() {
        if ($('#phone').val() == "") {
            $('.phone-error').html("手机号不能为空").addClass('wed');
            $('#phone').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return phone_ok = false;
        } else if (!$('#phone').val().match(phone_reg)) {
            $('.phone-error').html("手机号码格式有错").addClass('wed');
            $('#phone').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return phone_ok = false;
        } else {
            $('.phone-error').html("").removeClass('wed');
            $('#phone').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return phone_ok = true;
        };
    }
    function checkPassword() {
        if ($('#password').val() == "") {
            $('.password-error').html("密码不能为空").addClass('wed');
            $('#password').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return pwd_ok = false;
        } else if (!$('#password').val().match(pwd_reg)) {
            $('.password-error').html("请输入正确的密码（密码为6-20位字母和数字的组合）").addClass('wed');
            $('#password').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return pwd_ok = false;
        } else {
            $('.password-error').html("").removeClass('wed');
            $('#password').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return pwd_ok = true;
        };
    }
    function checkConfrim() {
        if ($('#confirm_pwd').val() == "") {
            $('.confirm_pwd-error').html("再次输入密码不能为空").addClass('wed');
            $('#confirm_pwd').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return confirm_pwd_ok = false;
        } else if ($('#confirm_pwd').val() != $("#password").val()) {
            $('.confirm_pwd-error').html("两次输入的密码不一致").addClass('wed');
            $('#confirm_pwd').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return confirm_pwd_ok = false;
        } else {
            $('.confirm_pwd-error').html("").removeClass('wed');
            $('#confirm_pwd').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return confirm_pwd_ok = true;
        };
    }
    function checkCode() {
        if ($('#code').val() == "") {
            $('.code-error').html("验证码不能为空").addClass('wed');
            $('#code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return code_ok = false;
        } else {
            $('.code-error').html("").removeClass('wed');
            $('#code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return code_ok = true;
        };
    }
    function checkCodeTrue() {
        $.ajax({
            type: 'POST',
            url: baseUrl + "/user/register/checkCode",
            data:{'sign': $('#phone').val(),'captcha': $('#code').val()},
            dataType:"json",
            async: false,
            success: function(json){
                if(json.statusCode == "200") {
                    $('.code-error').html("").removeClass('wed');
                    $('#code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
                    return phone_code_ok = true;
                }else{
                    $('.code-error').html("验证码错误").addClass('wed');
                    $('#code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
                    return phone_code_ok = false;
                }
            }
        });
    }
    function checkCodeTrues() {


            $.ajax({
                type: 'POST',
                url: baseUrl + "/user/register/checkCode",
                data:{'sign': $('#email').val(),'captcha': $('#email-code').val()},
                dataType:"json",
                async: false,
                success: function(json){
                    if(json.statusCode == "200") {
                        $('.email-code-error').html("").removeClass('wed');
                        $('#email-code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
                        email_code_ok = true;
                    }else{
                        $('.email-code-error').html("邮箱验证码错误").addClass('wed');
                        $('#email-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
                        return email_code_ok = false;
                    }
                }
            });



    }
    function checkEmail() {
        if ($('#email').val() == "") {
            $('.email-error').html("邮箱不能为空").addClass('wed');
            $('#email').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return email_ok = false;
        } else if (!$('#email').val().match(email_reg)) {
            $('.email-error').html("邮箱格式有错").addClass('wed');
            $('#email').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return email_ok = false;
        } else {
            $('.email-error').html("").removeClass('wed');
            $('#email').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return email_ok = true;
        }
    }
    function checkPasswords() {
        if ($('#password-s').val() == "") {
            $('.password-s-error').html("密码不能为空").addClass('wed');
            $('#password-s').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return  pwd_com_ok = false;
        } else if (!$('#password-s').val().match(pwd_reg)) {
            $('.password-s-error').html("请输入正确的密码（密码为6-20位字母和数字的组合）").addClass('wed');
            $('#password-s').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return  pwd_com_ok = false;
        } else {
            $('.password-s-error').html("").removeClass('wed');
            $('#password-s').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return  pwd_com_ok = true;
        }
    }
    function checkConfrims() {
        if ($('#confirm-pwd-s').val() == "") {
            $('.confirm-s-error').html("再次输入密码不能为空").addClass('wed');
            $('#confirm-pwd-s').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return confirm_pwds_ok = false;
        } else if ($('#confirm-pwd-s').val() != $("#password-s").val()) {
            $('.confirm-s-error').html("两次输入的密码不一致").addClass('wed');
            $('#confirm-pwd-s').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return confirm_pwds_ok = false;
        } else {
            $('.confirm-s-error').html("").removeClass('wed');
            $('#confirm-pwd-s').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            return confirm_pwds_ok = true;
        }
    }
    function checkCodes() {
        if ( $('#email-code').val() == "") {
            $('.email-code-error').html("验证码不能为空").addClass('wed');
            $('#email-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
            return email_code_ok = false;
        } else {
            $('.email-code-error').html("").removeClass('wed');
            $('#email-code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
            email_code_ok = true;
        }
    }
    // 手机号码

    $('#phone').blur(function () {
        checkPhone();
    });
    //邮箱
    $('#email').blur(function () {
        checkEmail();
    });
    // 个人用户-密码
    $('#password').blur(function () {
        checkPassword();
    });
    // 企业用户-密码
    $('#password-s').blur(function () {
        checkPasswords();
    });
    // 再次密码-个人
    $('#confirm_pwd').blur(function () {
        checkConfrim();
    });
    // 再次密码-企业
    $('#confirm-pwd-s').blur(function () {
        checkConfrims()
    });

    // 短信验证码
    $('#code').blur(function () {
        checkCode();
    });
    // 邮箱验证码
    $('#email-code').blur(function () {
        checkCodes();
    });

    function  checkUserExist(email){
        var flag=false;
        if(email != "") {
            $.ajax({
                type: 'POST',
                url: baseUrl + "/user/register/checkUserExist",
                data:{'email': email},
                dataType:"json",
                async: false,
                success: function(json){
                    if(json.statusCode == '2') {
                       // layer.msg("该账号不存在！",{shift: 1});
                        flag = false;
                    }else{
                        flag=true;
                    }

                }
            });
        }else{
            flag = false;
        }
        return flag;
    }

    $("#register-more").click(function(event) {
        checkEmail();
        if(!email_ok){
             layer.msg("请输入正确的邮箱！");
            return ;
        }

        checkPasswords();
        if(!pwd_com_ok){
            layer.msg("请输入正确的密码（密码为6-20位字母和数字的组合）！");
            return ;
        }

        checkConfrims();
        if(!confirm_pwds_ok){
            layer.msg("请再次输入相同的密码！！");
            return ;
        }
        checkCodes();
        if(!email_code_ok){
            layer.msg("请验证码不能为空！！");
            return ;
        }
        checkCodeTrues();
        if(!email_code_ok){
            layer.msg("验证码有误，请重新输入！！");
            return ;
        }
        if(!$("#agreen-more").attr('checked')){
            layer.msg("请勾选百联保用户服务协议！！");
            return ;
        }

        if ($("#agreen-more").attr('checked') && email_ok && pwd_com_ok && confirm_pwds_ok && email_code_ok) {
//                window.location = "http://www.baidu.com";
            $.ajax({
                type: 'POST',
                url: baseUrl+"/user/registerSava/2",
                data:$("#emailForm").serialize(),
                dataType:"text",
                async: false,
                success: function(data){
                    var json = jQuery.parseJSON(data);
                    layer.msg("注册成功!!");
                    if(json.statusCode =="200"){
                        window.location.href=baseUrl+"/user/login";
                    }else{
                        layer.msg("注册失败，账号已存在！！");
                    }
                }
            });

        }
    })


    $("#register").click(function(event) {

        checkPhone();
        if(!phone_ok){
            layer.msg("请输入正确的手机号码！！");
            return ;
        }
        checkPassword();
        if(!pwd_ok){
            layer.msg("请输入正确的密码（密码为6-20位字母和数字的组合）！");
            return ;
        }
        checkConfrim();
        if(!confirm_pwd_ok){
            layer.msg("请输入再次输入相同的密码！");
            return ;
        }
        checkCode();
        if(!code_ok){
            layer.msg("请输入验证码！！");
            return ;
        }

        if(!$("#agreen").attr('checked')){
            layer.msg("请勾选百联保用户服务协议！！");
            return ;
        }
        checkCodeTrue();
        if(!phone_code_ok){
            layer.msg("验证码有误，请重新验证");
            return ;
        }
        if ($("#agreen").attr('checked')  && pwd_ok && confirm_pwd_ok && phone_ok && phone_code_ok) {
//                window.location = "http://www.baidu.com";
            $.ajax({
                type: 'POST',
                url: baseUrl+"/user/registerSava/1",
                data:$("#phoneForm").serialize(),
                dataType:"text",
                async: false,
                success: function(data){
                    var json = jQuery.parseJSON(data);
                        layer.msg("注册成功!!");
                    if(json.statusCode =="200"){
                        window.location.href=baseUrl+"/user/login";
                    }else{
                        layer.msg("注册失败，账号已存在！！");
                    }
                }
            });
        }
    });

</script>
</body>
</html>
