<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">

<title>百联保—投保人资料</title>
<link href="<c:url value='/resources/css/public.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/personal_center.css' />" rel="stylesheet" type="text/css" />

</head>
<body>
<jsp:include page="../../header.jsp"/>
<!-- 个人中心  企业资料 内容部分 开始 -->
<div class="per_centerwar"><!-- per_centerwar start -->
	<div class="per_centersub"><!-- per_centersub star -->
    	<div class="per_cenleftwar"><!-- per_cenleftwar star -->
        	<div class="my_acount">
            	<p><img src="<c:url value='/resources/images/my_acount.jpg' />" width="32" height="32" title="我的账户"></p>
            	<p><a href="<c:url value='/user/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的账户</a></p>
            </div>
            <div class="clear"></div>
            <div class="acount_list">
            	<ul>
                    <li>
                        <a href="<c:url value='/policy/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/my_order.png' />" width="17" height="19"></label>
                            <span>我的订单</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/report/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/refer.png' />" width="22" height="21"></label>
                            <span>理赔查询</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/user/personal/init?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/com_data.png' />" width="21" height="15"></label>
                            <span>企业资料</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li class="acount_active">
                        <a href="<c:url value='/appMsg/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/com_data.png' />" width="21" height="15"></label>
                            <span>投保人资料</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div><!-- per_cenleftwar end -->
        <div class="per_cenrightwar"><!-- per_cenrightwar start -->
          <div class="company_data"><!-- company_data start -->
          	<div class="company_title"><p>投保人信息</p></div>
            <%-- <div class="company_alter">
            	<p>登录邮箱<label>${userdetail.userName }</label><a href="<c:url value='/user/password/modify/init' />">修改登录密码</a></p>
            </div> --%>
            <form  id="appModify" method="post" action="<c:url value='/appMsg/saveorupdate?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" enctype="multipart/form-data"><!-- form start -->
            <!-- <div class="company_title"><p>联系人信息</p></div> -->
            <input type="hidden" name="oid" value="${appMsg.oid }"/>
            <%-- <div class="company_conbox"><!-- company_conbox start -->
            	<div class="text_box1">
                	<p>
                        <span>姓名</span>
                        <span><input type="text" name="name" id="name" value="${appMsg.name }" onblur="validateForms(this)"></span>
                        <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                    </p>
                </div>
                <div class="text_box2">
                	<p>
                        <span>身份证号码</span>
                        <span><input type="text" name="idcard" id="idcard" value="${appMsg.idcard }" onblur="validateForms(this)"></span>
                        <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                    </p>
                </div>
            </div><!-- company_conbox end -->
            <div class="clear"></div>
            <div class="company_conbox"><!-- company_conbox start -->
            	<div class="text_box1">
                	<p>
                        <span>手机号码</span>
                        <span><input type="text" name="tel" id="tel" value="${appMsg.tel }" onblur="validateForms(this)" ></span>
                        <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                    </p>
                </div>
                <div class="text_box2">
                	<p>
                        <span>电子邮箱</span>
                        <span><input type="text" name="email" id="email" value="${appMsg.email }" onblur="validateForms(this)" ></span>
                        <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                    </p>
                </div>
            </div><!-- company_conbox end --> --%>
            
            <div class="clear"></div>
            <!-- <div class="company_title"><p>企业信息</p></div> -->
             <div class="company_conbox"><!-- company_conbox start -->
            	<div class="text_box1">
                	<p>
                        <span>企业（全称）</span>
                        <span><input type="text" name="com_fullName" id="com_fullName" value="${appMsg.com_fullName }" onblur="validateForms(this)"></span>
                    </p>
                </div>
                <div class="text_box2">
                	<p>
                        <span>组织机构代码</span>
                        <span><input type="text" name="com_organizingCode" placeholder="代码格式如：00000000-0" id="com_organizingCode" value="${appMsg.com_organizingCode }" onblur="CheckOrgCode(this,'${pageContext.request.contextPath }')"></span>
                    </p>
                </div>
            </div><!-- company_conbox end -->
            <div class="clear"></div>
                 <div class="con_address"><!-- con_address start -->
                 	<p>
	                	<span>联系地址</span>
	                    <span><input type="text" name="com_address" id="com_address" value="${appMsg.com_address }" onblur="validateForms(this)"></span>
	                </p>
                 </div><!-- con_address end -->
            <div class="clear"></div>
            <div class="company_conbox"><!-- company_conbox start -->
            	<div class="text_box1">
                	<p>
	                	<span>联系电话</span>
	                    <span><input type="text" name="com_linkphone" id="com_linkphone" value="${appMsg.com_linkphone }" onblur="validateForms(this)"></span>
	                </p>
                </div>
                <div class="text_box2">
                	<p>
                	<span>邮编</span>
                    <span><input type="text" name="com_zipcode" id="com_zipcode" value="${appMsg.com_zipcode }" onblur="validateForms(this)"></span>
                </p>
                </div>
            </div><!-- company_conbox end -->
            <div class="clear"></div>
            <div class="company_conbox"><!-- company_conbox start -->
            	<div class="text_box1">
                	<p>
                        <span>联系人</span>
                        <span><input type="text" name="com_linkman" id="com_linkman" value="${appMsg.com_linkman }" onblur="validateForms(this)"></span>
                    </p>
                </div>
                <div class="text_box2">
                	<p>
	                	<span>手机</span>
	                    <span><input type="text" name="com_linkTel" id="com_linkTel" value="${appMsg.com_linkTel }" onblur="validateForms(this)"></span>
	                </p>
                </div>
            </div><!-- company_conbox end -->
            <div class="clear"></div>
            <div class="company_conbox"><!-- company_conbox start -->
            	<div class="text_box1">
                	<p>
                        <span>邮箱</span>
                        <span><input type="text" name="com_linkEmail" id="com_linkEmail" value="${appMsg.com_linkEmail }" onblur="validateForms(this)"></span>
                    </p>
                </div>
                <div class="text_box2">
                </div>
            </div><!-- company_conbox end -->
            <!-- 修改 开始 -->
            <div class="clear"></div>
            <div class="amend"><input type="button" value="修改" onclick="appFrom();"></div>
            <!-- 修改 结束 -->
            </form><!-- form end -->
          </div><!-- company_data end -->
        </div><!-- per_cenrightwar end -->
    </div><!-- per_centersub end -->
    <div class="clear"></div>
</div><!-- per_centerwar end -->
<!-- 个人中心  企业资料 内容部分 结束 -->
<!-- 内容部分  注册  结束 -->
<jsp:include page="../../index/multi_f.jsp" />
<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>
<script type="text/javascript" src="<c:url value='/resources/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';

function appFrom(){
	var mycars=new Array("com_fullName","com_address","com_organizingCode","com_zipcode","com_linkman","com_linkTel","com_linkphone","com_linkEmail");
	
	for(i=0;i<mycars.length;i++){
		if($("#"+mycars[i]).val() == ""){
			$("#"+mycars[i]).parent().next().attr("style","display:block;");
			return;
		}else{
			$("#"+mycars[i]).parent().next().attr("style","display:none;");
			/* if(mycars[i] =="idcard"){
				if(!validateIdent.IdentityCodeValid($("#"+mycars[i]).val())){
					$("#"+mycars[i]).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="身份证格式不正确">');
					$("#"+mycars[i]).parent().next().attr("style","display:block;");
					return;
				}else{
					$("#"+mycars[i]).parent().next().attr("style","display:none;");
				}
			} */
			if(mycars[i] =="com_linkEmail"){
				if(checkEmail($("#"+mycars[i]).val()) == false){
					$("#"+mycars[i]).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="邮箱地址格式不正确">');
					$("#"+mycars[i]).parent().next().attr("style","display:block;");
					return;
				}else{
					$("#"+mycars[i]).parent().next().attr("style","display:none;");
				}
			}
			if(mycars[i] =="com_linkphone"){
				var ph = $("#"+mycars[i]).val();
				var isPhone=/^((0\d{2,3})-)?(\d{7,8})(-(\d{3,}))?$/;
				if(!isPhone.test(ph)){
					$("#"+mycars[i]).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="电话格式不正确，例：区号-电话号码-转接号(如果有)">');
					$("#"+mycars[i]).parent().next().attr("style","display:block;");
					$("#"+mycars[i]).val('');
					return;
				}else{
					$("#"+mycars[i]).parent().next().attr("style","display:none;");
					if(ph.split("-").length == 1){
						$("#"+mycars[i]).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="电话格式不正确，例：区号-电话号码-转接号(如果有)">');
						$("#"+mycars[i]).parent().next().attr("style","display:block;");
						$("#"+mycars[i]).val('');
						return;
					}
				}
			}
			if(mycars[i] =="com_linkTel"){
				if(checkTel($("#"+mycars[i]).val()) == false){
					$("#"+mycars[i]).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="手机格式不正确">');
					$("#"+mycars[i]).parent().next().attr("style","display:block;");
					return;
				}else{
					$("#"+mycars[i]).parent().next().attr("style","display:none;");
				}
			}
			
		}
	}
	//$("#personalModify").submit();
	$.ajax({
		type: 'POST',
		url:baseUrl + '/appMsg/saveorupdate',
		data:$("#appModify").serialize(),
		dataType:"json",
		cache: false,
		success: function(json){
			if(json.statusCode == '200') {
				alert(json.resultDto.message);
				location.href=baseUrl + json.resultDto.forwardUrl;
			}
			if(json.statusCode == '300') {
				alert(json.resultDto.message);
			}
			if(json.statusCode == '301') {
				alert(json.resultDto.message);
				location.href=baseUrl + json.resultDto.forwardUrl;
			}
		}
	});
}

function checkEmail(value) {
	var re = /^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$/;
	return re.test(value);
}


function validateForms(o){
	if($("#"+o.id).val() == ""){
		$(o).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$(o).parent().next().attr("style","display:block;");
		return;
	}else{
		$(o).parent().next().attr("style","display:none;");
	}
	if(o.id == "idcard"){
		if(!validateIdent.IdentityCodeValid($("#"+o.id).val())){
			$(o).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="身份证格式不正确">');
			$(o).parent().next().attr("style","display:block;");
			return;
		}else{
			$(o).parent().next().attr("style","display:none;");
		}
	}
	
	if(o.id == "email"){
		if(!validateIdent.IdentityCodeValid($("#"+o.id).val())){
			$(o).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="邮箱地址格式不正确">');
			$(o).parent().next().attr("style","display:block;");
			return;
		}else{
			$(o).parent().next().attr("style","display:none;");
		}
	}
	if(o.id == "com_linkphone"){
		var isPhone=/^((0\d{2,3})-)?(\d{7,8})(-(\d{3,}))?$/;
		if(!isPhone.test($("#"+o.id).val())){
			$("#"+o.id).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="电话格式不正确，例：区号-电话号码-转接号(如果有)">');
			$("#"+o.id).parent().next().attr("style","display:block;");
			$("#"+o.id).val('');
			return;
		}else{
			$("#"+o.id).parent().next().attr("style","display:none;");
		}
	}
	if(o.id == "tel"){
		if(checkTel($("#"+o.id).val()) == false){
			$(o).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="手机格式不正确">');
			$(o).parent().next().attr("style","display:block;");
			return;
		}else{
			$(o).parent().next().attr("style","display:none;");
		}
	}
}
function checkTel(value) {
	var re = /^1[2|3|4|5|6|7|8|9]\d{9}$/;
	return re.test(value);
}
</script>
</html>