<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">

<title>百联保—投保人资料</title>
<link href="<c:url value='/resources/css/public.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/personal_center.css' />" rel="stylesheet" type="text/css" />

</head>
<body>
<jsp:include page="../../header.jsp"/>
<!-- 个人中心  理赔查询 内容部分 开始 -->
<div class="per_centerwar"><!-- per_centerwar start -->
	<div class="per_centersub"><!-- per_centersub star -->
    	<div class="per_cenleftwar"><!-- per_cenleftwar star -->
        	<div class="my_acount">
            	<p><img src="<c:url value='/resources/images/my_acount.jpg' />" width="32" height="32" title="我的账户"></p>
            	<p><a href="<c:url value='/user/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的账户</a></p>
            </div>
            <div class="clear"></div>
            <div class="acount_list">
            	<ul>
                    <li>
                        <a href="<c:url value='/policy/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/my_order.png' />" width="17" height="19"></label>
                            <span>我的订单</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/report/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/refer.png' />" width="22" height="21"></label>
                            <span>理赔查询</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/user/personal/init?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/com_data.png' />" width="21" height="15"></label>
                            <span>企业资料</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li class="acount_active">
                        <a href="<c:url value='/appMsg/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/insure_mes.png' />" width="19" height="20"></label>
                            <span>投保人资料</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div><!-- per_cenleftwar end -->
        <div class="per_cenrightwar"><!-- per_cenrightwar start -->
           <div class="settl_ement"><!-- settl_ement start -->
                <div class="settl_title ins_mes">
                   	<ul>
                       	<li>序号</li>
	                    <li>企业名称</li>
	                    <li>联系人</li>
	                    <li>联系电话</li>
	                    <li>操作</li>
	                </ul>
                </div>
                <c:if test="${content.size()>0 }">
                <div class="settl_list ins_mes">
                <c:forEach items="${content }" var="list" varStatus="index">
                	<ul>
                    	<li>${index.count }</li>
                        <li>&nbsp;${list.com_fullName }</li>
                        <li>&nbsp;${list.com_linkman }</li>
                        <li>&nbsp;${list.com_linkphone }</li>
                        <li><a href="<c:url value='/appMsg/saveorupdate/init/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />">修改</a>&nbsp;|&nbsp;<a href="javascript:void(0);" onclick="appDet('<c:url value="/appMsg/amDelete/${list.oid }" />');">废弃</a></li>
                    </ul>
                    <div class="clear"></div>
                </c:forEach>
                </div>
                </c:if>
           </div><!-- settl_ement end -->
            <!-- 无任何订单记录 开始 -->
            <c:if test="${content.size()==0 }">
            <div class="anony_mous"><p>无任何投保人资料记录</p></div>
            </c:if>
            <!-- 无任何订单记录 结束 -->
        </div><!-- per_cenrightwar end -->
    </div><!-- per_centersub end -->
    <div class="clear"></div>
</div><!-- per_centerwar end -->
<!-- 个人中心  理赔查询 内容部分 结束 -->
<!-- 内容部分  注册  结束 -->
<jsp:include page="../../index/multi_f.jsp" />
<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';

function appDet(path){
	var r=confirm("确认删除该记录？");
	if (r==true){
		$.ajax({
			type: 'POST',
			url:path,
			dataType:"json",
			cache: false,
			success: function(json){
				if(json.statusCode == '200') {
					location.href=baseUrl + json.resultDto.forwardUrl;
				}
				if(json.statusCode == '300') {
					alert(json.resultDto.message);
				}
			}
		});
	}

}
</script>
</html>