<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />  <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">

<title>百联保—申请理赔</title>
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/public.css' />" />
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/inquire.css' />" />
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/personal_center.css' />" />

</head>
<body>
	<jsp:include page="../../header.jsp"/>
	<!-- 输入保单查询信息 内容部分  开始 -->
		<div class="warr_antywar"><!-- warr_antywar start -->
        	<div class="warr_antysub"><!-- warr_antysub start -->
            	<div class="warr_content"><!-- warr_content start -->
                	<div class="warr_title"><!-- warr_title start -->
                    	<h4>申请理赔</h4>
                    </div><!-- warr_title end -->
                   
                   <form id="claimsForm" action="<c:url value='/synopsis/report/addClaims?ACCESS_TOKEN=${ACCESS_TOKEN}' />" method="post"><!-- form start -->
                   
                   <div class="company_conbox"><!-- company_conbox start -->
                    	<div class="text_box1">
                        	<p>
                                <span>保单号</span>
                                <span><input type="text" name="policySerialNumber" id="policySerialNumber" onblur="validateForms(this)"></span>
                                <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>
                        <div class="text_box2">
                        	<p><b>提醒：请输入平台购买保单的保单号</b></p>
                        </div>
                        <!--<div class="text_box2">
                        	<p>
                                <span>事故发生时间</span>
                                 <span  id="select_time">
                                	<input placeholder="" class="laydate-icon" onClick="laydate()">
                                </span>
                                <label class="hint_red"><img src="images/reg_error.png" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>-->
                    </div><!-- company_conbox end -->
                    
					<div class="clear"></div>
                    <div class="company_conbox"><!-- company_conbox start -->
                    	<div class="text_box1">
                        	<p>
                                <span>联系人</span>
                                <span><input type="text" name="contactName" id="contactName" onblur="validateForms(this)"></span>
                                <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>
                        <div class="text_box2">
                        	<p>
                                <span>联系人电话</span>
                                <span><input type="text" name="contactTel" id="contactTel" onblur="validateForms(this)"></span>
                                <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>
                    </div><!-- company_conbox end -->
                    
                    <div class="clear"></div>
                    <div class="company_conbox"><!-- company_conbox start -->
                        <div class="text_box1">
                            <p>
                                <span>事故发生时间</span>
                                <span  id="select_time">
                                <input placeholder="" name="caseTime" id="caseTime" class="laydate-icon" onClick="laydate()">
                                </span>
                                <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>
                    	<div class="text_box2">
                        	<p>
                                <span>事故发生地点</span>
                                <span><input type="text" name="caseScene" id="caseScene" onblur="validateForms(this)"></span>
                                <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>
                        
                        
                    </div><!-- company_conbox end -->
                   
                   
                   <div class="clear"></div>
                    <div class="company_conbox"><!-- company_conbox start -->
                    	<div class="text_box">
                        	<p>
                                <span>事故简单描述</span>
                                <span class="claims_describe"><textarea name="caseDescption" id="caseDescption" onblur="validateForms(this)"></textarea></span>
                                <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>
                    </div><!-- company_conbox end -->
                    
					<div class="clear"></div>
                    <div class="company_conbox"><!-- company_conbox start -->
                        <div class="text_box">
                        	<p>
                                <span>理赔资料上传</span>
                                
                                <div class="line">
                                <span>
                                <input type="text" id="claims_1" onmouseout="onout('upload')"/>
                                </span>
                                <label for="unload" onmouseover="onover('upload')"  class="claims_file2" >上传文件</label>
                                <input type="file" onchange="onge('claims_1','upload');imgBase64(this);" class="claims_file1" id="upload" style="width: 125px;"  />
                                <input type="hidden" name="downPath" id="downPath">
                                </div>
                                <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                            <p class="claims_hint">提醒：请上传保险条款中的理赔资料</p>
                        </div>
                    </div><!-- company_conbox end -->
                   
                    <div class="company_conbox"><!-- company_conbox start -->
                        <div class="text_box1">
                        	<p class="ver_ify">
                               <span>验证码</span>
		                       <span><input type="text" id="ryzm" name='j_captcha' onblur="checkYzm(this)" placeholder="输入验证码"></span>
		                       <span><label><img id="imageF" src="<c:url value='/user/image.htm'/>" onclick="changeImg()" width="100%" /></label></span>
                               <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
                            </p>
                        </div>
                    </div><!-- company_conbox end -->
                   
                   
                   <!-- 提交信息 开始 -->
                   <div class="clear"></div>
                   <div class="claims_submit">
					<a href="javascript:void(0);" onclick="report()">提交信息</a>
                   	<p>提交成功后，我们将在1个工作日内与您取得联系</p>
                   </div>
                   <!-- 提交信息 结束 -->
              
                   </form><!-- form end -->
                   
                </div><!-- warr_content end -->
            </div><!-- warr_antysub end -->
        </div><!-- warr_antywar end -->
		<!-- 输入保单查询信息 内容部分  结束 -->
	<jsp:include page="../../index/multi_f.jsp" />
</body>

<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/date/laydate.js' />" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
$(function(){
	$(".nav ul li").each(function(){
		$(this).attr("class","");
	});
	var co = 1;
	$(".nav ul li").each(function(){
		if(co == 3){
			$(this).attr("class","active");
		}
		co ++;
	});
});

/*** 修改验证码图*/
function changeImg() {  
    $('#imageF').hide().attr('src','<c:url value='/user/image.htm'/>'+ '?'+ Math.floor(Math.random() * 100)).fadeIn();  
}

/** 校验验证码 */
function checkYzm(obj) {
	
	if (obj.value == "" || $("#ryzm").val() == $("#ryzm").attr("defaultValue")) {
		$("#ryzm").parent().next().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="验证码不能为空">');
		$("#ryzm").parent().next().next().attr("style","display:block;");
		return false;
	}else{
    	$("#ryzm").parent().next().next().attr("style","display:none;");
    }
	
	if (obj.value != $("#ryzm").attr("defaultValue") && obj.value != "") {
		$.ajax({
			type : 'POST',
			url : baseUrl + "/user/register/checkYzm.json",
			data : {
				'captcha' : obj.value
			},
			dataType : "json",
			success : function(json) {
				if (json.statusCode == '300') {
					$("#ryzm").parent().next().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="验证码错误">');
		    		$("#ryzm").parent().next().next().attr("style","display:block;");
					changeImg();
					$("#ryzm").val($("#ryzm").attr("defaultValue"));
					$("#ryzm").focus();
				}else{
		        	$("#ryzm").parent().next().next().attr("style","display:none;");
		        }
			}
		});
	}
}

function imgBase64(file){
	var isnext = false;
	var fileSize = 0; 
	//var filetypes =[".jpg",".png",".gif",".jpeg",".bmp",".BMP",".JPG",".PNG",".GIF",".JPEG"]; 
	var filepath = document.getElementById(file.id).value;
	var fileend = filepath.substring(filepath.indexOf(".")); 
	/* if(filetypes && filetypes.length>0){ 
		for(var i =0; i<filetypes.length;i++){ 
			if(filetypes[i]==fileend){ 
				isnext = true; 
				break; 
			} 
		} 
	} 
	if(isnext){ */
		var fil = document.getElementById(file.id).files;
		fileSize = fil[0].size;
		var ImgFileSize = Math.round(fileSize/1024);
		if(ImgFileSize >20480){
			alert("请选择文件小于5M的文件上传");
		}else{
			
				if (file.files && file.files[0]){  
					 var reader = new FileReader();  
					 reader.onload = function(evt){ 
						 var strImg = evt.target.result;
						 $("#downPath").val(strImg);
					}    
				 	reader.readAsDataURL(file.files[0]);  
				} else {  
					//$("#"+p_domd).attr("src",file.value);
					alert("获取文件过程出错了");
				}  
			
		}
	/* }else{
		alert("请选择图片格式的文件上传");
	}
	 */
  }

//检查必选项
function checkRegisterRequiredField(){
	var policySerialNumber = $("#policySerialNumber").val();
	var caseTime = $("#caseTime").val();
	var contactName = $("#contactName").val();
	var contactTel = $("#contactTel").val();
	var caseScene = $("#caseScene").val();
	var caseDescption = $("#caseDescption").val();
	var downPath = $("#downPath").val();
	var ryzm = $("#ryzm").val();
	if ( policySerialNumber == "" || $("#policySerialNumber").val() == $("#policySerialNumber").attr("defaultValue")) {
		$("#policySerialNumber").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$("#policySerialNumber").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#policySerialNumber").parent().next().attr("style","display:none;");
    }
	
	if ( contactName == "" || contactName == $("#contactName").attr("defaultValue")) {
		$("#contactName").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$("#contactName").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#contactName").parent().next().attr("style","display:none;");
    }
	if ( contactTel == "" || contactTel == $("#contactTel").attr("defaultValue")) {
		$("#contactTel").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$("#contactTel").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#contactTel").parent().next().attr("style","display:none;");
    }
	if ( caseTime == "" || caseTime == $("#caseTime").attr("defaultValue")) {
		$("#caseTime").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$("#caseTime").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#caseTime").parent().next().attr("style","display:none;");
    }
	if ( caseScene == "" || contactTel == $("#caseScene").attr("defaultValue")) {
		$("#caseScene").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$("#caseScene").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#caseScene").parent().next().attr("style","display:none;");
    }
	if ( caseDescption == "" || caseDescption == $("#caseDescption").attr("defaultValue")) {
		$("#caseDescption").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$("#caseDescption").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#caseDescption").parent().next().attr("style","display:none;");
    }
	if ( downPath == "" || downPath == $("#downPath").attr("defaultValue")) {
		$("#downPath").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$("#downPath").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#caseDescption").parent().next().attr("style","display:none;");
    }
	if (ryzm == "" || $("#ryzm").val() == $("#ryzm").attr("defaultValue")) {
		$("#ryzm").parent().next().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="验证码不能为空">');
		$("#ryzm").parent().next().next().attr("style","display:block;");
		return false;
	}else{
    	$("#ryzm").parent().next().next().attr("style","display:none;");
    }
	return true;
}

//下一步
function report(){
	var flag = checkRegisterRequiredField();
	if (flag){
		$.ajax({
			type: 'POST',
			url: baseUrl + "/synopsis/report/addClaims.json",
			data:$("#claimsForm").serialize(),
			dataType:"json",
			async: false,
			success: function(json){
				if(json.statusCode == '301') {
					$("#policySerialNumber").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="'+json.resultDto.mesage+'">');
		    		$("#policySerialNumber").parent().next().attr("style","display:block;");
					$("#policySerialNumber").val('');
					$("#policySerialNumber").focus();
				}else if(json.statusCode == '300') {
					alert(json.resultDto.message);
				}else{
					alert(json.resultDto.message);
				}
			}
		}); 
	}
}
function validateForms(o){
	if($("#"+o.id).val() == ""){
		$(o).parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空">');
		$(o).parent().next().attr("style","display:block;");
		return;
	}else{
		$(o).parent().next().attr("style","display:none;");
	}
}
</script>
</html>
