<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />  <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">

<title>百联保—保险小常识</title>
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/public.css' />" />
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/inquire.css' />" />

</head>
<body>
	<jsp:include page="../index/multi_h.jsp"/>
	<!-- 保险小常识 内容部分  开始 -->
		<div class="warr_antywar"><!-- warr_antywar start -->
        	<div class="warr_antysub"><!-- warr_antysub start -->
            	<div class="warr_content"><!-- warr_content start -->
                	<div class="warr_title"><!-- warr_title start -->
                    	<h4>保险知识问答</h4>
                        <p>我们提供保险知识问答，详情查考下方内容</p>
                    </div><!-- warr_title end -->
                    <div class="mediate_content"><!-- mediate_content start -->
                        <h5>
                        一、何谓保险？
                        </h5>
                        <p>
                        保险，是指投保人根据合同规定，向保险人支付保险费，保险人对于合同约定的可能发生的事故因其发生所造成的财产损失承担赔偿保险金责任，或者当被保险人死亡、伤残、疾病或者达到合同约定的年龄了、期限时承担给付责任的商业保险行为。
                        </p>
                        <p>
                        由此可见，保险是一种按照合同实施的契约行为；保险关系的建立是以合同形式体现的，它既不同于以法规强社会保险，又不同于社会救济性质的慈善事业。
                        </p>
                        <h5>
                        二、保险有什么特点？
                        </h5>
                        <p>
                        保险作为一种特殊的金融商品，它有以下一些特点：
                        </p>
                        <p>
                        一是补偿性。无论是经济赔款还是给付保险金，都是一种经济补偿。
                        </p>
                        <p>
                        二是契约性。保险的经济补偿是通过合同的形式来实现的，双方都有各自的权利与义务，都受到合同的约束。
                        </p>
                        <p>
                        三是科学性。统计学的大数法则，是保险产生的客观依据和合理计算收取保险费的理论依据。
                        </p>
                        <p>
                        四是互助必一。某人被保险人通过投保来承担其他被保险人所发生损失的一部分，同时也把自己的风险损失摊给其他被保险人。这种“人人为我，我为人人”的做法，充分说明了保险的互助性。
                        </p>
                        <h5>
                       	三、我们为什么要买保险？
                        </h5>
                        <p>
                        常言道“天有不测风云，人有旦夕祸福”。为了与各种形式的灾害、事故作斗争，人们在长期的生产和生活实践中总结出了与自然灾害、意外事故作斗争的三项主要措施：1、预防；2、、抢救；3、经济补偿。其中，预防措施虽可减少灾害、事故的发生以及发生后导致的损失，但不能完全避免灾害、事故的发生；抢救措施只能在灾害、事故发生的损失；救济的办法也无法使被救济的人得到充分的保障；而储蓄，这种只靠自己积蓄的力量往往是十分有限的，因此，买保险（参加保险）就成了一种只花少量资金而在灾害、事故发生后却可获得较高保障的好办法。
                        </p>
                        <h5>
                        四、什么叫保险人？
                        </h5>
                        <p>
                        保险人又称承保人，其法律上的资格可以是自然人也可以是法人。我国《保险法》上明确规定，保险人是法人即保险公司。
                        </p>
                        <p>
                        我国《保险法》和有关行政法规规定，保险公司必须经国家保险监督管理部门的批准，依法登记注册，取得经营保险业务的许可证，且不同类型的保险公司必须扔有不同规定数量的实收资本金方可开业经营，其实收货币资本金必须按其总额的一定比例，作为保证金存入指定的银行，以保持保险公司应有的偿付能力，维护被保险人的利益。
                        </p>
                        <h5>
                        五、什么叫投保人？
                        </h5>
                        <p>
                        投保人也称要保人，指在签订保险合同前向保险人提出投保申请的人。如保险人接受其投保申请，则投保人即与保险人订立保险合同，并承担交纳保险费的义务。投保人也是保险合同的当事人之一，在一般情况下，投保人就是被保险人（在人寿保险和个别财产保险中也有例外）。
                        </p>
                        <h5>
                        六、什么叫被保险人？
                        </h5>
                        <p>
                        被保险人是指保险事故（事件）在其财产或其身体上发生而受到损失、损害时，享有向保险人要求赔偿或给付权利的人。
                        </p>
                        <h5>
                        七、什么叫受益人？
                        </h5>
                        <p>
                        受益人也叫保险金受领人，是指由被保险人或投保人在合同中约定、在保险事故发生后直接向保险人行使赔偿请求权的人。受益人是保险合同的关系人，不是每一个保险合同必有的对象。其一般在人寿保险合同的死亡保险中出现，即只有在被保险人死亡之后才能行使赔偿请求权的人。在保险合同中，可以明确指定具体的受益人也可不明确指定；如果没有明确指定，被保险人的保险金就作为被保险人的遗产，由其继承人按继承法继承。
                        </p>
                        <h5>
                        八、保险代理人为谁代理？
                        </h5>
                        <p>
                        保险代理人是保险业务的中介人之一，是受保险人委托，在保险人授权范围内接受保险业务，向保险人收取代理手续费的人。代理人可以是法人也可以是自然人。
                       </p>
                        <h5>
                        九、保险经纪人为谁经纪？
                        </h5>
                        <p>
                        保险经纪人也是保险业务中的中介人之一，俗称“保险掮客”。它是投保人的利益、为投保人与保险人订立保险合同等保险业务提供中介服务。保险经纪人利用其娴熟的保险技术为投保人寻找保险公司，并洽谈保险业务，但其不能瓦投保人订阅保险合同（除非投保人有特别约定）。经纪人虽然代表投保人的利益，但仍然向承保的保险人收取佣金，因为在国际上保险人的业务往往来自于经纪人的活动。
                        </p>
                        <p>
                        经纪人与代理人在法律地位上是不同的，他代表了投保人的利益，如由于经纪人的疏忽或差错而造成投保人的经济损失，经纪人必须承担法律上的赔偿责任。
                        </p>
                        <p>
                        我国《保险法》规定，经纪人必须是法人，必须按有关法规才能成立；不允许经纪人自留任何保险业务。目前我国正在酝酿恢复保险经纪人制度。
                        </p>
                        <h5>
                        十、什么是保险公估人？
                        </h5>
                        <p>
                        保险公估人也是保险中间人之一。他是为保险当事人办理保险标的的查勘、鉴定、估损等核定赔偿事务并给予证明、并向委托人收取劳务费的人。公估人可以接受被保险人的委托也可以接受保险人的委托，主要是应用其技术专长，客观地为委托人进行查勘、定责、检验、鉴定、估损及赔款的理算等工作。
                        </p>
                        <h5>
                        十一、什么叫保险标的？
                        </h5>
                        <p>
                        保险标的是保险保障的目标和实体，是保险合同双方当事人权利和义务所指向的对象，是确定保险关系和保险责任的依据。损失保险的标的是财产或与财产有关的利益和责任。
                        </p>
                        <h5>
                        十二、什么叫保险费率？
                        </h5>
                        <p>
                        保险费率是依照保险金额计算保险费的比例，通常以百分率或千分率来表示。费率的大小一般由保险标的危险程度、发生保险事故及损失程度的概率、经营费用等因素经科学计算而确定的。
                        </p>
                        <p>
                        全国性险种的保险费率由保险监督机构厘定并颁布，各家保险公司均得按此执行。如财产保险、机动车辆保险、船舶保险等险种的条款、保险费率均由保险监督机构确定。而一些地方性的险种如家庭财产保险、个体工商户财产保险，其条款、费率由某家保险公司的省级以上公司报经保险监督机构审批后，按批准的保险费率执行。
                        </p>
                        <h5>
                        十三、什么叫保险金额？
                        </h5>
                        <p>
                        保险金额是保险合同双方当事人约定的保险人于保险事故发生后应赔偿（给付）保险金的限额，它是保险人据以计算保险费的基础。在财产保险合同中，保险金额应依据实际价值或保险费价值确定。保险金额是承担保险责任的最高限额；在人身险保险合同中，保险金额是保险事故发生后保险人给付的最高金额。人身保险的对象是人的生命和身体。因为人的生命和身体无法以金钱来估价，所以人身保险合同中的保险金额只能由保险合同双方当事人在订立合同时协商确定。
                        </p>
                        <h5>
                        十四、什么叫保险费？
                        </h5>
                        <p>
                        保险费简称为保费，是投保人参加保险时所交付给保险人的费用。交纳保险费是投保人应尽的义务。保险合同订立后，投保人应按照约定交付保险费，否则保险人不能按约定的时间开始承担保险责任，保险合同不能生效。
                        </p>
                        <p>
                        保险费的多少，根据保险金额、保险费率、保险期限来计算确定。通常计算方法是：
                        </p>
                        <p>
                        保险费=保险金额*保险费率*保险期限
                        </p>
                        <h5>
                        十五、什么叫保险金？
                        </h5>
                        <p>
                        保险金是指被保险人因保险事故发生并因发生而造成的经济损失或保险合同期满，按合同约定由保险人赔偿或给付的金额。
                        </p>
                        <p>
                        在补偿性保险合同中保险金也称为赔款。
                        </p>
                        <h5>
                        十六、什么叫投保单？
                        </h5>
                        <p>
                        投保单也称保险申请书或要保书。投保单指投保人要求参加保险并正式签署的书面文件，是保险人接受承保以后据此签发保险单的凭证。
                        </p>
                        <p>
                        投保单的主要内容有：投保的险别、投保人名称、保险标的、保险金额、保险费率、保险费、投保人地址及保险标的坐落地、保险责任起讫日期和投保人签章、投保日期等。
                        </p>
                        <p>
                        保险人签发保险单后，与投保单一起构成一份完整的保险合同。投保单应由投保人自己或在保险公司职员指导下填写。投保单北面书有保险条款。
                        </p>
                        <h5>
                        十七、什么叫保险单？
                        </h5>
                        <p>
                        保险单简称为保单，是载明了保险人与投保人（被保险人）所约定的义务和权利的书面凭证。保单上的主要内容和投保单完全一致，由保险人签发，其正本交由被保险人存执；当被保险人需变更保险合同内容、或遭受保险事故并产生损失向保险人索赔或期满要求给付时，它是重要依据，也是保险人处理赔款时的主要依据。保险单背面书有保险条款。
                        </p>
                        <h5>
                        十八、什么叫批单？
                        </h5>
                        <p>
                        批单亦称“背书”，是变更保险合同内容的一种补充文件；经过签章后附贴在保险单上的批单与保险单具有同样的法律效力。
                        </p>
                        <p>
                        通常用批单形式来变更保险合同内容的主要有下列一些情况：变更被保险人（包括被保险人更名、财产转让等）；变更保险标的名称代号，如船名、车辆牌照的改变；变更财产坐落地，包括被保险人迁址、财产坐落地增加、减少等；保险金额的变更，如企财险中的保险财产的增减、被保险人接受赔款以后保险金额的减少，变动保险费率、退保等。一般保险合同内容需变更应由被保险人提出申请，经保险人同意后由保险人签发批单。
                        </p>
                        <p>
                        凡经批单变更了保险合同的部分内容，均以批单为准，多次批改的，以最后批改为准。
                        </p>
                        <h5>
                        十九、什么叫保险条款？
                        </h5>
                        <p>
                        保险条款是指保险合同内注明的条文，是保险合同双方当事人的权利及义务以及其他保险事项，是当事人履行保险合同的依据；保险合同只有将必要的条款记载明白后才能生效。
                        </p>
                        <p>
                        根据我国有关法律规定（《保险法》、《中华人民共和国合同法》），保险合同条款应包括以下主要内容：
                        </p>
                        <p>
                        1、合同当事人的名称（姓名）和住所。
                        </p>
                        <p>
                        2、保险标的。
                        </p>
                        <p>
                        3、保险金额。
                        </p>
                        <p>
                        4、保险费。
                        </p>
                        <p>
                        5、保险危险。
                        </p>
                        <p>
                        6、除外责任及赔付方法。
                        </p>
                        <p>
                        7、保险责任的起止期限。
                        </p>
                        <p>
                        8、争议条款。
                        </p>
                        <p>
                        9、订约的时间。
                        </p>
                        <p>
                        10、其他需说明的事项。
                        </p>
                        <h5>
                        二十、什么叫保险事故？
                        </h5>
                        <p>
                        保险事故，是指被保险人遭受保险合同中载明的责任范围内的灾害、事故而致使保险标的损失的事故。发生保险事故也称为“出险”。
                        </p>
                        <p>
                        被保险人只有在发生保险事故时才有权向保险人申请赔偿。被保险人遭受非保险事故而产生的损失，保险人无赔偿的义务。
                        </p>
                        <h5>
                        二十一、什么叫再保险？
                        </h5>
                        <p>
                        再保险也称为分保，俗称为保险的保险。再保险是指保险人将承保的危险责任的一部分或全部向其他保险人再投保的行为。将危险责任转移的一方称原保险人，也称分出人或分出公司，承受危险责任的一方称为再保险人，也称分保接受人或分保接受公司。如果再保险人将接受的业务再分给另一个保险人，这叫做转分保。
                        </p>
                        <h5>
                        二十二、什么叫可保利益？
                        </h5>
                        <p>
                        可保利益亦称保险利益，是指投保人对于保险标的具有法律上认可的一种经济上的利害关系，即保险标的损害或灭失会使投保人或被保险人遭受经济上的损失。如果投保人或被保险人对保险标的具有这样的关系，就具有可保利益，否则就不具有可保利益。可保利益是保险合同成立的必要条件。
                        </p>
                        <p>
                        对可保利益这一概念的理解应从以下三个方面去掌握：
                        </p>
                        <p>
                        1、可保利益必须是合法的利益。它体现为：一是标的存在的合法性；二是投保人与标的关系的合法性。
                        </p>
                        <p>
                        2、可保利益只是一种经济上的利益。它必须是可以用货币来计量的利益。对于不能以货币经济损失，如精神创伤、刑事处罚、政治打击之类，保险是无法也不应予以补偿的。在人身险中，由于人是保险标的，人身保险的可保利益不纯粹以经济上的利益为限。
                        </p>
                        <p>
                        3、可保利益必须是确定的利益。它包含了现在已确定的利益和能够确定的利益两层含义。现在已确定的利益可以用货币量为利益大小；能够确定的利益是指期待利益或预期利益。如运费、利润、租金、存款利息等。预期利益的保险在国内保险业务中已逐步取得发展，如利润损失保险已作为一个独立险种在开办。
                        </p>
                        <h5>
                        二十三、什么叫最大诚信原则？
                        </h5>
                        <p>
                        保险合同必须建立在双方最大诚信的基础上，任何一方如有违反，另一方有权提出合同无效。
                        </p>
                        <p>
                        最大诚信原则的主要内容就是告知与保证。
                        </p>
                        <p>
                        告知，是指投保人在申请签订保险合同时，必须将有关保险标的危险的重要事实如实告诉保险人，如告知不实，漏报或误报，保险人有权解除合同或拒绝赔偿。保证，是指投保人或被保险人对保险人所作的特定担保事项，即保证合同中的保证条款，是被保险人在合同有效期内应遵循义务的一部分。保险人对投保人或被保险人同样有告知和保证的责任和义务，其主要形式是保险条款的告知，它一般都印在投保单和保险单的背面，保险人还负有及时、合理、准确的赔偿责任。
                        </p>
                        <h5>
                        二十四、什么叫近因原则？
                        </h5>
                        <p>
                        近因原则是保险当事人处理保险赔案，或法庭审理有关保险赔偿的诉讼案，在调查事件发生的起因和确定事件责任的归属时所遵循的。按照近因原则，当保险人承保的风险事故是引起保险标的损失的近因时，保险人应负赔偿（给付）责任。也就是说保险的赔偿限于以保险危险的发生为原因，造成保险标的损失为结果，只有在两者之间具有直接的因果关系时，才能构成保险人对于损失赔偿的责任。
                        </p>
                        <p>
                        所谓近因，是指造成损失的直接的有效的原因，并不是指时间上最近的原因，即效果上最近的原因。近来学者、法官对“近因”一般统一解释为：近因不是指最初的原因也不是最终的原因，而是一种能动而有效的原因，这既指原因和结果之间有直接的联系，又指原因十分强大而有力，以致在一连串事件中，人们从各个阶段上可以逻辑地预见下一事件，直到发生意料中的结果。如果有多种原因同时起作用，近因是其中导致结果的起决定作用的或强有力的原因。
                        </p>
                        <h5>
                        二十五、什么叫损失补偿原则？
                        </h5>
                        <p>
                        保险的损失补偿原则是指投保人与保险人订立保险合同，将特定的危险转移给保险人承担；当保险事故发生时，保险人给予被保险人的经济赔偿恰好填补被保险人遭受保险事故的经济损失。“填补损失”在保险关系中称为“补偿”。
                        </p>
                        <p>
                        保险补偿的原则是经过有关法律确定的，它通常包括两层含义:一是保险合同订立以后，保险标的遭受保险事故而产生损失，被保险人有权按合同的约定，获得全面、充分的补偿；二是保险人对被保险人的赔偿恰好使保险标的恢复到未出险前的状况，即保险补偿以被保险人的实际损失为限，被保险人不能因保险赔偿而获得额外的经济利益。
                        </p>
                        <p>
                        损失补偿原则只适用财产保险及补偿型的保险，如医疗保险，而对人寿险适用性不大。
                        </p>
                        <h5>
                        二十六、什么叫权益转让原则？
                        </h5>
                        <p>
                        权益转让原则，是指在财产保险业务中保险人赔偿了被保险人的损失，而保险事故的责任者是第三者，那么被保险人在向保险人索赔后应将保险标的有关权益转让给保险人，且有义务协助保险人向第三者追偿。这一原则是民法中代位原则在保险中的体现，其依据是保险损失补偿原则。权益转让原则不适用于人身保险。
                        </p>
                        <p>
                        权益转让原则也就是代位原则，代位首先是权利代位，即对第三者权利由被保险人向保险人转移。换言之，如保险事故是由第三者造成的，则被保险人可以向第三者请求赔偿，也可以向保险人请求补偿，如果被保险人选择了后者，那么保险人在履行了保险赔偿责任之后，便从被保险人那里取得了以赔偿金额为限的向第三者请求赔偿的权利，故权利代位又称代位求偿、代位追偿等。
                        </p>
                        <p>
                        在权利代位时有三个问题应注意：一是权利转移时是在保险赔偿之时，被保险人应签发权益转让书；二是保险人行使代位追偿权向第三者追偿时可以以被保险人的名义，也可以以保险人自己的名义；三是保险人的代位追偿权以其实际支付的保险赔偿金额为限。
                        </p>
                        <p>
                        其次是物上的代位，即保险标的所有权向保险人转移。物上代位通常发生于全损或推定全损的保险事故的处理。即保险人对于保险标的所发生的损失，在赔付了全部保险金额后，即可获得保险标的的所有权。物上的代位有两种情况：一是委付。委付一般发生在推定全损时，被保险人在向保险人请求全部损失赔偿的同时，应将保险标的委付给保险人；保险人在履行赔偿责任时可以接受委付也可以不接受委付，如接受委付便取得了物上代位权，被保险人这时不能再撤回委付书。二是实际全损。保险人按实际损失对被保险人进行足额赔偿之后，对保险标的享有所有权。
                        </p>
                        <h5>
                        二十七、投保前、投保时应注意哪些事项？
                        </h5>
                        <p>
                        投保前主要做好咨询、调查、综合分析工作，根据自己的实际情况选择合适的险种。
                        </p>
                        <h5>
                        二十八、保险单（投保单）中有时为什么需要有特别约定？
                        </h5>
                        <p>
                        保险合同是一种附合合同，合同的内容一般是按保险监督部门的规定事先拟定好的，具有通用性的特点。这样一来，在具体的地区具体的情况下，对投保人就不完全适用。因此具体操作时，在不违规的情况下，可经双方当事人的协商同意，作适当的微调，即对条款内容作一些局部的变更、补充、删减，以适应具体情况，更好地表达双方的意愿。其形式，一般采用“特别约定”来实现。
                        </p>
                        <p>
                        特别约定的内容必须满足下列三个条件：1、不能违背我国当前的有关法规和社会道德规范；2、不能违背保险监管部门的有关规定；3、必须是保险双方当事人共同的意愿。
                        </p>
                        <p>
                        特别约定可以格式化，也可非格式化，但必须同时附贴在投保单、保险单上，并加盖骑缝章，或填写在投保单、保险单的特别约定栏内，这样才能和保险合同具有同等的法律效力。
                        </p>
                        <h5>
                        二十九、对同一保险标的可以重复投保吗？如果重复投保了出险后可以重复索赔吗？
                        </h5>
                        <p>
                        这个问题不是一概而论的。对于以人的生命和身体为保险标的投保的，一般不存在重复投保的问题。因为人的生命、身体是无法用货币来计算其经济价值的，因此其可保利益不纯粹以经济上的利益为限。
                        </p>
                        <p>
                        但对于财产保险则不可以重复投保，即使发生了重复保险也不可能获得重复的赔偿，就是说被保险人不能获得超过损失金额的赔偿。
                        </p>
                        <h5>
                        三十、保险合同与附加合同是何关系？
                        </h5>
                        <p>
                        这里所指的保险合同与附加合同是指主险（基本险）的合同和附加险的合同。因为保险公司开办的主险往往具有较广泛的适应性，为了满足广大投保人的需要，一般会在主险的基础上增加办理附加险，用以扩大保险责任或增加保险金额（主要在寿险中出现）。附加险的主要特点是：
                        </p>
                        <p>
                        1、附加险不是独立的保险合同，保险公司不单独办理，只有办理主险时才能办理附加险。如家庭财产保险的附加盗窃险，只有投保家庭财产保险时才能投保附加盗窃险。
                        </p>
                        <p>
                        2、投保人、被保险人及受益人等关系人的权利、义务等，在附加条款中未加明确事项按主险相关约定执行。
                        </p>
                        <p>
                        3、附加险的合同不能单独存在，即主险合同因失效、解约或期满等原因，效力终止时，附加险合同也随之终止。
                        </p>
                        <p>
                        4、附加险合同的保险费应与主险的交费约定一并交纳。附加险的保险费率都有独立的标准。
                        </p>
                        <h5>
                        三十一、投保后如想中途退保可以吗？
                        </h5>
                        <p>
                        根据保险自愿的原则，投保人一般是可以中途退保的。退保，也就是投保人（被保险人）在保险合同终止期未到时，要求解除保险合同，即解除合同双方当事人之间的关系。对于交纳保险费的险种，退保时保险人一般只退还从退保之日起到保期终止之日止期间的保险费。对于带有储蓄性质的险种，退何时保险人按原保险合同的有关约定退还已交纳的保险费（储金）。
                        </p>
                        <p>
                        我国《保险法》第三十四条规定：“货物运输保险合同和运输工具航程保险合同，保险责任开始后，合同当事人不得解除合同。”根据此规定，投保人、保险人均无权解除合同；但在保险责任开始前，即保险的货物未启运前，保险的运输工具未启航前（未行驶前），投保人还是可以退保的，但退保时保险人可以收取一定的手续费。
                        </p>
                        <h5>
                        三十二、保险合同签订后都是有效的吗？
                        </h5>
                        <p>
                        通常情况下，保险合同签订后都是有效的，但在某些情况下也会无效。无效的情况有下列几种：1、从无效原因来分，有约定无效和法定无效；2、从无效范围来分，有全部无效和失效。
                        </p>
                        <p>
                        无效合同产生的原因主要有以下几种：1、订立保险合同时危险已经发生或危险不存在，如汽车在签订机动车辆损失保险时该车已被撞毁。2、投保人（被保险人）对保险标的不具有保险利益；3、恶意的重复保险（主要指财产保险）；4、财产险中非恶意的超额保险，其中超过实际价值或保险价值部分保险金额无效，合同其他部分仍有效；5、以死亡为给付保险金条件的合同，未经被保险人书面同意并认可保险金额的合同无效；6、人身保险中被保险人真实年龄已超过保险人所规定的年龄的。
                        </p>
                        <h5>
                        三十三、被保险人索赔的一般程序有哪些？
                        </h5>
                        <p>
                        索赔的程序如下：
                        </p>
                        <p>
                        1、在保险事故发生时（后），应立即通知保险人（俗称“报案”），将保险事故的基本情况报给保险人，这些情况包括灾害事故发生的时间、地点，属何种灾害事故、可能的原因、施救情况、保险标的损失概况等，报案可以用电话、传真、电报、派员等方式进行。无论用什么方法报案，最终保户均需填写由保险公司印出险通知书和损失清单。
                        </p>
                        <p>
                        2、协助保险人进行现场查勘（一般财产保险的事故现场均需查勘）或进行调查，查明灾害事故的原因和损失情况，接受保险公司理赔业务人员的询问，提供查勘的方便。
                        </p>
                        <p>
                        3、向保险公司提供灾害事故的证明、有关单证等，以便保险公司能准确、迅速、合理地定责、定损。
                        </p>
                        <p>
                        4、接到保险公司赔偿或给付的通知后，被保险人（或受益人）对保险公司确定的赔款金额如无异议，在10日内向保险公司领取赔款。
                        </p>
                        <p>
                        顺便提一下，关于索赔时效问题，即被保险人如投保的是人寿保险以外的险种，自其知道保险事故发生之日起，如两年内不行使索赔权，则其索赔权就自动消失，也就是说索赔的时效只有两年，而人寿险的索赔时效为五年。
                        </p>
                        <h5>
                        三十四、什么叫相对免赔率和相对免赔额？什么叫绝对免赔率和绝对免赔额？
                        </h5>
                        <p>
                        相对免赔、绝对免赔都是限额赔付的方式之一。用这两种限额赔付，一般原因都出自于减少小额赔款的理赔以简化手续，或被保险人为节约保险费的开支，或保险人为增强被保险人对保险标的的保护意识而采取的一种方式。
                        </p>
                        <p>
                        相对免赔，即当保险标的的损失率或损失金额超过相对免赔率或相对免赔额时，保险人才对被保险人的全部损失负赔偿责任，其赔偿的计算公式是：
                        </p>
                        <p>
                        赔偿金额=保险金额*损失率（必须是：损失率&gt;相对免赔率）；
                        </p>
                        <p>
                        或：
                        </p>
                        <p>
                        赔偿金额=损失金额（必须是：损失金额&gt;相对免赔额）
                        </p>
                        <p>
                        绝对免赔，当保险标的的损失率或损失金额超过绝对免赔率或绝对免赔额时，保险人仅对超过的部分负责赔偿。其赔偿的计算公式是：
                        </p>
                        <p>
                        赔偿金额=保险金额*（损失率-绝对免赔率）,（必须是：损失率&gt;绝对免赔率）；
                        </p>
                        <p>
                        或：
                        </p>
                        <p>
                        赔偿金额=损失金额-绝对免赔额（必须是：损失金额&gt;绝对免赔额）。
                        </p>
                        <p>
                        采用相对免赔、绝对免赔时，都应在保险合同中明确约定，约定采取哪种形式，及其具体数字或数额。
                        </p>
                        <h5>
                        三十五、在索赔过程中与保险公司发生争议怎么办？
                        </h5>
                        <p>
                        根据我国合同法和保险合同的有关规定可以按以下办法处理：
                        </p>
                        <p>
                        1、保险合同当事人双方按我国现行的有关法律和保险合同的规定进行协商解决。
                        </p>
                        <p>
                        2、在协商不成时可提交仲裁机构进行仲裁。
                        </p>
                        <p>
                        3、可不经仲裁直接向法院起诉，或经仲裁后一方对仲裁裁决拒不履行，另一方也可向法院起诉。
                        </p>
                        <h5>
                        三十六、什么是保证保险？
                        </h5>
                        <p>
                        保证保险，是指被保证人（债务人）根据权利人（债权人）的要求，请求保险人（保险公司）担保自己的信用的保险。
                        </p>
                        <h5>
                        三十七、什么是人身保险？
                        </h5>
                        <p>
                        人身保险是以人的寿命和身体为保险标的的保险，它包括人寿保险、意外伤害保险和健康保险三部分。
                        </p>
                        <p>
                        今天，随着社会的不断进步和经济的健康发展，人身保险的险种日益增多，不仅能满足被保险人死亡、伤残、养老等保障的需要，而且能满足被保险人的生育、子女教育和婚嫁等方面的需要。人身保险的主要目的有两个方面：一是保障因被保险人死亡所致家庭损失的经济补偿，减轻家庭或子女的经济负担，使其遗属能够获得一定收入，以维持生活及偿付债务之需；二是储蓄资金，以备将来自己生活所需。前者属保障型的，后者为储备型的。另外，根据法律规定，保险赔款可免纳个人所得税。
                        </p>
                        <h5>
                        三十八、什么是人寿保险？
                        </h5>
                        <p>
                        人寿保险是以人的寿命为保险标的、以人的生死为保险事故的保险；它又可以分为生存保险、死亡保险和“两全”保险三种。
                        </p>
                        <p>
                        生存保险是以被保险人在保险期满时仍然生存为给付条件的人寿保险。死亡保险是以被保险人的死亡为保险事故的人寿保险，其又分为定期寿保和终身寿保；前者保险期限是某一期间，后者的保险期限是被保险人的一生。“两全”保险的两全是指，保险人对被保险人在保险期内死亡需给付，在保险期满仍也需给付。
                        </p>
                        <h5>
                        三十九、什么是健康保险？
                        </h5>
                        <p>
                        健康保险也称疾病保险，是指被保险人在保险有效期内因患病所发生医疗费用支出，或因疾病所致残疾或死亡时，或因疾病、伤害不能工作而减少收入时，由保险人负责给付的一种保险。健康保险承保的主要内容有两大类，其一是由一疾病或意外伤害事故所用的医疗费用；其二是由于疾病或意外伤害事故所致的收损失。前者称医疗保险，后者称残废收补偿保险。
                        </p>
                        <p>
                        医疗保险一般有90~180天的观察期。即在投保后90~180天内发生疾病住院，保险人不负保险责任。只有在90~180天之后，保险公司才负保险责任。
                        </p>
                        <h5>
                        四十、什么是人身意外伤害保险？其责任范围是什么？
                        </h5>
                        <p>
                        人身意外伤害保险是指在约定的保险期内，因发生意外事故而导致被保险人死亡或残疾，保险公司按照双方的约定，向被保险人或受益人支付一定量的保险金的一种保险。这些伤害责任一般是指非本意的、外来的、不可预料的原因造成的，不能和人为事件混为一谈。但目前有些保险公司开设的此类险种，其保险责任比较宽，既负责意外伤害的保险责任，又负责因意外产生到医院抢救的一部分医疗费用。
                        </p>
                        <p>
                        意外伤害的责任范围有：爆炸、倒塌、烫灼、碰撞、雷击、触电、扭折、冻伤、中暑、淹溺、窒息、坠跌、急性中毒、被袭击，车辆、船舶、飞机失事以及劳动操作、使用机器时，发生的工伤事故等引起的伤害责任。
                        </p>
                        <h5>
                        四十一、什么是财产保险？
                        </h5>
                        <p>
                        财产保险(Property Insurance)是指投保人根据合同约定，向保险人交付保险费，保险人按保险合同的约定对所承保的财产及其有关利益因自然灾害或意外事故造成的损失承担赔偿责任的保险。 财产保险，包括财产保险、农业保险、责任保险、保证保险、信用保险等以财产或利益为保险标的的各种保险。
                        </p>
                        <p>
                        财产保险有广义与狭义之分。广义财产保险是指以财产及其有关的经济利益和损害赔偿责任为保险标的的保险；狭义财产保险则是指以物质财产为保险标的的保险。在保险实务中，后者一般称为财产损失保险。
                        </p><!--!doctype-->

					</div><!-- mediate_content end -->
				</div><!-- warr_content end -->
			</div><!-- warr_antysub end -->
		</div><!-- warr_antywar end -->
		<!-- 保险小常识 内容部分  结束 -->
        
	<jsp:include page="../index/multi_f.jsp" />
</body>

<%--<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>--%>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';

$(function(){
	$(".nav ul li").each(function(){
		$(this).attr("class","");
	});
	var co = 1;
	$(".nav ul li").each(function(){
		if(co == 1){
			$(this).attr("class","active");
		}
		co ++;
	});
});
</script>
</html>
