<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>

<table class="table">
	<thead>
	<tr>
		<th>登录名</th>
		<th>姓名</th>
		<th>角色</th>
		<th>邮箱</th>
		<th>联系方式</th>
		<th>状态</th>
		<th>开通时间</th>
		<th>操作</th>
	</tr>
	</thead>
	<tbody>
	<c:choose>
		<c:when test="${empty list }">
			<tr><td colspan="8" style="text-align: center;">无查询结果</td></tr>
		</c:when>
		<c:otherwise>
			<c:forEach items="${list }" var="user">
				<tr>
					<td>${user.userName }</td>
					<td>${user.realName }</td>
					<td>	<c:if test="${fn:contains(user.roleName,'KEFU')==true}">客服</c:if>
						<c:if test="${fn:contains(user.roleName,'YUNYING')==true}">运营</c:if></td>
					<td>${user.email }</td>
					<td>${user.telephone }</td>
					<td><c:if test="${not empty user.status && user.status eq 1}">正常</c:if><c:if test="${not empty user.status && user.status eq 0}">失效</c:if></td>


					<td>
							${user.create_time }
						<%--<c:if test="${not empty user.create_time}"><fmt:formatDate pattern='yyyy-MM-dd' value='${user.create_time }'/></c:if>--%>
					</td>
					<td>
						<a href="javascript:void(0);" onclick="updUserModal('${user.oid}',1);">查看</a>
							<%--<a href="javascript:void(0);" onclick="openAssignedInitModel('${user.oid }');">停用</a>
							<a href="javascript:void(0);" onclick="openAssignedInitModel('${user.oid }');">分配产品</a>--%>
					</td>
				</tr>
			</c:forEach>
		</c:otherwise>
	</c:choose>
	</tbody>
</table>