<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<h4 class="mt-60">查询结果</h4>
<div class="query-result" id="pageResult">
	<table class="table">
		<thead>
			<tr>
				<th>用户名</th>
				<th>企业名称</th>
				<th>所在省市</th>
				<th>统一社会信用码</th>
				<th>账户状态</th>
				<th>资料审核状态</th>
				<th>银行账户验证结果</th>
				<th>注册时间</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty userList }">
				<tr><td colspan="9" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${userList }" var="companyUser">
					<tr>
						<td>${companyUser.userName }</td>
						<td>${companyUser.company.fullName }</td>
						<td>${companyUser.company.provinceName }${companyUser.company.cityName }</td>
						<td>${companyUser.company.idNumber }</td>
						<td>${companyUser.userStatus.name }</td>
						<td>${companyUser.company.bankStatus.name }</td>
						<td>${companyUser.company.companyStatus.name }</td>
						<td><fmt:formatDate pattern='yyyy-MM-dd' value='${companyUser.registerDate }'/></td>
						<td>
							<a href="javascript:void(0);" onclick="showCompanyDetail('${companyUser.company.oid}');" class="check-chit">详情</a>
							<c:if test="${companyUser.userStatus eq 'DISCARD' && companyUser.company.bankStatus eq 'PASS' && companyUser.company.companyStatus eq 'PASS' }">
							<a href="javascript:void(0);" onclick="activate('${companyUser.oid}');" class="check-chit" style="margin-bottom:10px">激活该账号</a>
							</c:if>
							<c:if test="${companyUser.userStatus eq 'ACTIVATE' && companyUser.company.bankStatus eq 'PASS' && companyUser.company.companyStatus eq 'PASS' }">
							<a href="javascript:void(0);" onclick="discard('${companyUser.oid}');" class="check-chit" style="margin-bottom:10px">失效该账号</a>
							</c:if>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
</nav>
<!-- 分页 end -->
<script>

	function showCompanyDetail(companyId) {
		layer.open({
			type : 2,
			skin: 'agreementModal',
			shadeClose: true,
			title : '详情',
			shade : 0.8,
			scrollbar : false,
			area : [ '80%', '90%' ],
			content : baseUrl + "/user/getComPanyDetail?companyId=" + companyId //iframe的url
		});

	}

	function activate(companyUserId){
		layer.confirm('确定激活该账号？', {
			  btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var index = layer.load(0, {shade : [ 0.3, '#808080' ]});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/user/activateUser.json",
					data : {"companyUserId":companyUserId},
					dataType : "json",
					success : function(data) {
						layer.close(index);
						layer.msg(data.message);
						if(data.status =="200")
							submitOrderForm();
					},
					error : function() {
						layer.close(index);
					}
				});
			}, function(){}
		);
	}
	function discard(companyUserId){
		layer.confirm('确定失效该账号？', {
			  btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var index = layer.load(0, {shade : [ 0.3, '#808080' ]});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/user/discardUser.json",
					data : {"companyUserId":companyUserId},
					dataType : "json",
					success : function(data) {
						layer.close(index);
						layer.msg(data.message);
						if(data.status =="200")
							submitOrderForm();
					},
					error : function() {
						layer.close(index);
					}
				});
			}, function(){}
		);
	}
	
	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;

	$('#callBackPager').extendPagination({
		totalCount : totalCount,
		showCount : showCount,
		limit : limit,
		callback : function(curr, limit, totalCount) {
			getListForPage();
		}
	});

	function getListForPage() {
		var index = layer.load(1, {
			shade : [ 0.3, '#808080' ]
		});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/user/findCompanyUserListForPage",
			data : $("#orderForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#pageResult").html(data);
			},
			error : function() {
				layer.close(index);
			}
		});
	}
</script>