<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<form id="checkProductForm">
<div class="query-result">
	<table class="table">
		<thead>
			<tr>
				<th class="choice check-box"><input type="checkbox" value="反选" id="pcball" onclick="choiseAll_x('pcball','poids');$('#checkProNum').text($('input[name=poids]:checked').length);">
					<label for="pcball"></label>
				</th>
				<th>ID</th>
				<th>产品名称</th>
				<th>产品类型</th>
				<th>价格</th>
				<th>供应商</th>
			</tr>
		</thead>
		<tbody>
		<input name="resellerID" value="${resellerID }" type="hidden">
		<c:choose>
			<c:when test="${empty productList }">
				<tr><td colspan="6" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${productList }" var="product">
					<tr>
						<td class="choice check-box">
							<input type="checkbox" id="checkbox${product.oid }" value="${product.oid }" name="poids" onclick="choiseOid_x('pcball','poids');$('#checkProNum').text($('input[name=poids]:checked').length);">
							<label for="checkbox${product.oid }"></label>
						</td>
						<td title="${product.oid }">${product.oid }</td>
						<td title="${product.productName }">${product.productName }</td>
						<td>${fns:getDictLabel (product.productType,"product_type","")}</td>
						<td>-<%--${empty product.premiumMin ? '-' : product.premiumMin eq '0.00' ? '-' : product.premiumMin }--%></td>
						<td title="${product.insuranceName }">${product.insuranceName }</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
<div class="btn-bottom pull-left">
	<p>已选择 <span id="checkProNum">0</span> 件产品</p>
</div>
<div class="btn-bottom pull-right"> 
	<p><a href="javascript:void(0);" onclick="selectSomeProduct();" class="clearing pull-left">下一步</a></p>
</div>
</form>