<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<form id="checkAdvanceForm">
<div class="query-result" id="advanceListResultPage">
	<table class="table">
		<thead>
			<tr>
				<th class="choice check-box"><input type="checkbox" value="反选" id="acball" onclick="choiseAll_y('acball','aoids');">
					<label for="acball"></label>
				</th>
				<th>订单编号</th>
				<th>产品名称</th>
				<th>犹豫期/结算日期</th>
				<th>状态</th>
				<th>下单时间</th>
				<th>可得佣金</th>
				<th>下级分销佣金</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty advanceList }">
				<tr><td colspan="8" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${advanceList }" var="advance">
					<tr>
						<td class="choice check-box">
							<c:if test="${advance.advanceStatus == '1'}">
							<input type="checkbox" id="checkbox${advance.oid }" dataStatus="${advance.advanceStatus }" value="${advance.oid }" name="aoids" <c:if test="${advance.advanceStatus eq '1'}">onclick="choiseOid_x('acball','aoids');"</c:if>>
							<label for="checkbox${advance.oid }"></label>
							</c:if>
						</td>
						<td title="${advance.tradeSerialNumber }">${advance.tradeSerialNumber }</td>
						<td title="${advance.insuranceName }">${advance.insuranceName }</td>
						<td>${advance.clearingTime }</td>
						<td>${fns:getDictLabel (advance.advanceStatus,"advance_status","")}</td>
						<td>${advance.startTime }</td>
						<td>${advance.brokerage}</td>
						<td>${advance.brokerageChild}</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
</form>
<div class="btn-bottom pull-right"> 
	<p>
		<c:if test="${isCard eq '1'}">
		<a href="javascript:void(0);" onclick="applicationForWithdrawal();" class="clearing pull-left">结算申请</a>
		</c:if>
		<a href="javascript:void(0);" onclick="addBanCardModal('');" class="clearing pull-left">银行卡绑定</a>
	</p>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="r_callBackPager" style="margin: 0 auto;text-align: center;"></div>
</nav>
<!-- 分页 end -->
<script type="text/javascript" src="<c:url value='/resources/js/reseller.js'/>"></script>
<script>


	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	
	$('#r_callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
            getAdvanceListForPage();
		}
	});

	function getAdvanceListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/pc/reseller/advanceList",
			data : $("#advanceForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#advanceListResultPage").html(data);
			},
			error: function(){
				layer.close(index);
			}
		});
	}
    function cathMsg(){
        layer.message("请先绑定银行卡信息！");
    }

</script>