<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<div class="increased-thead replaces-thead">
	<ul class="clearfix">
		<li class="s1">
			<span>姓名</span>
		</li>
		<li class="s2">
			<span>证件类型</span>
		</li>
		<li class="s3">
			<span>证件号</span>
		</li>
		<li class="s4">
			<span>手机号</span>
		</li>
		<li class="s5">
			<span>工种</span>
		</li>
		<li class="s7">
			<span>性别</span>
		</li>
		<li class="s8">
			<span>出生日期</span>
		</li>
		<li class="s9" style="width: 13%">
			<span>操作</span>
		</li>
	</ul>
</div>
<div class="increased-tbody replaces-tbody">
	<ul>
		<c:choose>
			<c:when test="${empty iprsVoList }">
				<li>
					<p>暂无记录！！</p>
				</li>
			</c:when>
			<c:otherwise>
				<c:forEach items="${ iprsVoList }" var="resultSet" varStatus="i">
					<li class="clearfix">
						<input name="insPreservationDetailVoList[${i.index}].business_id" type="hidden" value="${resultSet.belong_to_id}">
						<input name="insPreservationDetailVoList[${i.index}].business_type" type="hidden" value="${resultSet.belong_to_type}">
						<input name="insPreservationDetailVoList[${i.index}].prev_record_id" type="hidden" value="${resultSet.ins_preservation_record_id}">
						<input name="insPreservationDetailVoList[${i.index}].prev_card" type="hidden" value="${resultSet.id_card}">
						<div class="w1">
							<span>${empty resultSet.name ? '-' : resultSet.name}</span>
							<input title="姓名" data-val="required" name="insPreservationDetailVoList[${i.index}].name" id="name_${i.index}" type="text" onblur="doValidator(this);" value="${resultSet.opposeVo.name}">
						</div>
						<div class="w2">
							<span>
								<c:if test="${resultSet.id_type eq '0'}">身份证</c:if>
								<c:if test="${resultSet.id_type eq '3'}">护照</c:if>
								<c:if test="${resultSet.id_type eq '4'}">台胞证</c:if>
								<c:if test="${resultSet.id_type eq '5'}">回乡证</c:if>
							</span>
							<select name="insPreservationDetailVoList[${i.index}].id_type" id="id_type_${i.index}">
								<option value="0"<c:if test="${resultSet.opposeVo.id_type eq '0'}"> selected</c:if>>身份证</option>
								<option value="3"<c:if test="${resultSet.opposeVo.id_type eq '3'}"> selected</c:if>>护照</option>
								<option value="4"<c:if test="${resultSet.opposeVo.id_type eq '4'}"> selected</c:if>>台胞证</option>
								<option value="5"<c:if test="${resultSet.opposeVo.id_type eq '5'}"> selected</c:if>>回乡证</option>
							</select>
						</div>
						<div class="w3">
							<span>${empty resultSet.id_card ? '-' : resultSet.id_card}</span>
							<input title="证件号" data-val="required" name="insPreservationDetailVoList[${i.index}].id_card" id="id_card_${i.index}" type="text" data-it-sign="id_type_${i.index}" onblur="robotizationGet(this,'sex_${i.index},birthday_${i.index}');" value="${resultSet.opposeVo.id_card}">
						</div>
						<div class="w4">
							<span>${empty resultSet.tel ? '-' : resultSet.tel}</span>
							<input title="手机号" data-val="required" name="insPreservationDetailVoList[${i.index}].tel" id="tel_${i.index}" type="text" onblur="doValidator(this);" value="${resultSet.opposeVo.tel}">
						</div>
						<div class="w5">
							<span>${resultSet.career eq '1' ? '内勤人员' : resultSet.career eq '2' ? '保安人员' : resultSet.career eq '3' ? '武装押运人员' : resultSet.career eq '4' ? '保洁人员' : '-'}</span>
							<select name="insPreservationDetailVoList[${i.index}].career" id="career_${i.index}">
								<c:if test="${!fn:contains(orderVo.product_code,'TYX-QH-DQ')}">
								<option value="1"<c:if test="${resultSet.career eq '1'}"> selected</c:if>>内勤人员</option>
								<option value="2"<c:if test="${resultSet.career eq '2'}"> selected</c:if>>保安人员</option>
								<c:if test="${fn:contains(orderVo.product_code,'TYX')||fn:contains(orderVo.product_code,'GZZRX-CA')||fn:contains(orderVo.product_code,'GZZRX-ZH')||fn:contains(orderVo.product_code,'GZZRX-XZH')}">
									<option value="3"<c:if test="${resultSet.career eq '3'}"> selected</c:if>>武装押运人员</option>
								</c:if>
								<c:if test="${fn:contains(orderVo.product_code,'GZZRX-TB')||fn:contains(orderVo.product_code,'GZZRX-QH')||fn:contains(orderVo.product_code,'GZZRX-PAC')||fn:contains(orderVo.product_code,'GZZRX-CA')||fn:contains(orderVo.product_code,'TYX-CA')}">
									<option value="4"<c:if test="${resultSet.career eq '4'}"> selected</c:if>>保洁人员</option>
								</c:if>
								</c:if>
								<c:if test="${fn:contains(orderVo.product_code,'TYX-QH-DQ')}">
									<option value="2"<c:if test="${resultSet.career eq '2'}"> selected</c:if>>保安人员</option>
								</c:if>
							</select>
						</div>
						<div class="w7">
							<span>${empty resultSet.sex ? '-' : resultSet.sex eq '1' ? '男' : '女'}</span>
							<select name="insPreservationDetailVoList[${i.index}].sex" id="sex_${i.index}" data-it-sign="id_card_${i.index}">
								<option value="1"<c:if test="${resultSet.opposeVo.sex eq '1'}"> selected</c:if>>男</option>
								<option value="2"<c:if test="${resultSet.opposeVo.sex eq '2'}"> selected</c:if>>女</option>
							</select>
						</div>
						<div class="w8">
							<span>${empty resultSet.birthday ? '-' : resultSet.birthday}</span>
							<input title="出生日期" data-val="required" type="text" name="insPreservationDetailVoList[${i.index}].birthday" value="${resultSet.opposeVo.birthday}" id="birthday_${i.index}" data-it-sign="id_card_${i.index}" onclick="laydate({elem:'#birthday_${i.index}',istime: false, format: 'YYYY-MM-DD'})">
						</div>
						<div class="w9" style="width: 13%">
							<span class="shan" onclick="deleteUpdateDetail(this)">删除</span>
						</div>
						<div class="wed"></div>
					</li>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</ul>
</div>
