<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<div class="cont-sd">
	<ul class="cont-head clearfix">
		<li class="cont-a1">
			<span>批改时间</span>
		</li>
		<li class="cont-a2">
			<span>批改类型</span>
		</li>
		<li class="cont-a3">
			<span>姓名</span>
		</li>
		<li class="cont-a4">
			<span>证件类型</span>
		</li>
		<li class="cont-a5" style="width: 19%">
			<span>证件号</span>
		</li>
		<li class="cont-a6">
			<span>手机号</span>
		</li>
		<li class="cont-a7" style="width: 11%">
			<span>工种</span>
		</li>
		<li class="cont-a8">
			<span>出生日期</span>
		</li>
		<%--<li class="cont-a8">
			<span>方案</span>
		</li>--%>
	</ul>
</div>
<div class="cont-wed">
	<ul>
		<c:choose>
			<c:when test="${empty resultSetList }">
				<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
					暂无记录！！
				</li>
			</c:when>
			<c:otherwise>
				<c:forEach items="${resultSetList }" var="resultSet">
					<li class="clearfix">
						<div class="cont-a1">
							<span><fmt:formatDate pattern="yyyy-MM-dd HH:mm" value="${resultSet.revise_time }"/></span>
						</div>
						<div class="cont-a2">
							<span>${fns:getDictLabel (resultSet.revise_type,"revise_type","")}</span>
						</div>
						<div class="cont-a3">
							<span>${resultSet.name }</span>
						</div>
						<div class="cont-a4">
							<span>
								<c:if test="${empty resultSet.id_type}">-</c:if>
								${fns:getDictLabel (resultSet.id_type,"idType","")}
								<%--<c:if test="${resultSet.id_type eq '0'}">身份证</c:if>
								<c:if test="${resultSet.id_type eq '3'}">护照</c:if>
								<c:if test="${resultSet.id_type eq '4'}">台胞证</c:if>
								<c:if test="${resultSet.id_type eq '5'}">回乡证</c:if>--%>
							</span>
						</div>
						<div class="cont-a5" style="width: 19%">
							<span>${resultSet.id_card }</span>
						</div>
						<div class="cont-a6">
							<span>${resultSet.tel }</span>
						</div>
						<div class="cont-a7" style="width: 11%">
							<span>${resultSet.career eq '1' ? '内勤人员' : resultSet.career eq '2' ? '保安人员' : resultSet.career eq '3' ? '武装押运人员' : resultSet.career eq '4' ? '保洁人员' : '-'}</span>
						</div>
						<div class="cont-a8">
							<span>${resultSet.birthday }</span>
						</div>
						<%--<div class="cont-a8">
							<span onclick="do_scheme();">查看</span>
						</div>--%>
					</li>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</ul>
</div>