<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
	</head>

	<body>
	<jsp:include page="../../../index/multi_h.jsp"/>
	<div class="container">
		<%--<div class="addr">
			<span>当前位置：</span>
			<span class="current">首页 > </span>
			<a class="active" href="#">我的账户</a>
		</div>--%>
		<jsp:include page="../../../index/multi_pc_l.jsp"/>

		<!--右边内容块-->
		<ul class="order-list wed-list" id="wed-list">
			<li onclick="openResultSet();">在保人员</li>
			<li class="active">已失效成员</li>
			<li onclick="openRecordList();">批改申请记录</li>
		</ul>
		<div class="assure-safe tab-con">
			<div class="assure-head  failure-head clearfix">
				<p>关键字</p>
				<div class="assure-input">
					<input type="text" id="keyword_it" value="${keyword }" placeholder="请填写姓名/手机号/证件号">
				</div>
				<div class="failure-time">
					<span>批改时间</span>
					<input type="text" id="start-w1" value="${start_time }">
					<i>至</i>
					<input type="text" id="end-w1" value="${end_time }">
				</div>
				<a href="javascript:;" onclick="searchList()">搜索</a>
			</div>
			<div class="assure-text">
				<ul class="clearfix">
					<li class="assure-logo">
						<c:if test="${not empty orderVo.insurance_logo && fn:contains(orderVo.insurance_logo, '?')}">
							<img src="${orderVo.insurance_logo}" style="width: 196px" />
						</c:if>
					</li>
					<li >
						<p><strong>${orderVo.product_name}</strong></p>
						<p>保单号: <i>${orderVo.external_reference}</i></p>
						<p>起保日期: <i>${orderVo.inception_date}</i></p>
					</li>
				</ul>
			</div>
			<div class="assure-cont tab-order failure-cont">
				<div id="resultSetsArea">
					<div class="cont-sd">
						<ul class="cont-head clearfix">
							<li class="cont-a1">
								<span>批改时间</span>
							</li>
							<li class="cont-a2">
								<span>批改类型</span>
							</li>
							<li class="cont-a3">
								<span>姓名</span>
							</li>
							<li class="cont-a4">
								<span>证件类型</span>
							</li>
							<li class="cont-a5" style="width: 19%">
								<span>证件号</span>
							</li>
							<li class="cont-a6">
								<span>手机号</span>
							</li>
							<li class="cont-a7" style="width: 11%">
								<span>工种</span>
							</li>
							<li class="cont-a8">
								<span>出生日期</span>
							</li>
							<%--<li class="cont-a8">
								<span>方案</span>
							</li>--%>
						</ul>
					</div>
					<div class="cont-wed">
						<ul>
							<c:choose>
								<c:when test="${empty resultSetList }">
									<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
										暂无记录！！
									</li>
								</c:when>
								<c:otherwise>
									<c:forEach items="${resultSetList }" var="resultSet">
										<li class="clearfix">
											<div class="cont-a1">
												<span><fmt:formatDate pattern="yyyy-MM-dd HH:mm" value="${resultSet.revise_time }"/></span>
											</div>
											<div class="cont-a2">
												<span>${fns:getDictLabel (resultSet.revise_type,"revise_type","")}</span>
											</div>
											<div class="cont-a3">
												<span>${resultSet.name }</span>
											</div>
											<div class="cont-a4">
												<span>
													<c:if test="${empty resultSet.id_type}">-</c:if>
													${fns:getDictLabel (resultSet.id_type,"idType","")}
												</span>
											</div>
											<div class="cont-a5" style="width: 19%">
												<span>${resultSet.id_card }</span>
											</div>
											<div class="cont-a6">
												<span>${resultSet.tel }</span>
											</div>
											<div class="cont-a7" style="width: 11%">
												<span>${resultSet.career eq '1' ? '内勤人员' : resultSet.career eq '2' ? '保安人员' : resultSet.career eq '3' ? '武装押运人员' :  resultSet.career eq '4' ? '保洁人员' : '-'}</span>
											</div>
											<div class="cont-a8">
												<span>${resultSet.birthday }</span>
											</div>
											<%--<div class="cont-a8">
												<span onclick="do_scheme();">查看</span>
											</div>--%>
										</li>
									</c:forEach>
								</c:otherwise>
							</c:choose>
						</ul>
					</div>
				</div>
				<!--分页-->
				<div class="filter-pagination" style="padding-top:10px;">
					<div id="callBackPager"></div>
				</div>
				<%--<ul class="paper-num">

				</ul>--%>
			</div>
		</div>
	</div>

	<div class="clearfix"></div>
	<form id="resultSetForm" action="<c:url value='/pc/preservation/resultSet/noResultSetList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
		<input type="hidden" name="policyId" value="${orderVo.oid}"/>
		<input type="hidden" id="keyword" name="keyword" value="${keyword}"/>
		<input type="hidden" id="start_time" name="start_time" value="${start_time}"/>
		<input type="hidden" id="end_time" name="end_time" value="${end_time}"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
	</div>

	<!--方案弹窗-->
	<div class="scheme-incre animated">
		<div class="scheme-head">
			<span>方案</span>
			<a href="javascript:;" id="popo-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div class="scheme-content" id="scheme_detail">

		</div>
	</div>

	<!--黑色蒙版-->
	<div class="black-mask"></div>
	<jsp:include page="../../../index/multi_f.jsp"/>

	</body>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/assure.js' />"></script>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
        $(function () {
            function mouse(even, stat, iconA, iconB) {
                $('.order-detail').on(even, '.guar', function () {
                    $(this).siblings('.guar-list').css('display',stat);
                    $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
                });
            }
            //鼠标移动到元素上显示
            mouse('mouseenter', 'block', 'down-icon', 'up-icon');
            //鼠标移出元素
            mouse('mouseleave', 'none', 'up-icon', 'down-icon');
        })
        var totalCount = Number($('#totalCount').val()) || 0;
        var showCount = $('#showCount').val() || 5;
        var limit = Number($('#numPerPage').val()) || 5;

        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("resultSetForm","resultSetsArea");
            }
        });

        function searchList(){
            $("#pageNum").val(1);
            $("#numPerPage").val(5);
            $("#totalCount").val(0);
            $("#start_time").val($("#start-w1").val());
            $("#end_time").val($("#end-w1").val());
            $("#keyword").val($("#keyword_it").val());
            $("#resultSetForm").submit();
        }

        function openResultSet(){
            location.href=baseUrl+'/pc/preservation/resultSet/resultSetList?policyId=${orderVo.oid}&ACCESS_TOKEN=${ACCESS_TOKEN}';
		}

        function openRecordList(){
            location.href=baseUrl+'/pc/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}';
        }

        function loadDataAndPage(){
            totalCount = Number($('#totalCount').val()) || 0;
            $('#callBackPager').extendPagination({
                totalCount: totalCount,
                showCount: showCount,
                limit: limit,
                callback: function (curr, limit, totalCount) {
                    getListForPage("resultSetForm","resultSetsArea");
                }
            });
        };


        function getListForPage(formId,contentId){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/resultSet/getNoResultSetListForPage",
                data : $("#"+formId).serialize(),
                dataType : "text",
                success : function(data) {
                    layer.close(index);
                    $("#"+contentId).html(data);
                },
                error: function(){
                    layer.close(index);
                }
            });
        }

        function choisePolicyStatus(policyStatus,totalCount,obj){
            $(".order-list li").removeClass("active");
            $(obj).addClass("active");
            $("#policyStatus").val(policyStatus);
            $('#totalCount').val(totalCount);
            $('#pageNum').val("1");
            loadDataAndPage();
            getListForPage("resultSetForm","resultSetsArea");
        }

        function refreshTotal(policyStatus){
            var id="";
            if(policyStatus =="1"){
                id = "INSSUM";
            }else if(policyStatus =="4"){
                id = "NOPAYSUM";
            }

            var total = Number($("#"+id).html());
            var totalCount = total -1;
            var numPerPage = Number($('#numPerPage').val());
            var pageNum = Number($("#pageNum").val());
            if(totalCount%numPerPage ==0)
                pageNum = pageNum -1;

            $("#"+id).html(totalCount);
            $('#totalCount').val(totalCount);
            $('#pageNum').val(pageNum);
            loadDataAndPage();

            $("#callBackPager li").each(function(){
                $(this).removeClass('active');
                if ($(this).find('a').html() == pageNum) {
                    $(this).addClass('active');
                }
            });

            getListForPage("resultSetForm","resultSetsArea");
        }
	</script>
</html>
<%--<script src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/corrections.js' />"></script>--%>
<script>
	$('ul.aside-list li').removeClass('on');
	$("#myPreservation").addClass('on');
</script>