<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="order-num wed-num">
	<li class="width-s1">
		<span>单号信息（<a href="javascript:downRecordList();">导出清单</a>）</span>
	</li>
	<li class="width-s2">
		<span>批改类型</span>
	</li>
	<li class="width-s2">
		<span>生效日期</span>
	</li>
	<li class="width-s2">
		<span>保全金额</span>
	</li>
	<li class="width-s2">
		<span>批改状态</span>
	</li>
	<li class="width-s2">
		<span>提交时间</span>
	</li>
	<li class="width-s2">
		<span>操作</span>
	</li>
</ul>
<ul class="tab-body">
	<c:choose>
		<c:when test="${empty iprList }">
			<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
				暂无记录！！
			</li>
		</c:when>
		<c:otherwise>
			<c:forEach items="${iprList }" var="ipr">
				<li class="clearfix">
					<div class="no no-number">
						<p class="clearfix">
							<b>${not empty ipr.revise_serial_num_ins ? '批改单号' : '暂批单号'}</b>
							<i title="${not empty ipr.revise_serial_num_ins ? ipr.revise_serial_num_ins : ipr.revise_serial_number}">${not empty ipr.revise_serial_num_ins ? ipr.revise_serial_num_ins : ipr.revise_serial_number}</i>
						</p>
						<p class="clearfix">
							<b>保单号</b>
							<i title="${ipr.external_reference }">${ipr.external_reference }</i>
						</p>
					</div>
					<div class="no no-styles">
						<span>${fns:getDictLabel (ipr.revise_type,"revise_type","")}</span>
					</div>
					<div class="no no-date">
						<span><fmt:formatDate value="${ipr.inception_date }" pattern="yyyy-MM-dd" /></span>
					</div>
					<div class="no no-money">
						<span>${empty ipr.total_premium ? '' : '￥'}${empty ipr.total_premium ? '-' : ipr.total_premium}</span>
					</div>
					<div class="no no-status">
						<span<c:if test="${ipr.revise_status eq '3'}"> style="color: red;"</c:if>>${fns:getDictLabel (ipr.revise_status,"revise_status","")}</span>
					</div>
					<div class="no no-time">
						<span><fmt:formatDate value="${ipr.start_time }" pattern="yyyy-MM-dd" /></span>
					</div>
					<div class="no no-handle">
						<c:if test="${ipr.revise_status eq '1'||ipr.revise_status eq '3'}">
							<p class="pro-delete" onclick="deletePreservationRecord('${ipr.ins_preservation_record_id }');">删除</p>
						</c:if>
						<c:choose>
							<c:when test="${ipr.revise_status eq '1'}">
								<c:if test="${ipr.revise_type eq '1'}">
									<p class="s1" onclick="do_preservation('add','${ipr.ins_preservation_record_id }');">详情</p>
								</c:if>
								<c:if test="${ipr.revise_type eq '2'}">
									<p class="s2" onclick="do_preservation('minus','${ipr.ins_preservation_record_id }');">详情</p>
								</c:if>
								<c:if test="${ipr.revise_type eq '3'}">
									<p class="s3" onclick="do_preservation('replace','${ipr.ins_preservation_record_id }');">详情</p>
								</c:if>
							</c:when>
							<%-- 审批中状态 增员类型 存在支付地址 --%>
							<c:when test="${ipr.revise_status eq '2'}">
								<c:if test="${ipr.revise_type eq '1' && not empty ipr.revise_pay}">
									<p onclick="do_revisePay('${ipr.revise_pay}');">支付</p>
									<p class="pro-delete" onclick="revokePreservationRecord('${ipr.ins_preservation_record_id }');">撤销</p>
								</c:if>
								<p class="handle-xiang" data-pre-id="${ipr.ins_preservation_record_id }" onclick="openRecordDetail('${ipr.ins_preservation_record_id }');">详情</p>
							</c:when>
							<c:otherwise>
								<p class="handle-xiang" onclick="openRecordDetail('${ipr.ins_preservation_record_id }');">详情</p>
							</c:otherwise>
						</c:choose>
						<c:if test="${not empty ipr.revise_path && (ipr.revise_status eq '4' || ipr.revise_status eq '5' ) }">
							<p class="handle-ert" onclick="loadCanvas('${ipr.revise_path }');">批改单</p>
							<c:if test="${ipr.revise_type eq '1' && not empty ipr.revise_pay}">
								<p class="pro-delete" onclick="requestInvoice('${ipr.e_invoice_url }','${ipr.ins_preservation_record_id }',this);">发票</p>
							</c:if>
						</c:if>
					</div>
				</li>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</ul>
<%--
<form id="preservationForm">
	<input type="hidden" id="start_time" name="start_time" value="${start_time }"/>
	<input type="hidden" id="end_time" name="end_time" value="${end_time }"/>
	<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
	<input type="hidden" id="revise_status" name="revise_status" value="${revise_status }"/>
	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
</form>--%>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/child_corrections.js' />"></script>
<script>
    $('.no-handle .handle-xiang').click(function () {
        $('.correcting-details').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();

        $('#correcting-tab-wed .correcting-s7').click(function () {
            wed_index = $(this).parents("li").index();
            $('.med-delete').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
            $('.black-mask-more').show();
        });

        $('.med-delete .voucher-true').click(function () {
            $('ul#correcting-tab-wed li').eq(wed_index).remove();
            $('.med-delete').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
            $('.black-mask-more').hide();
        })
        $('.med-delete .voucher-false').click(function () {
            $('.med-delete').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
            $('.black-mask-more').hide();
        });
        $('#med-bibi').click(function () {
            $('.med-delete').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
            $('.black-mask-more').hide();
        });


    });
    $('.con-s1 .no-handle .handle-ert').click(function () {
        $('.correct-scan').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    });
</script>