<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="order-num wed-num">
	<li class="width-s3">
		<span>单号信息</span>
	</li>
	<li class="width-s3">
		<span>保险公司</span>
	</li>
	<li class="width-s3">
		<span>增员人数</span>
	</li>
	<li class="width-s3">
		<span>减员人数</span>
	</li>
	<li class="width-s3">
		<span>替换人数</span>
	</li>
	<li class="width-s3">
		<span>状态</span>
	</li>
	<li class="width-s3">
		<span>金额</span>
	</li>
	<li class="width-s3">
		<span>结算时间范围</span>
	</li>
	<li class="width-s3">
		<span>操作</span>
	</li>
</ul>
<ul class="tab-body">
	<c:choose>
		<c:when test="${empty payList }">
			<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
				暂无记录！！
			</li>
		</c:when>
		<c:otherwise>
			<c:forEach items="${payList }" var="pay">
				<li class="clearfix">
					<div class="no-cont">
						<span>${pay.external_reference }</span>
					</div>
					<div class="no-cont">
						<span>${pay.company_name }</span>
					</div>
					<div class="no-cont">
						<span>${pay.add_count}人</span>
					</div>
					<div class="no-cont">
						<span>${pay.minus_count }人</span>
					</div>
					<div class="no-cont">
						<span>${pay.replace_count }人</span>
					</div>
					<div class="no-cont">
						<span>${fns:getDictLabel (pay.pay_status,"payStatus","")}</span>
					</div>
					<div class="no-cont">
						<span>${empty pay.fact_total_amount ? '' : '￥'}${empty pay.fact_total_amount ? '-' : pay.fact_total_amount}</span>
					</div>
					<div class="no-cont">
						<p>${pay.star_pay_time }</p>
						<i>至</i>
						<p>${pay.end_pay_time }</p>
					</div>
					<div class="no-cont">
						<a href="javascript:;" onclick="openPayDetail('${pay.oid }');" class="po-details">详情</a>
						<c:if test="${pay.pay_status eq '1'||pay.pay_status eq '2' }">
							<a href="javascript:;" onclick="uploadPay('${pay.oid }');loadCanvas('${pay.pay_order_path }');" class="a-progress">上传缴费凭证</a>
						</c:if>
						<c:if test="${pay.pay_status eq '3'&&fn:contains(pay.product_code,'GZZRX-CA')}">
							<a href="javascript:;" onclick="getFP('${pay.oid }');" class="a-progress">发票下载</a>
						</c:if>
					</div>
				</li>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</ul>
<script>
    $('.no-cont .po-details').click(function () {
        $('.details-popover').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
        var s = $('.popo-tbody').height();
        if(s <= 400){

            $('.details-popover .popo-content').css({"overflow":"hidden"})
        }
    });
    /*$('.no-cont .progress').click(function () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    });*/
    $('.con-s2 .tab-content .tab-body .no-cont:first-child span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 12){
            $(this).css({"line-height":"24px","margin-top":"25px"});
        }
    });
    $('.con-s2 .tab-content .tab-body .no-cont:nth-child(2) span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 8){
            $(this).css({"line-height":"24px","margin-top":"25px"});
        }
    });
</script>