<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<div class="increased-cont">
	<h2>企业人员变动-员工离职，可在保单中减少相应的被保险人。</h2>
	<form id="minus_detail_list_form">
		<div class="increased-time clearfix">
			<div class="time">
				<span>生效时间</span>
				<input title="生效时间" type="text" data-val="required" readonly id="minus_inception_date" name="inception_date" value="${insDate}">
			</div>
		</div>
		<div class="increased-table redues-table" id="minus-increased-table">
			<div class="increased-thead redues-thead">
				<ul class="clearfix">
					<li class="s3">
						<span>订单号</span>
					</li>
					<li class="s3">
						<span>保单号</span>
					</li>
					<li class="s3">
						<span>产品名称</span>
					</li>
					<li class="s3">
						<span>起保日期</span>
					</li>
					<li class="s8">
						<span>减员人数</span>
					</li>
					<li class="s9">
						<span>操作</span>
					</li>
				</ul>
			</div>
			<div class="increased-tbody redues-tbody">
				<ul>
					<c:choose>
						<c:when test="${empty policyList }">
							<li >
								<p >暂无记录！！</p>
							</li>
						</c:when>
						<c:otherwise>
							<c:forEach items="${policyList }" var="policy" varStatus="i">
								<li class="clearfix" style="margin-left: 0;padding-top: 0!important;">
									<div class="w3">
										<span>
											${empty policy.tradeSerialNumber ? '-' : policy.tradeSerialNumber}
										</span>
									</div>
									<div class="w3">
										<span>
											${empty policy.policyNo ? '-' : policy.policyNo}
										</span>
									</div>
									<div class="w3">
										<span>
											${empty policy.productName ? '-' : policy.productName}
										</span>
									</div>
									<div class="w3">
										<span>
											${empty policy.inceptionDate ? '-' : policy.inceptionDate}
										</span>
									</div>
									<div class="w8">
										<span>
											${empty policy.num ? '-' : policy.num}
										</span>
									</div>
									<div class="w9">
										<a class="shan" style="line-height: 60px!important;cursor: pointer;" onclick="batch_minus_save_preservation(this,'${policy.orderId}','${policy.importBatchId}')">减员</a>
									</div>
								</li>
							</c:forEach>
							<li style="text-align: center; line-height: 45px;">
								<p >没有更多待减员记录了！！</p>
							</li>
						</c:otherwise>
					</c:choose>
				</ul>
			</div>

		</div>
	</form>
</div>
<div class="increased-foot">
	<span class="incre-cancel">取消</span>
</div>
<script>
    $('.increased-foot .incre-cancel').click(function () {
        $('.redues-increased').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
        $('.black-mask').hide();
    });
</script>